/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.simplexml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.util.valuemgmt.ValueManager;

public class SimpleXMLElement {
    SimpleXMLElement m_parent;
    String m_name;
    Map<String, String> m_values = new HashMap<String, String>();
    List<SimpleXMLElement> m_subElements = new ArrayList<SimpleXMLElement>();
    String m_text;

    public SimpleXMLElement(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setValue(String name, String value) {
        this.m_values.put(name, value);
    }

    public String getValue(String name) {
        return this.m_values.get(name);
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public Map<String, String> getValueMap() {
        return this.m_values;
    }

    public void removeAllSubElements() {
        this.m_subElements.clear();
    }

    public void removeValue(String name) {
        this.m_values.remove(name);
    }

    public void removeAllSubElements(String name) {
        if (name == null) {
            this.removeAllSubElements();
        } else {
            for (int i = this.m_subElements.size() - 1; i >= 0; --i) {
                if (!name.equals(this.m_subElements.get(i).getName())) continue;
                this.m_subElements.remove(i);
            }
        }
    }

    public void removeSubElement(SimpleXMLElement subElement) {
        this.m_subElements.remove(subElement);
    }

    public List<SimpleXMLElement> getSubElements() {
        return this.m_subElements;
    }

    public List<SimpleXMLElement> getSubElements(String name) {
        ArrayList<SimpleXMLElement> result = new ArrayList<SimpleXMLElement>();
        for (SimpleXMLElement sub : this.m_subElements) {
            if (!ValueManager.checkIfStringsAreEqual(name, sub.getName())) continue;
            result.add(sub);
        }
        return result;
    }

    public SimpleXMLElement getSubElement(String name) {
        for (SimpleXMLElement sub : this.m_subElements) {
            if (!ValueManager.checkIfStringsAreEqual(name, sub.getName())) continue;
            return sub;
        }
        return null;
    }

    public SimpleXMLElement addSubElement(String name) {
        SimpleXMLElement result = this.createNewInstance(name);
        result.m_parent = this;
        this.m_subElements.add(result);
        return result;
    }

    public void addSubElement(SimpleXMLElement xmle) {
        this.m_subElements.add(xmle);
        xmle.m_parent = this;
    }

    public void addSubElement(int index, SimpleXMLElement xmle) {
        this.m_subElements.add(index, xmle);
        xmle.m_parent = this;
    }

    public SimpleXMLElement getParent() {
        return this.m_parent;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        this.createXML(sb, 0, false);
        return sb.toString();
    }

    public String toXML(boolean withSubElementSorting) {
        StringBuffer sb = new StringBuffer();
        this.createXML(sb, 0, withSubElementSorting);
        return sb.toString();
    }

    protected void sortSubElementsForOutput(List<SimpleXMLElement> subs) {
        Collections.sort(subs, new Comparator<SimpleXMLElement>(){

            @Override
            public int compare(SimpleXMLElement o1, SimpleXMLElement o2) {
                String s1 = o1.getName();
                String s2 = o2.getName();
                if (s1 == null) {
                    s1 = "";
                }
                if (s2 == null) {
                    s2 = "";
                }
                return s1.compareTo(s2);
            }
        });
    }

    protected SimpleXMLElement createNewInstance(String name) {
        return new SimpleXMLElement(name);
    }

    protected void createXML(StringBuffer xml, int level, boolean withSorting) {
        String indent = ValueManager.createEmptyString(level * 4);
        xml.append(indent);
        xml.append("<" + this.m_name);
        ArrayList<String> attNames = new ArrayList<String>();
        for (String string : this.m_values.keySet()) {
            attNames.add(string);
        }
        Collections.sort(attNames);
        int counter = 0;
        for (String attName : attNames) {
            String value = this.m_values.get(attName);
            if (value == null) continue;
            if (counter == 0) {
                xml.append(" ");
            } else {
                xml.append("\n");
                xml.append(indent);
                xml.append(ValueManager.createEmptyString(this.m_name.length() + 2));
            }
            value = ValueManager.encodeIntoValidXMLString(value);
            xml.append(attName + "=\"" + value + "\"");
            ++counter;
        }
        if (this.m_subElements.size() > 0) {
            ArrayList<SimpleXMLElement> subs = new ArrayList<SimpleXMLElement>(this.m_subElements);
            if (withSorting) {
                this.sortSubElementsForOutput(subs);
            }
            xml.append(">\n");
            for (SimpleXMLElement simpleXMLElement : subs) {
                simpleXMLElement.createXML(xml, level + 1, withSorting);
            }
            xml.append(indent);
            xml.append("</" + this.m_name + ">");
        } else if (this.m_text != null && this.m_text.length() > 0) {
            xml.append(">");
            xml.append(ValueManager.encodeIntoValidXMLValueString(this.m_text));
            xml.append("</" + this.m_name + ">");
        } else {
            xml.append("/>");
        }
        xml.append("\n");
    }
}

