/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.simplexml;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.log.ULog;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleXMLParser
extends DefaultHandler {
    SimpleXMLElement m_root = null;
    SimpleXMLElement m_current = null;
    boolean m_beforeProcessingChildren = true;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.m_root == null) {
            this.m_root = this.m_current = new SimpleXMLElement(name);
        } else {
            this.m_current = this.m_current.addSubElement(name);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getQName(i);
            String attValue = attributes.getValue(i);
            if (attName == null || attValue == null) continue;
            this.m_current.setValue(attName, attValue);
        }
        this.m_beforeProcessingChildren = true;
    }

    @Override
    public void characters(char[] chars, int start, int end) throws SAXException {
        if (this.m_current == null) {
            return;
        }
        if (this.m_beforeProcessingChildren) {
            if (this.m_current.getText() == null) {
                this.m_current.setText("");
            }
            this.m_current.setText(this.m_current.getText() + new String(chars, start, end));
        } else {
            this.m_current.setText(null);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.m_current = this.m_current.getParent();
        this.m_beforeProcessingChildren = false;
    }

    public static SimpleXMLElement parseXML(String xml) {
        return SimpleXMLParser.parseXML(xml, false);
    }

    public static SimpleXMLElement parseXML(String xml, boolean withError) {
        try {
            if (xml == null) {
                return null;
            }
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            SimpleXMLParser cxp = new SimpleXMLParser();
            parser.parse(is, (DefaultHandler)cxp);
            return cxp.m_root;
        }
        catch (Throwable t) {
            String s = xml;
            if (s != null && s.length() > 1000) {
                s = s.substring(0, 1000) + "...";
            }
            if (!withError) {
                ULog.logINF("Problem when parsing XML: " + s, t);
                return null;
            }
            throw new Error("Problem parsing XML: " + t + ". XML: " + s, t);
        }
    }

    public static String createXML(SimpleXMLElement xe) {
        return xe.toXML();
    }

    public static String createXML(SimpleXMLElement xe, boolean withSubElementSorting) {
        return xe.toXML(withSubElementSorting);
    }
}

