/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.editor.tools;

import org.eclnt.editor.tools.ProjectInfo;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectInfoParser
extends DefaultHandler {
    ProjectInfo m_projectInfo;

    public ProjectInfoParser(ProjectInfo pi) {
        this.m_projectInfo = pi;
    }

    public ProjectInfo getProjectInfo() {
        return this.m_projectInfo;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String s2;
        String s1;
        ProjectInfo.HotDeploymentPackage hdp;
        String s;
        if (name.equals("project")) {
            String keepgeneratedids;
            String checkForUpdatedFiles;
            String cpe;
            String copywebappIgnore;
            String allowclean;
            s = attributes.getValue("projectdirectory");
            if (s != null) {
                this.m_projectInfo.setProjectdirectory(ValueManager.encodeIntoValidFileName(s, true));
            }
            this.m_projectInfo.setManagedByCCToolSet(ValueManager.decodeBoolean(attributes.getValue("managedbycctoolset"), true));
            this.m_projectInfo.setWebappaddonsdirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("webappaddonsdirectory"), true));
            this.m_projectInfo.setWebcontentdirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("webcontentdirectory"), true));
            this.m_projectInfo.setWebcontentdeployfromdirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("webcontentdeployfromdirectory"), true));
            this.m_projectInfo.setWebcontentdeploydirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("webcontentdeploydirectory"), true));
            this.m_projectInfo.setRuntimeServletTempDirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("runtimeservlettempdirectory"), true));
            this.m_projectInfo.setWebcontextroot(attributes.getValue("webcontextroot"));
            this.m_projectInfo.setJavasourcedirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("javasourcedirectory"), true));
            this.m_projectInfo.setPropertyfilesdirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("propertyfilesdirectory"), true));
            this.m_projectInfo.setPropertyFilesUTF8(ValueManager.decodeBoolean(attributes.getValue("propertyFilesUTF8"), false));
            this.m_projectInfo.setJavasourcewebinfdirectory(attributes.getValue("javasourcewebinfdirectory"));
            this.m_projectInfo.setJavaclassdirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("javaclassdirectory"), true));
            this.m_projectInfo.setJavaclasswebinfdirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("javaclasswebinfdirectory"), true));
            this.m_projectInfo.setWebhostport(attributes.getValue("webhostport"));
            this.m_projectInfo.setCopywebapp(attributes.getValue("copywebapp"));
            this.m_projectInfo.setBeanBrowserClassLoader(attributes.getValue("beanbrowserclassloader"));
            this.m_projectInfo.setResourcesInSource(ValueManager.decodeBoolean(attributes.getValue("resourcesinsource"), true));
            this.m_projectInfo.setResourcesInWebContent(ValueManager.decodeBoolean(attributes.getValue("resourcesinwebcontent"), true));
            s = attributes.getValue("layoutdefinintionssavedasxml");
            this.m_projectInfo.setLayoutDefinitionsSavedAsXml(ValueManager.decodeBoolean(s, false));
            s = attributes.getValue("webprotocol");
            if (s != null) {
                this.m_projectInfo.setWebprotocol(s);
            }
            if ((allowclean = attributes.getValue("allowclean")) != null) {
                this.m_projectInfo.setAllowclean(ValueManager.decodeBoolean(allowclean, true));
            }
            if ((s = attributes.getValue("allowversionupdatebytoolset")) != null) {
                this.m_projectInfo.setAllowversionupdatebytoolset(ValueManager.decodeBoolean(s, true));
            }
            if ((copywebappIgnore = attributes.getValue("copywebappignore")) != null) {
                this.m_projectInfo.setCopywebappIgnore(ValueManager.decodeCSV(copywebappIgnore));
            }
            String projectfilestoredinprojectdirectory = attributes.getValue("projectfilestoredinprojectdirectory");
            this.m_projectInfo.setProjectfileStoredInProjectDirectory(ValueManager.decodeBoolean(projectfilestoredinprojectdirectory, false));
            this.m_projectInfo.setJavaSourceEncoding(attributes.getValue("javasourceencoding"));
            if (this.m_projectInfo.isCopywebapp()) {
                this.m_projectInfo.setReloadwebapp("true");
            }
            if ((s = attributes.getValue("reloadwebapp")) != null) {
                this.m_projectInfo.setReloadwebapp(s);
            }
            if ((cpe = attributes.getValue("classpathextension")) != null) {
                this.m_projectInfo.setClassPathExtension(cpe.replace('\\', '/'));
            }
            this.m_projectInfo.setAxis2Home(ValueManager.encodeIntoValidFileName(attributes.getValue("axis2home"), true));
            this.m_projectInfo.setPreviewbgpaint(attributes.getValue("previewbgpaint"));
            if (this.m_projectInfo.getPreviewbgpaint() == null) {
                this.m_projectInfo.setPreviewbgpaint("rectangle(0,0,100%,100%,#FFFFFF)");
            }
            if ((checkForUpdatedFiles = attributes.getValue("checkforupdatedfiles")) != null && "false".equals(checkForUpdatedFiles)) {
                this.m_projectInfo.setCheckForUpdateFiles("false");
            }
            this.m_projectInfo.setExpressionManager(attributes.getValue("expressionmanager"));
            this.m_projectInfo.setCommandlinefilenotwriteable(attributes.getValue("commandlinefilenotwriteable"));
            this.m_projectInfo.setUitestcasedirectory(ValueManager.encodeIntoValidFileName(attributes.getValue("uitestcasedirectory"), true));
            this.m_projectInfo.setHtStylePath(attributes.getValue("htstylepath"));
            this.m_projectInfo.setHtPdaStylePath(attributes.getValue("htpdastylepath"));
            String dispatchername = attributes.getValue("dispatchername");
            if (dispatchername != null) {
                this.m_projectInfo.setDispatchername(dispatchername);
            }
            if ((keepgeneratedids = attributes.getValue("keepgeneratedids")) != null) {
                this.m_projectInfo.setKeepGeneratedIds(ValueManager.decodeBoolean(keepgeneratedids, false));
            }
            this.m_projectInfo.setDeployinfofilename(attributes.getValue("deployinfofilename"));
        }
        if (name.equals("embeddedfunctions")) {
            s = attributes.getValue("class");
            boolean b = ValueManager.decodeBoolean(attributes.getValue("errorifnotavailable"), true);
            if (s != null) {
                this.m_projectInfo.addEmbeddedFunctions(s, b);
            }
        }
        if (name.equals("template")) {
            this.m_projectInfo.addTemplateInfo(attributes.getValue("resource"), attributes.getValue("image"));
        }
        if (name.equals("additionalresource")) {
            this.m_projectInfo.addAdditionalResourceInfo(attributes.getValue("package"), attributes.getValue("name"), attributes.getValue("expressionprefix"));
        }
        if (name.equals("additionalmanagedbean")) {
            String ambName = attributes.getValue("name");
            String ambClassName = attributes.getValue("class");
            if (ambName != null && ambClassName != null) {
                this.m_projectInfo.addManagedBeanInfoDT(ambName, ambClassName);
            }
        }
        if (name.equals("deploycopyinfo")) {
            String fromdir = attributes.getValue("fromdir");
            String fromzip = attributes.getValue("fromzip");
            String todir = attributes.getValue("todir");
            String ignorecsv = attributes.getValue("ignorecsv");
            String s3 = attributes.getValue("ignoreduringhotdeployment");
            boolean ignoreDuringHotDeployment = ValueManager.decodeBoolean(s3, false);
            if ((fromdir != null || fromzip != null) && todir != null) {
                this.m_projectInfo.createAdditionalDeployInfo(fromdir, fromzip, todir, ignorecsv, ignoreDuringHotDeployment);
            }
        }
        if (name.equals("codegenerator")) {
            s = attributes.getValue("memberprefix");
            if (s != null) {
                this.m_projectInfo.setCodegeneratorMemberprefix(s);
            }
            if ((s = attributes.getValue("indent")) != null) {
                this.m_projectInfo.setCodegeneratorIndent(ValueManager.decodeInt(s, 4));
            }
            if ((s = attributes.getValue("membervisibility")) != null) {
                this.m_projectInfo.setCodegeneratorMembervisibility(s);
            }
            if ((s = attributes.getValue("uiclasssuffix")) != null) {
                this.m_projectInfo.setCodegeneratorUIClassSuffix(s);
            }
        }
        if (name.equals("packageabbreviation")) {
            String packagename = attributes.getValue("packagename");
            String abbreviation = attributes.getValue("abbreviation");
            if (packagename != null && abbreviation != null) {
                this.m_projectInfo.addPackageAbbreviation(packagename, abbreviation);
            }
        }
        if (name.equals("hotdeploymentpackage") && (s = attributes.getValue("name")) != null) {
            hdp = new ProjectInfo.HotDeploymentPackage();
            hdp.setName(s);
            this.m_projectInfo.getHotDeploymentPackages().add(hdp);
        }
        if (name.equals("hotdeploymentpackageexclude") && (s = attributes.getValue("name")) != null) {
            hdp = new ProjectInfo.HotDeploymentPackage();
            hdp.setName(s);
            this.m_projectInfo.getHotDeploymentPackagesExclude().add(hdp);
        }
        if (name.equals("pagebeancomponentcopy")) {
            s1 = attributes.getValue("jspdirectory");
            s2 = attributes.getValue("packagename");
            if (s1 != null && s2 != null) {
                ProjectInfo.EditorPageBeanComponentInfo editorPageBeanComponentInfo = this.m_projectInfo.addPageBeanCopyInfo(s1, s2);
            }
        }
        if (name.equals("deepl")) {
            s1 = attributes.getValue("apikey");
            s2 = attributes.getValue("translationcontext");
            if (s1 != null) {
                this.m_projectInfo.setDeeplAPIKey(s1);
            }
            if (s2 != null) {
                this.m_projectInfo.setDeeplTranslationContext(s2);
            }
        }
        if (name.equals("texttoliteralid")) {
            s = attributes.getValue("attributeignore");
            if (s != null) {
                this.m_projectInfo.getTextToLiteralIdInfo().getAttributeIgnore().addAll(ValueManager.decodeCSVToList(s));
            }
            if ((s = attributes.getValue("attributeinclude")) != null) {
                this.m_projectInfo.getTextToLiteralIdInfo().getAttributeInclude().addAll(ValueManager.decodeCSVToList(s));
            }
            this.m_projectInfo.getTextToLiteralIdInfo().setOtherPrefix(attributes.getValue("otherprefix"));
            this.m_projectInfo.getTextToLiteralIdInfo().setTextPrefix("textprefix");
            this.m_projectInfo.getTextToLiteralIdInfo().setTitlePrefix("titleprefix");
            this.m_projectInfo.getTextToLiteralIdInfo().setTooltipPrefix("tooltipprefix");
            this.m_projectInfo.getTextToLiteralIdInfo().setUserhintPrefix("userhintprefix");
        }
    }
}

