/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.base.faces.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExternalContext {
    HttpSession m_currentSession;
    HttpServletRequest m_currentRequest;
    HttpServletResponse m_currentResponse;
    MappedMap m_mappedMap = new MappedMap();
    Map<String, Object> m_requestMap = new HashMap<String, Object>();
    Map<String, Object> m_sessionMap = new HashMap<String, Object>();

    public void startRequestProcessing(HttpSession session, HttpServletRequest request, HttpServletResponse response) {
        this.m_currentSession = session;
        this.m_currentRequest = request;
        this.m_currentResponse = response;
    }

    public void endRequestProcessing() {
        this.m_currentRequest = null;
        this.m_currentResponse = null;
        this.m_currentSession = null;
        this.m_requestMap.clear();
    }

    public Map<String, String> getRequestParameterMap() {
        return this.m_mappedMap;
    }

    public Object getRequest() {
        return this.m_currentRequest;
    }

    public Object getResponse() {
        return this.m_currentResponse;
    }

    public Object getSession(boolean create) {
        if (create && this.m_currentSession == null) {
            throw new Error("Not implemented!");
        }
        return this.m_currentSession;
    }

    public Map<String, Object> getRequestMap() {
        return this.m_requestMap;
    }

    public Map<String, Object> getSessionMap() {
        return this.m_sessionMap;
    }

    private class MappedMap
    extends HashMap<String, String> {
        private MappedMap() {
        }

        @Override
        public String get(Object key) {
            String[] values = (String[])ExternalContext.this.m_currentRequest.getParameterMap().get(key);
            if (values == null) {
                return null;
            }
            if (values.length == 0) {
                return null;
            }
            return values[0];
        }

        @Override
        public int size() {
            return ExternalContext.this.m_currentRequest.getParameterMap().size();
        }

        @Override
        public Set<String> keySet() {
            return ExternalContext.this.m_currentRequest.getParameterMap().keySet();
        }

        @Override
        public Collection<String> values() {
            throw new Error("Not implemented.");
        }
    }
}

