/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.base.faces.webapp;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;

public class UIComponentTag {
    int m_level = 0;
    String m_id;
    UIComponentTag m_parent;
    List<UIComponentTag> m_children = new ArrayList<UIComponentTag>();
    UIComponent m_bufferedComponent;

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setRendered(String value) {
        throw new Error("Implemented in inheriting class");
    }

    public List<UIComponentTag> getChildren() {
        return this.m_children;
    }

    public void addChild(UIComponentTag child) {
        this.m_children.add(child);
        child.setParent(this);
        child.m_level = this.m_level + 1;
    }

    public UIComponentTag getParent() {
        return this.m_parent;
    }

    public void setParent(UIComponentTag parent) {
        if (parent == null) {
            this.m_parent = null;
        } else if (parent instanceof BaseComponentTag) {
            this.m_parent = (BaseComponentTag)parent;
        } else {
            throw new Error("Parent must be of type BaseComponentTag but is: " + parent.getClass().getName());
        }
    }

    public int doEndTag() throws Exception {
        return 0;
    }

    public void release() {
    }

    public static boolean isValueReference(String attrValue) {
        if (attrValue == null) {
            return false;
        }
        if (attrValue.length() < 2) {
            return false;
        }
        if (attrValue.charAt(0) == '#' && attrValue.charAt(1) == '{' && attrValue.charAt(attrValue.length() - 1) == '}') {
            return true;
        }
        int index1 = attrValue.indexOf("#{");
        int index2 = attrValue.indexOf("}");
        return index1 >= 0 && index2 >= index1;
    }

    public final UIComponent buildUpComponentTree() {
        this.buildUpComponents();
        UIComponent result = this.m_bufferedComponent;
        this.clearBufferedComponent();
        return result;
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        this.dump(sb);
        return sb.toString();
    }

    public int doStartTag() throws Exception {
        return 0;
    }

    private final void buildUpComponents() {
        this.m_bufferedComponent = ((BaseComponentTag)this).createBaseComponent();
        if (this.m_parent != null) {
            this.m_parent.m_bufferedComponent.addChild(this.m_bufferedComponent);
        }
        for (UIComponentTag child : this.m_children) {
            child.buildUpComponentTree();
        }
    }

    private void clearBufferedComponent() {
        this.m_bufferedComponent = null;
        for (UIComponentTag child : this.m_children) {
            child.clearBufferedComponent();
        }
    }

    private void dump(StringBuffer sb) {
        for (int i = 0; i < this.m_level; ++i) {
            sb.append("    ");
        }
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        for (UIComponentTag child : this.m_children) {
            child.dump(sb);
        }
    }
}

