/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bufferedcontent;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import org.eclnt.jsfserver.bufferedcontent.BufferedContentMgr;
import org.eclnt.jsfserver.bufferedcontent.IBufferedContent;
import org.eclnt.jsfserver.bufferedcontent.IBufferedStreamContent;
import org.eclnt.jsfserver.util.CCServletBaseWithContextMgmt;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.PLog;
import org.eclnt.util.mitigation.CCMitigation;
import org.eclnt.util.stream.CountingOutputStream;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.esapi.ESAPI;

@CCMitigation(cweIds={}, comment="The BufferdContent processing is designed to make content that is created by the application available as content that can be accessed by the browser by URL.\nExample: the application creates some PDF content that should be shown in the browser.\nAs consequence any security issue is to be addressed to the application producting the content.\n\nNevertheless there are some default security issues:\n1. The content that is made available by the appliaction is only available within the current http session of the user. It cannot be accessed by other sessions.\n2. Each content that is made available is receiving a unque id. This id is generated in a secure random way.\n3. The content is automtically removed when the http session is removed.")
public class BufferedContentServlet
extends CCServletBaseWithContextMgmt
implements ICCServerConstants {
    @Override
    protected boolean checkIfToAbortOnMissingHttpSession(HttpServletRequest req) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void processRequest(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        try {
            long requestStartTime = System.currentTimeMillis();
            long requestContentSize = -1L;
            CLog.L.log(CLog.LL_INF, "BufferedContentServlet called via http-request: " + req.getRequestURI());
            boolean withRequestSize = false;
            String withRequestSizeStr = req.getParameter("cc_requestsize");
            withRequestSize = ValueManager.decodeBoolean(withRequestSizeStr, false);
            String clientFileName = req.getParameter("cc_clientfilename");
            HttpSession session = req.getSession(false);
            CLog.L.log(CLog.LL_INF, "BufferedContentServlet session id = " + session.getId());
            ServletUtil.setResponseHeader(resp, "X-Frame-Options", SystemXml.getCcembeddedcontentBufferedcontentXframeoptions());
            String uri = req.getRequestURI();
            String bufferId = BufferedContentServlet.readBufferIdFromURI(uri);
            if (bufferId != null) {
                CLog.L.log(CLog.LL_INF, "BufferedContentServlet buffer id = " + bufferId);
                Object bufferedObject = BufferedContentMgr.readBufferedContent(session, bufferId);
                if (bufferedObject == null) {
                    CLog.L.log(CLog.LL_INF, "Could not find any object in buffered content for bufferId: " + bufferId);
                    throw new Exception("Could not find any object in buffered content");
                }
                if (bufferedObject instanceof IBufferedContent) {
                    Object object = bufferedObject;
                    // MONITORENTER : object
                    CLog.L.log(CLog.LL_INF, "calling bufferedObject: " + bufferedObject.getClass().getName());
                    IBufferedContent bufferedContent = (IBufferedContent)bufferedObject;
                    bufferedContent.preProcessResponse(resp);
                    bufferedContent.passClientFileName(clientFileName);
                    bufferedContent.passCurrentRequestURL(req.getRequestURL().toString());
                    bufferedContent.passCurrentRequestQueryString(req.getQueryString());
                    if (bufferedContent.getFileName() != null) {
                        String bfn = bufferedContent.getFileName();
                        this.addBrowserFileNameToHttpResponse(resp, bfn);
                    }
                    bufferedContent.beginGetting();
                    if (withRequestSize) {
                        byte[] bs = (bufferedContent.getContentLength() + "").getBytes();
                        resp.getOutputStream().write(bs);
                        // MONITOREXIT : object
                        return;
                    }
                    byte[] content = bufferedContent.getContent();
                    String contentType = bufferedContent.getContentType();
                    if (contentType != null) {
                        this.setContentTypeInResponse(contentType, resp);
                    }
                    if (content != null) {
                        requestContentSize = content.length;
                        CLog.L.log(CLog.LL_INF, "received some content: length = " + content.length);
                        resp.getOutputStream().write(content);
                    } else {
                        CLog.L.log(CLog.LL_WAR, "Download content that was passed back by the application is null!");
                    }
                    bufferedContent.endGetting();
                    // MONITOREXIT : object
                } else {
                    if (!(bufferedObject instanceof IBufferedStreamContent)) {
                        CLog.L.log(CLog.LL_INF, "Buffered object neither instance of IBufferedContent nor instance of IBufferedStreamContent");
                        CLog.L.log(CLog.LL_INF, "Buffered object, class: " + bufferedObject.getClass().getName());
                        CLog.L.log(CLog.LL_INF, "Buffered object, instance: " + bufferedObject);
                        throw new Exception("Buffered object neither instance of IBufferedContent nor instance of IBufferedStreamContent");
                    }
                    Object object = bufferedObject;
                    // MONITORENTER : object
                    CLog.L.log(CLog.LL_INF, "calling bufferedObject: " + bufferedObject.getClass().getName());
                    final IBufferedStreamContent bufferedStreamContent = (IBufferedStreamContent)bufferedObject;
                    bufferedStreamContent.preProcessResponse(resp);
                    bufferedStreamContent.passClientFileName(clientFileName);
                    bufferedStreamContent.passCurrentRequestURL(req.getRequestURL().toString());
                    bufferedStreamContent.passCurrentRequestQueryString(req.getQueryString());
                    bufferedStreamContent.beginGetting();
                    if (withRequestSize) {
                        byte[] bs = (bufferedStreamContent.getContentLength() + "").getBytes();
                        resp.getOutputStream().write(bs);
                        // MONITOREXIT : object
                        return;
                    }
                    Runnable runBeforeWritingStream = new Runnable(){

                        @Override
                        public void run() {
                            String contentType = bufferedStreamContent.getContentType();
                            if (contentType != null) {
                                BufferedContentServlet.this.setContentTypeInResponse(contentType, resp);
                            }
                        }
                    };
                    CountingOutputStream countingStream = new CountingOutputStream((OutputStream)resp.getOutputStream(), runBeforeWritingStream);
                    bufferedStreamContent.writeStream(countingStream);
                    requestContentSize = countingStream.getCount();
                    bufferedStreamContent.endGetting();
                    // MONITOREXIT : object
                }
            } else {
                CLog.L.log(CLog.LL_ERR, "Not able to find buffer id from request: " + bufferId);
                resp.getWriter().write(ESAPI.encoder().encodeForHTML("Not able to find buffer id from request: " + bufferId));
            }
            CLog.L.log(CLog.LL_INF, "BufferedContentServlet finished");
            long requestEndTime = System.currentTimeMillis();
            PLog.logFileDownloadInfo(session.getId(), requestEndTime - requestStartTime, requestContentSize);
            return;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when accessing buffered content", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (!(t instanceof Error)) throw new Error(t);
            throw (Error)t;
        }
    }

    public static String readBufferIdFromURI(String uri) {
        int index;
        int nextIndex;
        String bufferId = null;
        if (uri.contains(".ccbuffer")) {
            int index2 = uri.indexOf(".ccbuffer");
            bufferId = uri.substring(0, index2);
            index2 = bufferId.lastIndexOf(47);
            bufferId = bufferId.substring(index2 + 1);
        } else if (uri.contains("/ccbuffer/") && (nextIndex = uri.indexOf("/", (index = uri.lastIndexOf("/ccbuffer/")) + "/ccbuffer/".length())) > index) {
            bufferId = uri.substring(index + "/ccbuffer/".length(), nextIndex);
        }
        return bufferId;
    }

    protected void addBrowserFileNameToHttpResponse(HttpServletResponse resp, String bfn) {
    }
}

