/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bufferedcontent;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclnt.jsfserver.bufferedcontent.IUploadContent;
import org.eclnt.jsfserver.bufferedcontent.IUploadStreamContent;
import org.eclnt.jsfserver.util.DefaultSessionAbstractionListener;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;

public class UploadContentMgr {
    public static void add(IUploadContent uploadContent) {
        HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
        hs.setAttribute("uploadContent_" + uploadContent.getId(), (Object)uploadContent);
        hs.setAttribute("addedUploadContent_" + uploadContent.getId(), (Object)System.currentTimeMillis());
        final String uploadContentId = uploadContent.getId();
        HttpSessionAccess.getCurrentDialogSession().addListener(new DefaultSessionAbstractionListener(){

            @Override
            public void reactOnClosed() {
                UploadContentMgr.removeById(uploadContentId);
            }
        });
    }

    public static void remove(IUploadContent uploadContent) {
        try {
            if (uploadContent == null) {
                return;
            }
            UploadContentMgr.removeById(uploadContent.getId());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Exception when removing uploadcontent: " + t.toString());
        }
    }

    public static void add(IUploadStreamContent uploadContent) {
        HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
        hs.setAttribute("uploadContent_" + uploadContent.getId(), (Object)uploadContent);
        hs.setAttribute("addedUploadContent_" + uploadContent.getId(), (Object)System.currentTimeMillis());
        final String uploadContentId = uploadContent.getId();
        HttpSessionAccess.getCurrentDialogSession().addListener(new DefaultSessionAbstractionListener(){

            @Override
            public void reactOnClosed() {
                UploadContentMgr.removeById(uploadContentId);
            }
        });
    }

    public static void remove(IUploadStreamContent uploadContent) {
        try {
            if (uploadContent == null) {
                return;
            }
            UploadContentMgr.removeById(uploadContent.getId());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when removing uploadContent: " + t.toString());
        }
    }

    public static void removeAllContentOlderThan(long duration) {
        try {
            long now = System.currentTimeMillis();
            CLog.L.log(CLog.LL_INF, "Removing all content older than " + duration);
            HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
            Enumeration en = hs.getAttributeNames();
            ArrayList ans = new ArrayList();
            while (en.hasMoreElements()) {
                ans.add(en.nextElement());
            }
            for (String an : ans) {
                try {
                    if (!an.startsWith("uploadContent_")) continue;
                    CLog.L.log(CLog.LL_INF, "Found upload content " + an);
                    String anAdded = an.replace("uploadContent_", "addedUploadContent_");
                    Long l = (Long)hs.getAttribute(anAdded);
                    if (l == null || now - l <= duration) continue;
                    hs.removeAttribute(an);
                    hs.removeAttribute(anAdded);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem when removing content " + an, t);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when removing all content older than " + duration, t);
        }
    }

    private static void removeById(String id) {
        try {
            if (id == null) {
                return;
            }
            HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
            hs.removeAttribute("uploadContent_" + id);
            hs.removeAttribute("addedUploadContent_" + id);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Exception when removing uploadcontent: " + t.toString());
        }
    }
}

