/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.calendar;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.util.valuemgmt.LocalDate18Manager;

public interface IExtCalendarMgr {
    public void clearBuffer();

    public List<String> getAvailableCalendarIds();

    public ExtCalendarInfo getCalendarInfoForDay(String var1, Date var2, String var3);

    public List<ExtCalendarInfo> getCalendarInfoForMonth(String var1, Date var2, String var3);

    public static class ExtCalendarInfo {
        Date i_date;
        String i_comment;
        Map<String, String> i_translations;
        boolean i_selectable = true;
        String i_background = null;
        boolean i_warningOnSelection = false;

        public ExtCalendarInfo(LocalDate date) {
            this(LocalDate18Manager.convertLocalDateToDate(date, "UTC"));
        }

        public ExtCalendarInfo(Date date) {
            this.i_date = date;
        }

        public ExtCalendarInfo(LocalDate date, String comment) {
            this(LocalDate18Manager.convertLocalDateToDate(date, "UTC"), comment);
        }

        public ExtCalendarInfo(Date date, String comment) {
            this.i_date = date;
            this.i_comment = comment;
        }

        public ExtCalendarInfo(LocalDate date, String comment, boolean selectable) {
            this(LocalDate18Manager.convertLocalDateToDate(date, "UTC"), comment, selectable);
        }

        public ExtCalendarInfo(Date date, String comment, boolean selectable) {
            this.i_date = date;
            this.i_comment = comment;
            this.i_selectable = selectable;
        }

        public ExtCalendarInfo(LocalDate date, String comment, boolean selectable, String background) {
            this(LocalDate18Manager.convertLocalDateToDate(date, "UTC"), comment, selectable, background);
        }

        public ExtCalendarInfo(Date date, String comment, boolean selectable, String background) {
            this.i_date = date;
            this.i_comment = comment;
            this.i_selectable = selectable;
            this.i_background = background;
        }

        public ExtCalendarInfo(LocalDate date, String comment, boolean selectable, String background, boolean warningOnSelection) {
            this(LocalDate18Manager.convertLocalDateToDate(date, "UTC"), comment, selectable, background, warningOnSelection);
        }

        public ExtCalendarInfo(Date date, String comment, boolean selectable, String background, boolean warningOnSelection) {
            this.i_date = date;
            this.i_comment = comment;
            this.i_selectable = selectable;
            this.i_background = background;
            this.i_warningOnSelection = warningOnSelection;
        }

        public LocalDate getLocalDate() {
            return LocalDate18Manager.convertDateToLocalDate(this.i_date, "UTC");
        }

        public Date getDate() {
            return this.i_date;
        }

        public String getComment() {
            return this.i_comment;
        }

        public String getComment(String language) {
            String result = null;
            if (language != null && this.i_translations != null) {
                result = this.i_translations.get(language);
            }
            if (result == null) {
                result = this.i_comment;
            }
            return result;
        }

        public void addCommentTranslation(String language, String comment) {
            if (this.i_translations != null) {
                this.i_translations = new HashMap<String, String>();
            }
            this.i_translations.put(language, comment);
        }

        public boolean isSelectable() {
            return this.i_selectable;
        }

        public boolean getWarningOnSelection() {
            return this.i_warningOnSelection;
        }

        public String getBackground() {
            return this.i_background;
        }

        public void setComment(String comment) {
            this.i_comment = comment;
        }

        public void setSelectable(boolean selectable) {
            this.i_selectable = selectable;
        }

        public void setBackground(String background) {
            this.i_background = background;
        }

        public void setWarningOnSelection(boolean warningOnSelection) {
            this.i_warningOnSelection = warningOnSelection;
        }
    }
}

