/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.file.FileManager;

@CCGenClass(expressionBase="#{wp.DemoTreeFileBrowser}")
public class ServerFileBrowser
extends PageBean
implements Serializable {
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding();
    String m_explanation;
    IListener m_listener = null;
    String m_padding = "1";
    String m_border = "#00000080";

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/serverfilebrowser.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{ServerFileBrowser}";
    }

    public void prepare(String rootPath, String explanation, IListener listener) {
        this.m_explanation = explanation;
        this.m_listener = listener;
        this.m_tree.getRootNode().removeAllChildNodes(true);
        File f = new File(rootPath);
        List<File> subDirs = FileManager.getDirectoriesOfDirectory(rootPath);
        for (File subDir : subDirs) {
            new TreeNode(this.m_tree.getRootNode(), subDir);
        }
        List<File> subFiles = FileManager.getFilesOfDirectory(rootPath);
        for (File subFile : subFiles) {
            new TreeNode(this.m_tree.getRootNode(), subFile);
        }
    }

    public String getPadding() {
        return this.m_padding;
    }

    public void setPadding(String padding) {
        this.m_padding = padding;
    }

    public String getBorder() {
        return this.m_border;
    }

    public void setBorder(String border) {
        this.m_border = border;
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() {
        return this.m_tree;
    }

    public String getExplanation() {
        return this.m_explanation;
    }

    public boolean getAvailableExplanation() {
        return this.m_explanation != null;
    }

    public static interface IListener {
        public void reactOnSelection(File var1);

        public void reactOnNavigation(File var1);
    }

    public class TreeNode
    extends FIXGRIDTreeItem
    implements Serializable {
        File i_file;
        boolean i_subNodesLoaded;

        public TreeNode(FIXGRIDTreeItem parentNode, File file) {
            super(parentNode);
            this.i_subNodesLoaded = false;
            this.i_file = file;
            if (this.i_file.isDirectory()) {
                this.setStatus(1);
            } else {
                this.setStatus(2);
            }
            this.setText(file.getName());
        }

        @Override
        public void onToggle() {
            if (this.i_subNodesLoaded) {
                return;
            }
            List<File> subDirs = FileManager.getDirectoriesOfDirectory(this.i_file.getAbsolutePath());
            Collections.sort(subDirs);
            for (File subDir : subDirs) {
                new TreeNode(this, subDir);
            }
            List<File> subFiles = FileManager.getFilesOfDirectory(this.i_file.getAbsolutePath());
            Collections.sort(subFiles);
            for (File subFile : subFiles) {
                new TreeNode(this, subFile);
            }
            this.i_subNodesLoaded = true;
        }

        @Override
        public void onRowSelect() {
            if (ServerFileBrowser.this.m_listener != null) {
                ServerFileBrowser.this.m_listener.reactOnNavigation(this.i_file);
            }
        }

        @Override
        public void onRowExecute() {
            if (ServerFileBrowser.this.m_listener != null) {
                ServerFileBrowser.this.m_listener.reactOnSelection(this.i_file);
            }
        }
    }
}

