/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.util.ArrayListWithChangeIndex;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IListWithChangeIndex;
import org.eclnt.jsfserver.util.IListWithChangeIndexListener;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIXGRIDListBinding<ItemClass extends FIXGRIDItem>
extends FIXGRIDBinding<ItemClass>
implements IFIXGRIDBinding<ItemClass>,
Serializable,
IListWithChangeIndexListener {
    IListWithChangeIndex<ItemClass> m_items = this.createItems();
    List<ItemClass> m_rows = null;
    int m_lastChangeIndex = -1;

    public FIXGRIDListBinding() {
        this.m_items.setListWithChangeIndexListener(this);
    }

    public FIXGRIDListBinding(boolean changeIndexIsSupported) {
        super(changeIndexIsSupported);
        this.m_items.setListWithChangeIndexListener(this);
    }

    protected IListWithChangeIndex<ItemClass> createItems() {
        return new ArrayListWithChangeIndex();
    }

    public void setItems(IListWithChangeIndex<ItemClass> items) {
        if (this.m_items == items) {
            return;
        }
        this.m_items.setListWithChangeIndexListener(null);
        this.m_items = items;
        this.m_items.setListWithChangeIndexListener(this);
        this.m_items.updateChangeIndex();
        this.listChanged(this.m_items);
        this.m_lastChangeIndex = -1;
    }

    @Override
    public List<ItemClass> getRows() {
        if (this.m_lastChangeIndex != this.m_items.getChangeIndex()) {
            this.m_rows = null;
            this.m_lastChangeIndex = this.m_items.getChangeIndex();
        }
        if (this.m_rows == null || this.m_rows.size() == 0) {
            this.m_rows = this.buildUpRows();
            this.m_lastChangeIndex = this.m_items.getChangeIndex();
        }
        return this.m_rows;
    }

    private List<ItemClass> buildUpRows() {
        ArrayList result = new ArrayList();
        int count = 0;
        int itemsSize = this.m_items.size();
        for (int i = this.m_sbvalue; i < itemsSize && ++count <= this.m_sbvisibleamount; ++i) {
            result.add(this.m_items.get(i));
        }
        if (count == 0 && this.getSbvalue() != 0) {
            this.setSbvalue("0");
            return this.buildUpRows();
        }
        return result;
    }

    @Override
    public int getSbmaximum() {
        return this.m_items.size();
    }

    public List<ItemClass> getItems() {
        return this.m_items;
    }

    @Override
    public void setSbvalue(String value) {
        this.m_items.updateChangeIndex();
        super.setSbvalue(value);
    }

    @Override
    public void listChanged(IListWithChangeIndex list) {
        this.ensureSbValueIsPropertlySet();
    }

    private void ensureSbValueIsPropertlySet() {
        if (this.getSbvisibleamount() == 0) {
            return;
        }
        int numberOfClientRows = this.getClientvisibleamount();
        int lastSbvalue = this.getItems().size() - numberOfClientRows;
        if (lastSbvalue < 0) {
            lastSbvalue = 0;
        }
        if (this.getSbvalue() > lastSbvalue) {
            this.setSbvalue(lastSbvalue);
        }
    }

    @Override
    public void listItemWasRemoved(IListWithChangeIndex list, Object concreteItem) {
        if (this.m_items.size() == 0) {
            this.clearSelectedItems();
            this.setSbvalue(0);
            return;
        }
        if (concreteItem == null) {
            ArrayList<Object> removedItems = new ArrayList<Object>();
            for (Object item : this.m_selectedItems) {
                if (item == null || this.m_items.contains(item)) continue;
                removedItems.add(item);
            }
            for (FIXGRIDItem fIXGRIDItem : removedItems) {
                this.clearSelectedItem(fIXGRIDItem);
            }
        } else if (this.m_selectedItems.contains(concreteItem)) {
            int counter = 0;
            for (FIXGRIDItem item : this.m_items) {
                if (item != concreteItem) continue;
                ++counter;
            }
            if (counter <= 1) {
                this.clearSelectedItem((FIXGRIDItem)concreteItem);
            }
        }
    }

    @Override
    public void listItemWasAdded(IListWithChangeIndex list, Object concreteItem) {
        if (concreteItem != null && ((FIXGRIDItem)concreteItem).getSelected()) {
            this.addSelectedItem((FIXGRIDItem)concreteItem);
        }
    }

    @Override
    public void ensureItemToBeDisplayed(ItemClass item) {
        int index = this.getItems().indexOf(item);
        if (index < 0) {
            CLog.L.log(CLog.LL_INF, "Item is not available in grid, ensureItemToBeDisplayed cannot be executed");
            return;
        }
        this.setObjecttobevisibleOfItems(item);
    }

    @Override
    public void ensureItemToBeDisplayed(int index) {
        CLog.L.log(CLog.LL_INF, "Ensure item to be displayed: " + this.getSbvisibleamount() + "/" + this.getClientvisibleamount() + "/" + this.getSbvalue());
        this.setIndextobevisibleOfItems(index);
    }

    @Override
    public void setSbvalue(int value) {
        super.setSbvalue(value);
        this.m_items.updateChangeIndex();
    }

    public Collection<ItemClass> getSelectedItemsAsSequence() {
        ArrayList<FIXGRIDItem> result = new ArrayList<FIXGRIDItem>();
        for (FIXGRIDItem item : this.m_items) {
            if (item == null || !item.getSelected()) continue;
            result.add(item);
        }
        return result;
    }

    public void selectItem(int index) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "GRIDSELECTION: selectItem(" + index + ") was called");
        }
        this.selectItem((IFIXGRIDItem)this.getItems().get(index));
    }

    public void deselectItem(int index) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "GRIDSELECTION: deselectItem(" + index + ") was called");
        }
        this.deselectItem((IFIXGRIDItem)this.getItems().get(index));
    }

    @Override
    protected void fillShiftSelection() {
        int index2;
        if (this.m_firstItemForShiftSelection == null) {
            super.fillShiftSelection();
            return;
        }
        int index1 = this.m_items.indexOf(this.m_currentlyFocussedItem);
        if (index1 > (index2 = this.m_items.indexOf(this.m_firstItemForShiftSelection))) {
            int temp = index1;
            index1 = index2;
            index2 = temp;
        }
        if (index1 < 0 || index1 >= this.m_items.size()) {
            return;
        }
        if (index2 < 0 || index2 >= this.m_items.size()) {
            return;
        }
        int initialCapacity = index2 - index1;
        if (initialCapacity <= 0) {
            initialCapacity = 1;
        }
        HashSet<FIXGRIDItem> newSelection = new HashSet<FIXGRIDItem>(initialCapacity);
        for (int i = index1; i <= index2; ++i) {
            FIXGRIDItem item = (FIXGRIDItem)this.m_items.get(i);
            newSelection.add(item);
            if (this.m_selectedItems.contains(item)) continue;
            this.selectItem((IFIXGRIDItem)this.m_items.get(i));
        }
        ArrayList<FIXGRIDItem> updSelection = new ArrayList<FIXGRIDItem>();
        for (FIXGRIDItem item : this.m_selectedItems) {
            updSelection.add(item);
        }
        for (FIXGRIDItem item : updSelection) {
            if (newSelection.contains(item)) continue;
            this.deselectItem(item);
        }
    }

    @Override
    protected List<ItemClass> getListOfItems() {
        return this.getItems();
    }

    @Override
    protected void sortGrid(String sortReference, String objectBindingString, boolean ascending) {
        try {
            int i;
            FacesContext context = HttpSessionAccess.getCurrentFacesContext();
            objectBindingString = objectBindingString + ".items";
            ArrayList<FIXGRIDBinding.SortHelper> shs = new ArrayList<FIXGRIDBinding.SortHelper>();
            Comparator comparator = this.findSortComparatorForColumnValue(sortReference);
            for (int i2 = 0; i2 < this.getItems().size(); ++i2) {
                String expression = "#{" + objectBindingString + "[" + i2 + "]." + sortReference + "}";
                Object value = ExpressionManagerV.getValueForExpressionString(context, expression);
                FIXGRIDBinding.SortHelper sh = new FIXGRIDBinding.SortHelper(i2, value, ascending, comparator);
                shs.add(sh);
            }
            Collections.sort(shs);
            ArrayList<ItemClass> tempGrid = new ArrayList<ItemClass>();
            for (i = 0; i < this.getItems().size(); ++i) {
                tempGrid.add(this.getItems().get(i));
            }
            this.getItems().clear();
            for (i = 0; i < shs.size(); ++i) {
                FIXGRIDBinding.SortHelper sh = (FIXGRIDBinding.SortHelper)shs.get(i);
                this.getItems().add(tempGrid.get(sh.i_originalIndex));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem occurred during sortGrid()", t);
        }
    }

    @Override
    protected void sortGridByOriginalIndex() {
        try {
            Collections.sort(this.m_items, new Comparator<ItemClass>(){

                @Override
                public int compare(ItemClass o1, ItemClass o2) {
                    int originalIndex1 = ((FIXGRIDItem)o1).getOriginalIndex();
                    int originalIndex2 = ((FIXGRIDItem)o2).getOriginalIndex();
                    return originalIndex1 - originalIndex2;
                }
            });
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem occurred during sortGridByOriginalIndex()", t);
        }
    }

    @Override
    public void applyOriginalIndexToCurrentContent() {
        int counter = 0;
        for (FIXGRIDItem item : this.m_items) {
            item.setOriginalIndex(counter);
            ++counter;
        }
    }

    @Override
    protected void processSearch(String searchString, String sortReference) {
        if (sortReference == null) {
            return;
        }
        searchString = ValueManager.toLowerCaseText(searchString);
        FacesContext context = HttpSessionAccess.getCurrentFacesContext();
        String objectBindingString = this.m_objectBinding + ".items";
        for (int i = 0; i < this.getItems().size(); ++i) {
            String expression = "#{" + objectBindingString + "[" + i + "]." + sortReference + "}";
            Object value = ExpressionManagerV.getValueForExpressionString(context, expression);
            String stringValue = "";
            if (value != null) {
                stringValue = ValueManager.toLowerCaseText(value.toString());
            }
            if (!stringValue.startsWith(searchString)) continue;
            this.deselectCurrentSelection();
            this.selectItem((IFIXGRIDItem)this.getItems().get(i));
            this.ensureItemToBeDisplayed(i);
            return;
        }
    }
}

