/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;

public class FIXGRIDTreeBinding<ItemClass extends FIXGRIDTreeItem>
extends FIXGRIDBinding<ItemClass>
implements Serializable,
IFIXGRIDBinding<ItemClass> {
    public static boolean s_supportAutoScrollOnToggle = true;
    protected FIXGRIDTreeItem m_rootNode;
    private int m_previousVisibleAmount = 0;
    transient List<FIXGRIDTreeItem> m_rows;
    private boolean m_foldersAlwaysSortedToTop = false;

    public FIXGRIDTreeBinding() {
        this.m_rootNode = new FIXGRIDTreeItem(null);
        this.m_rootNode.setLevel(-1);
    }

    public FIXGRIDTreeBinding(boolean changeIndexIsSupported) {
        super(changeIndexIsSupported);
        this.m_rootNode = new FIXGRIDTreeItem(null);
        this.m_rootNode.setLevel(-1);
    }

    public FIXGRIDTreeBinding(FIXGRIDTreeItem rootNode) {
        this.m_rootNode = rootNode;
        this.m_rootNode.setLevel(-1);
    }

    public FIXGRIDTreeBinding(FIXGRIDTreeItem rootNode, boolean changeIndexIsSupported) {
        super(changeIndexIsSupported);
        this.m_rootNode = rootNode;
        this.m_rootNode.setLevel(-1);
    }

    public void removeNode(FIXGRIDTreeItem node) {
        if (node == null) {
            return;
        }
        Set<FIXGRIDTreeItem> containedNodes = node.getAllContainedNodes();
        for (FIXGRIDTreeItem containedNode : containedNodes) {
            if (!this.getSelectedItems().contains(containedNode)) continue;
            this.deselectItem(containedNode);
        }
        node.removeNode();
    }

    @Override
    public void setSbvalue(int value) {
        super.setSbvalue(value);
        this.triggerRowsUpdate();
    }

    public boolean getFoldersAlwaysSortedToTop() {
        return this.m_foldersAlwaysSortedToTop;
    }

    public void setFoldersAlwaysSortedToTop(boolean foldersAlwaysSortedToTop) {
        this.m_foldersAlwaysSortedToTop = foldersAlwaysSortedToTop;
    }

    @Override
    public List getRows() {
        if (this.m_rows == null || this.m_rows.size() == 0) {
            List visibleItems = this.getVisibleItems();
            this.m_rows = new ArrayList<FIXGRIDTreeItem>();
            if (this.m_sbvalue >= visibleItems.size()) {
                this.setSbvalue(0);
                this.m_rows = new ArrayList<FIXGRIDTreeItem>();
            }
            int counter = 0;
            for (int i = this.m_sbvalue; i < visibleItems.size(); ++i) {
                this.m_rows.add((FIXGRIDTreeItem)visibleItems.get(i));
                if (++counter >= this.m_sbvisibleamount) break;
            }
        }
        return this.m_rows;
    }

    @Override
    public int getSbmaximum() {
        return this.getVisibleItems().size();
    }

    public void setRootNode(FIXGRIDTreeItem value) {
        this.m_rootNode = value;
        this.m_rootNode.setStatus(0);
        this.m_rootNode.setLevel(-1);
        this.updateLevelOfChildrenIfRequired(this.m_rootNode);
    }

    public FIXGRIDTreeItem getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public void ensureItemToBeDisplayed(ItemClass item) {
        ((FIXGRIDTreeItem)item).openAllParentNodes();
        List l = this.getVisibleItems();
        int index = l.indexOf(item);
        if (index < 0) {
            CLog.L.log(CLog.LL_WAR, "Item is not available in tree, ensureItemToBeDisplayed cannot be executed");
            return;
        }
        CLog.L.log(CLog.LL_INF, "Ensure item to be displayed: " + this.getSbvisibleamount() + "/" + this.getClientvisibleamount() + "/" + this.getSbvalue());
        this.setObjecttobevisibleOfItems(item);
    }

    @Override
    protected void sortGrid(String sortReference, String objectBindingString, boolean ascending) {
        this.sortNodes(this.getRootNode(), sortReference, objectBindingString, ascending);
    }

    @Override
    protected void sortGridByOriginalIndex() {
        this.sortNodesByOriginalIndex(this.getRootNode());
    }

    protected void sortNodes(FIXGRIDTreeItem node, String sortReference, String objectBindingString, boolean ascending) {
        int i;
        FacesContext context = HttpSessionAccess.getCurrentFacesContext();
        String expression = null;
        expression = sortReference != null && sortReference.length() > 0 ? "#{" + this.parkGridForAccess() + ".toBeAccessedNode." + sortReference + "}" : "#{" + this.parkGridForAccess() + ".toBeAccessedNode}";
        ArrayList<TBSortHelper> shs = new ArrayList<TBSortHelper>();
        Comparator comparator = this.findSortComparatorForColumnValue(sortReference);
        for (int i2 = 0; i2 < node.getChildNodes().size(); ++i2) {
            FIXGRIDTreeItem currentNode = node.getChildNodes().get(i2);
            this.setToBeAccessedNode(currentNode);
            Object value = ExpressionManagerV.getValueForExpressionString(context, expression);
            TBSortHelper sh = new TBSortHelper(i2, currentNode, value, ascending, comparator);
            shs.add(sh);
        }
        Collections.sort(shs);
        ArrayList<FIXGRIDTreeItem> tempGrid = new ArrayList<FIXGRIDTreeItem>();
        for (i = 0; i < node.getChildNodes().size(); ++i) {
            tempGrid.add(node.getChildNodes().get(i));
        }
        node.removeAllChildNodes(false);
        for (i = 0; i < shs.size(); ++i) {
            FIXGRIDBinding.SortHelper sh = (FIXGRIDBinding.SortHelper)shs.get(i);
            node.addSubNode((FIXGRIDTreeItem)tempGrid.get(sh.i_originalIndex), false);
        }
        for (i = 0; i < node.getChildNodes().size(); ++i) {
            this.sortNodes(node.getChildNodes().get(i), sortReference, objectBindingString, ascending);
        }
        this.triggerRowsUpdate();
    }

    protected void sortNodesByOriginalIndex(FIXGRIDTreeItem node) {
        List<FIXGRIDTreeItem> childNodes = node.getChildNodes();
        Collections.sort(childNodes, new Comparator<FIXGRIDTreeItem>(){

            @Override
            public int compare(FIXGRIDTreeItem o1, FIXGRIDTreeItem o2) {
                int originalIndex1 = o1.getOriginalIndex();
                int originalIndex2 = o2.getOriginalIndex();
                return originalIndex1 - originalIndex2;
            }
        });
        for (int i = 0; i < node.getChildNodes().size(); ++i) {
            this.sortNodesByOriginalIndex(node.getChildNodes().get(i));
        }
        this.triggerRowsUpdate();
    }

    @Override
    public void applyOriginalIndexToCurrentContent() {
        this.applyOriginalIndexToCurrentNode(this.m_rootNode);
    }

    protected void applyOriginalIndexToCurrentNode(FIXGRIDTreeItem node) {
        int counter = 0;
        for (FIXGRIDTreeItem childNode : node.getChildNodes()) {
            childNode.setOriginalIndex(counter);
            this.applyOriginalIndexToCurrentNode(childNode);
            ++counter;
        }
    }

    @Override
    public void setSbvisibleamount(int value) {
        super.setSbvisibleamount(value);
    }

    @Override
    public void renderingBegins() {
        super.renderingBegins();
        this.triggerRowsUpdate();
    }

    public void expandAll(ActionEvent event) {
        this.expandAll();
        this.triggerRowsUpdate();
    }

    public void collapseAll(ActionEvent event) {
        this.collapseAll();
        this.triggerRowsUpdate();
    }

    public void expandTopNodes(ActionEvent event) {
        this.expandTopNodes();
        this.triggerRowsUpdate();
    }

    public void collapseTopNodes(ActionEvent event) {
        this.collapseTopNodes();
        this.triggerRowsUpdate();
    }

    public void expandAll() {
        List<FIXGRIDTreeItem> nodes = this.getRootNode().getChildNodes();
        for (FIXGRIDTreeItem node : nodes) {
            node.expandNodeAndSubNodes();
        }
        this.triggerRowsUpdate();
    }

    public void collapseAll() {
        List<FIXGRIDTreeItem> nodes = this.getRootNode().getChildNodes();
        for (FIXGRIDTreeItem node : nodes) {
            node.collapseNodeAndSubNodes();
        }
        this.triggerRowsUpdate();
    }

    public void expandTopNodes() {
        List<FIXGRIDTreeItem> nodes = this.getRootNode().getChildNodes();
        for (FIXGRIDTreeItem node : nodes) {
            node.expandNode();
        }
        this.triggerRowsUpdate();
    }

    public void collapseTopNodes() {
        List<FIXGRIDTreeItem> nodes = this.getRootNode().getChildNodes();
        for (FIXGRIDTreeItem node : nodes) {
            node.collapseNode();
        }
        this.triggerRowsUpdate();
    }

    public List<String> getNodeTextsFromTop(FIXGRIDTreeItem item) {
        ArrayList<String> result = new ArrayList<String>();
        if (item == null) {
            return result;
        }
        FIXGRIDTreeItem currentItem = item;
        do {
            String itemText;
            if ((itemText = currentItem.getText()) == null) {
                itemText = "";
            }
            result.add(0, currentItem.getText());
        } while (currentItem.getLevelInt() != 0 && (currentItem = currentItem.getParentNode()) != null);
        return result;
    }

    public ItemClass getItemByText(List<String> itemTexts) {
        boolean foundit;
        if (itemTexts == null) {
            return null;
        }
        FIXGRIDTreeItem currentItem = this.getRootNode();
        int currentIndex = 0;
        do {
            if (currentIndex >= itemTexts.size()) {
                if (currentItem != this.getRootNode()) {
                    return (ItemClass)currentItem;
                }
                return null;
            }
            String currentText = itemTexts.get(currentIndex);
            List<FIXGRIDTreeItem> childNodes = currentItem.getChildNodes();
            if (childNodes.size() == 0 && currentItem.getStatusInt() == 1) {
                currentItem.onToggle();
                childNodes = currentItem.getChildNodes();
            }
            foundit = false;
            for (FIXGRIDTreeItem childNode : childNodes) {
                if (childNode.getText() == null || !childNode.getText().equals(currentText)) continue;
                currentItem = childNode;
                ++currentIndex;
                foundit = true;
            }
        } while (foundit);
        return null;
    }

    public Collection<ItemClass> getSelectedItemsAsSequence() {
        ArrayList<FIXGRIDTreeItem> nodeDump = new ArrayList<FIXGRIDTreeItem>();
        this.dumpTreeToList(this.getRootNode(), nodeDump);
        ArrayList<FIXGRIDTreeItem> result = new ArrayList<FIXGRIDTreeItem>();
        for (FIXGRIDTreeItem item : nodeDump) {
            if (!item.getSelected()) continue;
            result.add(item);
        }
        return result;
    }

    public Collection<ItemClass> getAllItemsAsSequence() {
        ArrayList<FIXGRIDTreeItem> nodeDump = new ArrayList<FIXGRIDTreeItem>();
        this.dumpTreeToList(this.getRootNode(), nodeDump);
        ArrayList<FIXGRIDTreeItem> result = new ArrayList<FIXGRIDTreeItem>();
        for (FIXGRIDTreeItem item : nodeDump) {
            result.add(item);
        }
        return result;
    }

    public void openAllNodesUpToLevel(int level, boolean closeLevelsAbove) {
        Collection<ItemClass> allItems = this.getAllItemsAsSequence();
        for (FIXGRIDTreeItem item : allItems) {
            if (item.getLevelInt() <= level) {
                if (item.getStatusInt() == 2) continue;
                item.setStatus(0);
                continue;
            }
            if (!closeLevelsAbove || item.getStatusInt() == 2) continue;
            item.setStatus(1);
        }
    }

    @Override
    protected void fillShiftSelection() {
        int initialCapacity;
        if (this.m_previouslyFocussedItem == null) {
            super.fillShiftSelection();
            return;
        }
        ArrayList<FIXGRIDTreeItem> nodeDump = new ArrayList<FIXGRIDTreeItem>();
        this.dumpTreeToList(this.getRootNode(), nodeDump);
        int index1 = nodeDump.indexOf(this.m_currentlyFocussedItem);
        int index2 = nodeDump.indexOf(this.m_firstItemForShiftSelection);
        if (index1 > index2) {
            int temp = index1;
            index1 = index2;
            index2 = temp;
        }
        if ((initialCapacity = index2 - index1) <= 0) {
            initialCapacity = 1;
        }
        HashSet<FIXGRIDTreeItem> newSelection = new HashSet<FIXGRIDTreeItem>(initialCapacity);
        for (int i = index1; i <= index2; ++i) {
            FIXGRIDTreeItem item = (FIXGRIDTreeItem)nodeDump.get(i);
            newSelection.add(item);
            if (this.m_selectedItems.contains(item)) continue;
            this.selectItem((IFIXGRIDItem)nodeDump.get(i));
        }
        ArrayList<FIXGRIDTreeItem> updSelection = new ArrayList<FIXGRIDTreeItem>();
        for (FIXGRIDTreeItem item : this.m_selectedItems) {
            updSelection.add(item);
        }
        for (FIXGRIDTreeItem item : updSelection) {
            if (newSelection.contains(item)) continue;
            this.deselectItem(item);
        }
    }

    @Override
    public List<ItemClass> getListOfItems() {
        return this.getVisibleItems();
    }

    private void dumpTreeToList(FIXGRIDTreeItem node, List<FIXGRIDTreeItem> dump) {
        dump.add(node);
        for (FIXGRIDTreeItem childNode : node.getChildNodes()) {
            this.dumpTreeToList(childNode, dump);
        }
    }

    List getVisibleItems() {
        ArrayList<FIXGRIDTreeItem> nodes = new ArrayList<FIXGRIDTreeItem>();
        int counter = 0;
        this.m_rootNode.appendVisibleSubNodes(nodes, counter, -1);
        return nodes;
    }

    protected void triggerRowsUpdate() {
        this.m_rows = null;
    }

    protected void updateLevelOfChildrenIfRequired(FIXGRIDTreeItem node) {
        for (FIXGRIDTreeItem childNode : node.getChildNodes()) {
            if (childNode.getLevel() == node.getLevel() + 1) continue;
            childNode.setLevel(node.getLevelInt() + 1);
            this.updateLevelOfChildrenIfRequired(childNode);
        }
    }

    class TBSortHelper
    extends FIXGRIDBinding.SortHelper {
        FIXGRIDTreeItem i_treeItem;

        public TBSortHelper(int originalIndex, FIXGRIDTreeItem treeItem, Object sortValue, boolean ascending, Comparator comparator) {
            super(originalIndex, sortValue, ascending, comparator);
            this.i_treeItem = treeItem;
        }

        @Override
        public int compareTo(FIXGRIDBinding.SortHelper o2) {
            if (FIXGRIDTreeBinding.this.m_foldersAlwaysSortedToTop && o2 instanceof TBSortHelper) {
                TBSortHelper tbo1 = this;
                TBSortHelper tbo2 = (TBSortHelper)o2;
                boolean folderTbo1 = true;
                boolean folderTbo2 = true;
                if (tbo1.i_treeItem.m_status == 2) {
                    folderTbo1 = false;
                }
                if (tbo2.i_treeItem.m_status == 2) {
                    folderTbo2 = false;
                }
                if (folderTbo1 && !folderTbo2) {
                    return -1;
                }
                if (!folderTbo1 && folderTbo2) {
                    return 1;
                }
            }
            return super.compareTo(o2);
        }
    }
}

