/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.onlinehelp.defaultimpl;

import org.eclnt.jsfserver.onlinehelp.IOnlineHelpProcessor2;
import org.eclnt.jsfserver.onlinehelp.OnlineHelpConfiguration;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.valuemgmt.ValueManager;

public abstract class OnlineHelpProcessorBase
implements IOnlineHelpProcessor2 {
    @Override
    public void processOnlineHelp(String helpId, String language, boolean refersToComponent) {
        String url = this.calculateURL(helpId, language);
        this.openOnlineHelp(url, refersToComponent);
    }

    protected abstract void openOnlineHelp(String var1, boolean var2);

    protected String calculateURL(String helpId, String language) {
        if (!helpId.startsWith("/")) {
            String url;
            String baseDir = OnlineHelpConfiguration.getContentDirectory();
            if (baseDir == null) {
                throw new Error("Online help is not configured yet: /eclntjsfserver/onlinehelp.xml, content directory not defined");
            }
            if (!baseDir.startsWith("/")) {
                baseDir = "/" + baseDir;
            }
            if (WebResourceClassloaderReader.checkIfFileExists(url = ValueManager.encodeIntoValidFileName(baseDir + "/" + language + "/" + helpId + ".html"))) {
                return url;
            }
            url = ValueManager.encodeIntoValidFileName(baseDir + "/" + helpId + ".html");
            if (WebResourceClassloaderReader.checkIfFileExists(url)) {
                return url;
            }
            if (!baseDir.startsWith("/")) {
                baseDir = "/" + baseDir;
            }
            if (WebResourceClassloaderReader.checkIfFileExists((url = ValueManager.encodeIntoValidFileName(baseDir + "/" + language + "/" + helpId + ".md")).replace(".md", ".ccmd"))) {
                return url;
            }
            url = ValueManager.encodeIntoValidFileName(baseDir + "/" + helpId + ".md");
            if (WebResourceClassloaderReader.checkIfFileExists(url.replace(".md", ".ccmd"))) {
                return url;
            }
            url = ValueManager.encodeIntoValidFileName(baseDir + "/" + helpId + ".html");
            return url;
        }
        String url = helpId + "_" + language + ".html";
        if (WebResourceClassloaderReader.checkIfFileExists(url)) {
            return url;
        }
        url = helpId + ".html";
        if (WebResourceClassloaderReader.checkIfFileExists(url)) {
            return url;
        }
        url = helpId + "_" + language + ".md";
        if (WebResourceClassloaderReader.checkIfFileExists(url)) {
            return url.replace(".md", ".ccmd");
        }
        url = helpId + ".md";
        if (WebResourceClassloaderReader.checkIfFileExists(url)) {
            return url.replace(".md", ".ccmd");
        }
        url = helpId + ".html";
        return url;
    }
}

