/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;

public class CCCheckServer {
    public static void check() {
        CCCheckServer.checkOneCCJarInstallation();
    }

    private static void checkOneCCJarInstallation() {
        try {
            ClassloaderReader clr = new ClassloaderReader(true);
            List<URL> versionXmlPaths = clr.readResourcePaths("org/eclnt/jsfserver/version.xml", true);
            if (versionXmlPaths.size() > 1) {
                List<String> versionXmls = clr.readUTF8Files("org/eclnt/jsfserver/version.xml", true);
                Collections.sort(versionXmls);
                for (int i = 0; i < versionXmls.size() - 1; ++i) {
                    String v2;
                    String v1 = versionXmls.get(i);
                    if (v1.equals(v2 = versionXmls.get(i + 1))) continue;
                    CLog.L.log(CLog.LL_ERR, "More than one version of eclntjsfserver*.jar is included in the classpath of the application");
                    CLog.L.log(CLog.LL_ERR, "The URLs that are referencing the version.xml file are: ");
                    for (URL path : versionXmlPaths) {
                        CLog.L.log(CLog.LL_ERR, "Classpath: " + path.toExternalForm());
                    }
                    CLog.L.log(CLog.LL_ERR, "The content of the version files are: ");
                    for (String xml : versionXmls) {
                        CLog.L.log(CLog.LL_ERR, "version.xml:\n" + xml);
                    }
                    throw new CCCheckServerError("More than one version of eclntjsfserver*.jar is included in the classpath of the application. Check the CC-log for more details.");
                }
            }
        }
        catch (CCCheckServerError e) {
            throw e;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during checkOneCCJarInstallation", t);
        }
    }

    public static class CCCheckServerError
    extends Error {
        public CCCheckServerError(String message) {
            super(message);
        }
    }
}

