/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionTrackingMode;
import java.util.Set;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;

public class CCCheckSessionConfiguration {
    public static void check(ServletContext context) {
        boolean error = false;
        Set modes = context.getEffectiveSessionTrackingModes();
        String ccMode = null;
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie(false)) {
            ccMode = "URL";
            if (!modes.contains(SessionTrackingMode.URL)) {
                error = true;
            }
            if (modes.contains(SessionTrackingMode.COOKIE)) {
                error = true;
            }
        } else {
            ccMode = "COOKIE";
            if (!modes.contains(SessionTrackingMode.COOKIE)) {
                error = true;
            }
        }
        if (error) {
            StringBuffer sbModes = new StringBuffer();
            for (SessionTrackingMode mode : modes) {
                if (sbModes.length() != 0) {
                    sbModes.append(", ");
                }
                sbModes.append(mode.name());
            }
            throw new SessionConfigurationError("\n***************************************************************************************\nIMPORTANT: INCONSISTENT CONFIGURATION OF YOUR SESSION SETTINGS\n***************************************************************************************\nError in session configuration: the servlet configuration (e.g. web.xml)\nis configured to use a different type of session tracking than the configuration\nof CaptainCasa (system.xml). Both definitions have to be in sync.\n***************************************************************************************\nServlet configuration    : " + sbModes.toString() + "\nCaptainCasa configuration: " + ccMode + "\n***************************************************************************************\n\n\nThe configuration in WEB-INF/web.xml is done in the following way:\r\n...\r\n  <session-config>\r\n      ...\r\n      <tracking-mode>COOKIE/URL</tracking-mode>\r\n      ...\r\n  </session-config>\r\n...\r\n\n\nThe configuration in eclntjsfserver/config/system.xml is done in the following way:\r\n...\r\n    <sessionmanagement\r\n        type=\"COOKIE/URL\"\r\n    />  \r\n...\r\n\n\nYou either use COOKIE or URL in both of the configurations.\n\n***************************************************************************************\n");
        }
    }

    public static class SessionConfigurationError
    extends Error {
        public SessionConfigurationError(String txt) {
            super(txt);
        }
    }
}

