/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;

public class CLResourceAccessServlet
extends CCServletBase {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if ("GET".equals(method)) {
            ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
        }
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String uri = req.getRequestURI();
            if (!uri.endsWith(".ccclresource")) {
                throw new Error("Could not interpret URI: " + uri);
            }
            int uriLastSlashIndex = uri.lastIndexOf(47);
            String resource = uri.substring(uriLastSlashIndex + 1, uri.length() - ".ccclresource".length());
            int lastDotIndex = resource.lastIndexOf(".");
            String extension = resource.substring(lastDotIndex + 1);
            String contentType = this.proposeContentType(extension);
            resp.setCharacterEncoding("UTF-8");
            ServletUtil.setResponseContentType(resp, contentType);
            byte[] bytes = CLResourceAccessServlet.readImage(resource);
            resp.getOutputStream().write(bytes);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem reading class loader resource", t);
            throw new ServletException(t);
        }
    }

    public static byte[] readImage(String resource) {
        int lastDotIndex = resource.lastIndexOf(".");
        resource = resource.substring(0, lastDotIndex).replace('.', '/') + resource.substring(lastDotIndex);
        ResourceSecurity.checkClassloaderPathForOutsideUsage(resource);
        byte[] bytes = new ClassloaderReader(HotDeployManager.currentClassLoader()).readFile(resource, true);
        return bytes;
    }
}

