/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.veracode.annotation.XSSCleanser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.util.image.SVGImageConverter;
import org.eclnt.util.image.SVGImageManagerFactory;
import org.eclnt.util.image.ServerImageManager;
import org.eclnt.util.log.CLog;

public class DynamicImageServlet
extends CCServletBase {
    static String s_fileBufferDirectory;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if ("GET".equals(method)) {
            ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
        }
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            int index;
            String uri = req.getRequestURI();
            uri = URLDecoder.decode(uri, "UTF-8");
            int ind = uri.indexOf(";");
            if (ind >= 0) {
                uri = uri.substring(0, ind);
            }
            if ((index = uri.indexOf("/ccdynamicimage/")) >= 0) {
                String dynamicImage = uri.substring(index + "/ccdynamicimage/".length() - 1);
                if (!dynamicImage.contains("/svg(")) {
                    byte[] imageBytes = ServerImageManager.getInstance().readDynamicImage(dynamicImage);
                    this.writePNGBytesToOutputStream(resp, imageBytes);
                } else {
                    byte[] imageBytes = ServerImageManager.getInstance().readDynamicImage(dynamicImage);
                    String svg = new String(imageBytes, "UTF-8");
                    this.writeSVGStringToOutputStream(resp, svg);
                }
            } else if (uri.endsWith(".ccsvg")) {
                int ccsvgIndex = uri.lastIndexOf(".ccsvg");
                int lastSlashIndex = uri.lastIndexOf(47);
                String path = uri.substring(lastSlashIndex + 1, ccsvgIndex);
                String userAgent = req.getHeader("User-Agent");
                if (userAgent != null && userAgent.contains("Java")) {
                    try {
                        path = this.updateCCSVGPathVariablesForJavaClient(path);
                        byte[] imageBytes = SVGImageManagerFactory.instance().createImageCCSVG(path);
                        String svg = new String(imageBytes, "UTF-8");
                        byte[] pngBytes = SVGImageConverter.createPNGForSVG(svg);
                        this.writePNGBytesToOutputStream(resp, pngBytes);
                    }
                    catch (Throwable ttt) {
                        CLog.L.log(CLog.LL_INF, "Problem converting image: " + path, ttt);
                    }
                } else {
                    try {
                        byte[] imageBytes = SVGImageManagerFactory.instance().createImageCCSVG(path);
                        String svg = new String(imageBytes, "UTF-8");
                        this.writeSVGStringToOutputStream(resp, svg);
                    }
                    catch (Throwable ttt) {
                        CLog.L.log(CLog.LL_INF, "Problem creating dynamic SVG image: " + uri, ttt);
                    }
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem processing dynamic image: " + req.getRequestURI(), t);
            throw new Error("Problem processing dynamic image: " + req.getRequestURI(), t);
        }
    }

    @XSSCleanser(userComment="SVG content is passed which is created from existing SVG images by dynamically updating their color and size. The replacement is checked to only allow colors and sized to be replaced - it explicitly is built and tested for attempts to prevent replacements that inject e.g. scripting. The SVG images that are taken as templates for the replacements must be stored in the resources or webcontent of the own web application. It's explicitly not possible to use images from external source (e.g. URLs).")
    private void writeSVGStringToOutputStream(HttpServletResponse resp, String svg) throws IOException {
        resp.setCharacterEncoding("UTF-8");
        ServletUtil.setResponseContentType(resp, "image/svg+xml");
        resp.getWriter().append(svg);
    }

    @XSSCleanser(userComment="PNG image content is written to the output stream. The PNG content either represents some text which needs to be available as image or some SVG that is converted into an image.")
    private void writePNGBytesToOutputStream(HttpServletResponse resp, byte[] imageBytes) throws IOException {
        ServletUtil.setResponseContentType(resp, "image/png");
        resp.getOutputStream().write(imageBytes);
    }

    private String updateCCSVGPathVariablesForJavaClient(String path) {
        try {
            String[] defaults = new String[]{"#000000", "16x16"};
            int counter = -1;
            while (true) {
                ++counter;
                int index1 = path.indexOf("@");
                int index2 = path.indexOf("@", index1 + 1);
                if (index2 >= 0) {
                    String name = path.substring(index1, index2 + 1);
                    String styleName = SessionInfo.getSessionDefaultStyleForJavaClient();
                    String value = StyleManager.getStyleValue(styleName, name);
                    if (value == null) {
                        value = defaults[counter % defaults.length];
                    }
                    path = path.substring(0, index1) + value + path.substring(index2 + 1);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return path;
    }
}

