/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.veracode.annotation.XSSCleanser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.CSSStyleManager;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.style.StyleFileAccess;
import org.eclnt.util.log.CLog;
import org.eclnt.util.mitigation.CCMitigation;

@CCMitigation(cweIds={}, comment="This servlet loads a .css style that is assembled dynamically out of XML files. The XML files are development artifacts and are created without embedding e.g. application data.")
public class StyleReaderServlet
extends CCServletBase {
    @Override
    protected boolean checkIfToInitializeCCEnvironment() {
        return false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if ("GET".equals(method)) {
            ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
        }
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        String uri = req.getRequestURI();
        int index = uri.indexOf("?");
        if (index >= 0) {
            uri = uri.substring(0, index);
        }
        if ((index = uri.indexOf(";")) >= 0) {
            uri = uri.substring(0, index);
        }
        if ((index = uri.indexOf("/eclntjsfserver/styles/")) < 0) {
            throw new Error("Could not find /eclntjsfserver/styles/ in URI: " + uri);
        }
        uri = uri.substring(index);
        String uriPart = uri.substring("/eclntjsfserver/styles/".length());
        int indexSlash = uriPart.indexOf("/");
        String styleName = uriPart.substring(0, indexSlash);
        String fileName = uriPart.substring(indexSlash + 1);
        try {
            if ("riscstyle.css".equals(fileName)) {
                this.writeCSSToResponse(resp, CSSStyleManager.readCSS(styleName));
                return;
            }
            if ("riscstyle.json".equals(fileName)) {
                this.writeJSONToResponse(resp, CSSStyleManager.readJSON(styleName));
                return;
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when creating style files", t);
        }
        try {
            byte[] data = StyleFileAccess.readStyleFile(uri);
            if (data != null && data.length > 0) {
                this.setContentType(uri, resp);
                ServletUtil.writeTrustedDataToResponseOutputStream(resp, data);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @XSSCleanser(userComment="Writes generated JSON into the response. The JSON is completely created by the CaptainCasa style management, the only parameter within the processed URL that is influencing the generation is the name of the style. If the name of the style is not matching a defined style then this will not be processed. The content of the JSON is only dependent on the application style definition.")
    private void writeJSONToResponse(HttpServletResponse resp, String json) throws IOException {
        resp.getWriter().write(json);
    }

    @XSSCleanser(userComment="Writes generated CSS into the response. The CSS is completely created by the CaptainCasa style management, the only parameter within the processed URL that is influencing the generation is the name of the style. If the name of the style is not matching a defined style then this will not be processed. The content of the CSS is only dependent on the application style definition.")
    private void writeCSSToResponse(HttpServletResponse resp, String css) throws IOException {
        this.setContentType("riscstyle.css", resp);
        resp.getWriter().write(css);
    }
}

