/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.el;

import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public class ExpressionChecker {
    static ExpressionChecker s_instance = new ExpressionChecker();

    public static ExpressionChecker instance() {
        return s_instance;
    }

    public CheckResult checkExpression(String vbString) {
        CheckResult result = new CheckResult();
        int imax = vbString.length() - 1;
        if (vbString.charAt(0) != '#' || vbString.charAt(vbString.length() - 1) != '}') {
            result.expressionIsComplex = true;
        }
        if (!result.expressionIsComplex) {
            boolean quoteOpened = false;
            String invalidCharacters = SystemXml.getInvalidExpressionDetectionInvalidCharacters();
            for (int i = 2; i < imax; ++i) {
                char c = vbString.charAt(i);
                if (c == '\'' || c == '\"') {
                    boolean bl = quoteOpened = !quoteOpened;
                }
                if (quoteOpened) continue;
                if (invalidCharacters.indexOf(c) >= 0) {
                    CLog.L.log(CLog.LL_ERR, "Invalid expression detected: " + vbString);
                    result.expressionIsValid = false;
                    break;
                }
                if (c != '=' && c != '!' && c != '+' && c != '-' && c != '*' && c != '/' && c != '>' && c != '<' && c != ' ') continue;
                result.expressionIsComplex = true;
            }
        }
        if (!result.expressionIsComplex && result.expressionIsValid && vbString.endsWith(".}")) {
            result.expressionIsValid = false;
        }
        return result;
    }

    public static class CheckResult {
        public boolean expressionIsComplex = false;
        public boolean expressionIsValid = true;
    }
}

