/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.markdown;

import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.file.ClassloaderReader;

class MarkdownTextConverter {
    Parser m_parser = Parser.builder().build();
    HtmlRenderer m_htmlRenderer = HtmlRenderer.builder().build();
    private static MarkdownTextConverter s_instance = new MarkdownTextConverter();

    static MarkdownTextConverter instance() {
        return s_instance;
    }

    String convertMarkdownToHtml(String markdown, int dirLevel) {
        if (markdown == null) {
            return null;
        }
        Node document = this.m_parser.parse(markdown);
        String html = this.m_htmlRenderer.render(document);
        String body = new ClassloaderReader(true).readUTF8File(SystemXml.getMarkdownTemplatepath(), true);
        String toRoot = this.calculateToRoot(dirLevel);
        html = body.replace("@content@", html);
        html = html.replace("@markdownCss@", SystemXml.getMarkdownCsspath());
        html = html.replace("@toRoot@", toRoot);
        return html;
    }

    private String calculateToRoot(int dirLevel) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < dirLevel; ++i) {
            sb.append("../");
        }
        return sb.toString();
    }
}

