/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.useraccess;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Hashtable;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.useraccess.ITenantAccess;

public class DefaultTenantAccess
implements ITenantAccess {
    private static final String KEY_TENANT = DefaultTenantAccess.class.getName() + "/tenant";
    private static final Map<Thread, String> s_tenantPerThread = new Hashtable<Thread, String>();

    public String getCurrentTenant(FacesContext context) {
        return this.getCurrentTenant();
    }

    @Override
    public String getCurrentTenant() {
        String tenant;
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            if (dialogSession != null && (tenant = (String)dialogSession.getAttribute(KEY_TENANT)) != null) {
                return tenant;
            }
        }
        catch (Throwable dialogSession) {
            // empty catch block
        }
        try {
            HttpSession httpSession = HttpSessionAccess.getCurrentHttpSession();
            if (httpSession != null && (tenant = (String)httpSession.getAttribute(KEY_TENANT)) != null) {
                return tenant;
            }
        }
        catch (Throwable httpSession) {
            // empty catch block
        }
        try {
            String tenant2 = s_tenantPerThread.get(Thread.currentThread());
            if (tenant2 != null) {
                return tenant2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "undefined";
    }

    public static void associateTenantWithCurrentSession(String tenant) {
        HttpSession httpSession = HttpSessionAccess.getCurrentHttpSession();
        if (httpSession == null) {
            if (!UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                throw new Error("No http session available in the current context. Not possible to store tenant with http session.");
            }
            return;
        }
        httpSession.setAttribute(KEY_TENANT, (Object)tenant);
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession(httpSession);
            dialogSession.setAttribute(KEY_TENANT, tenant);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void associateTenantWithCurrentSession(HttpServletRequest request, String tenant) {
        HttpSession session = request.getSession();
        session.setAttribute(KEY_TENANT, (Object)tenant);
        String subpageId = request.getParameter("cc_subpageId");
        if (subpageId != null) {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession(session, subpageId);
            dialogSession.setAttribute(KEY_TENANT, tenant);
        }
    }

    public static void clearTenantWithCurrentSession() {
        HttpSession httpSession = HttpSessionAccess.getCurrentHttpSession();
        if (httpSession != null) {
            httpSession.removeAttribute(KEY_TENANT);
        }
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            if (dialogSession != null) {
                dialogSession.removeAttribute(KEY_TENANT);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void associateTenantWithCurrentThread(String tenant) {
        s_tenantPerThread.put(Thread.currentThread(), tenant);
    }

    public static void clearTenantWithCurrentThread() {
        s_tenantPerThread.remove(Thread.currentThread());
    }
}

