/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.useraccess;

import java.util.Locale;
import org.eclnt.jsfserver.util.useraccess.ILanguageAccess;
import org.eclnt.jsfserver.util.useraccess.impl.DummyLanguageInfoProviderImpl;
import org.eclnt.util.classloaderaccess.ClassLoaderAccess;
import org.eclnt.util.log.ULog;

public class LanguageAccessMgr {
    static IInfoProvider s_infoProvider = new DummyLanguageInfoProviderImpl();
    static Object s_syncher = new Object();
    static ILanguageAccess s_instance;
    static ClassLoader s_lastClassLoader;

    public static void initializeInfoProvider(IInfoProvider infoProvider) {
        s_infoProvider = infoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILanguageAccess getInstance() {
        if (s_infoProvider == null) {
            throw new Error("LanguageAccessMgr not yet configured - info provider not set.");
        }
        if (s_lastClassLoader == ClassLoaderAccess.currentClassLoader()) {
            return s_instance;
        }
        Object object = s_syncher;
        synchronized (object) {
            if (s_lastClassLoader == ClassLoaderAccess.currentClassLoader()) {
                return s_instance;
            }
            try {
                s_instance = s_infoProvider.createLanguageAccess();
                s_lastClassLoader = ClassLoaderAccess.currentClassLoader();
                return s_instance;
            }
            catch (Throwable t) {
                ULog.logERR("Problems creating the user access management", t);
                s_lastClassLoader = ClassLoaderAccess.currentClassLoader();
                return null;
            }
        }
    }

    public static String getCurrentLanguage() {
        ILanguageAccess la = LanguageAccessMgr.getInstance();
        if (la == null) {
            return Locale.getDefault().getLanguage();
        }
        return la.getCurrentLanguage();
    }

    public static String getCurrentCountry() {
        ILanguageAccess la = LanguageAccessMgr.getInstance();
        if (la == null) {
            return Locale.getDefault().getCountry();
        }
        return la.getCurrentCountry();
    }

    public static interface IInfoProvider {
        public ILanguageAccess createLanguageAccess();
    }
}

