/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclnt.util.file.CLFileInfo;
import org.eclnt.util.valuemgmt.ValueManager;

@XmlRootElement(name="dir")
public class CLDirectoryInfo {
    String m_name;
    List<CLDirectoryInfo> m_directories = new Vector<CLDirectoryInfo>();
    List<CLFileInfo> m_files = new Vector<CLFileInfo>();

    public CLDirectoryInfo() {
    }

    public CLDirectoryInfo(String name) {
        this.m_name = name;
    }

    @XmlElement(name="dir")
    public List<CLDirectoryInfo> getDirectories() {
        return this.m_directories;
    }

    public void setDirectories(List<CLDirectoryInfo> directories) {
        this.m_directories = directories;
    }

    @XmlElement(name="file")
    public List<CLFileInfo> getFiles() {
        return this.m_files;
    }

    public void setFiles(ArrayList<CLFileInfo> files) {
        this.m_files = files;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void removeEmptyDirectories() {
        for (int i = this.m_directories.size() - 1; i >= 0; --i) {
            CLDirectoryInfo waDir = this.m_directories.get(i);
            if (waDir.checkIfContainsFiles()) continue;
            this.m_directories.remove(i);
        }
        for (CLDirectoryInfo waDir : this.m_directories) {
            waDir.removeEmptyDirectories();
        }
    }

    public CLDirectoryInfo findDirectory(String path) {
        int slashIndex;
        if ((path = ValueManager.encodeIntoValidWebResourcePath(path, true)).length() == 1) {
            return this;
        }
        String name = (path = path.substring(1)).substring(0, slashIndex = path.indexOf("/"));
        CLDirectoryInfo wad = this.findDir(this.m_directories, name);
        if (wad == null) {
            return null;
        }
        path = path.substring(name.length());
        return wad.findDirectory(path);
    }

    public boolean checkIfContainsFiles() {
        if (this.m_files.size() > 0) {
            return true;
        }
        if (this.m_directories.size() == 0) {
            return false;
        }
        for (CLDirectoryInfo subWADir : this.m_directories) {
            if (!subWADir.checkIfContainsFiles()) continue;
            return true;
        }
        return false;
    }

    public void merge(CLDirectoryInfo from) {
        Object toWad;
        for (CLDirectoryInfo cLDirectoryInfo : from.m_directories) {
            toWad = this.findDir(this.m_directories, cLDirectoryInfo.getName());
            if (toWad == null) {
                this.m_directories.add(cLDirectoryInfo);
                continue;
            }
            ((CLDirectoryInfo)toWad).merge(cLDirectoryInfo);
        }
        for (CLFileInfo cLFileInfo : from.m_files) {
            toWad = this.findFile(this.m_files, cLFileInfo.getName());
            if (toWad != null) continue;
            this.m_files.add(cLFileInfo);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.appendToString(sb, 0);
        return sb.toString();
    }

    private void appendToString(StringBuffer sb, int level) {
        String dist = "";
        for (int i = 0; i < level; ++i) {
            dist = dist + "  ";
        }
        sb.append(dist + this.m_name + "/\n");
        for (CLDirectoryInfo cLDirectoryInfo : this.m_directories) {
            cLDirectoryInfo.appendToString(sb, level + 1);
        }
        for (CLFileInfo cLFileInfo : this.m_files) {
            sb.append(dist + "  " + cLFileInfo.getName() + "\n");
        }
    }

    private CLDirectoryInfo findDir(List<CLDirectoryInfo> wads, String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        for (CLDirectoryInfo wad : wads) {
            if (!ValueManager.checkIfStringsAreEqual(name, wad.getName())) continue;
            return wad;
        }
        return null;
    }

    private CLFileInfo findFile(List<CLFileInfo> wads, String name) {
        for (CLFileInfo wad : wads) {
            if (!ValueManager.checkIfStringsAreEqual(name, wad.getName())) continue;
            return wad;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLDirectoryInfo ensureDirectoryExists(String path) {
        if ((path = ValueManager.encodeIntoValidWebResourcePath(path, true)).length() == 1) {
            return this;
        }
        path = path.substring(1, path.length() - 1);
        String[] tokens = ValueManager.tokenize(path, "/");
        CLDirectoryInfo current = this;
        for (String token : tokens) {
            CLDirectoryInfo subDir = current.findDir(current.getDirectories(), token);
            if (subDir == null) {
                CLDirectoryInfo cLDirectoryInfo = current;
                synchronized (cLDirectoryInfo) {
                    subDir = current.findDir(current.getDirectories(), token);
                    if (subDir == null) {
                        subDir = new CLDirectoryInfo(token);
                        current.m_directories.add(subDir);
                    }
                }
            }
            current = subDir;
        }
        return current;
    }
}

