/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.bufferedcontent.BufferedContentMgr;
import org.eclnt.jsfserver.bufferedcontent.BufferedContentServlet;
import org.eclnt.jsfserver.bufferedcontent.IBufferedContent;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.CLResourceAccessServlet;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.jsfserver.util.tempfile.TempFileManager;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.http.HttpReader;
import org.eclnt.util.image.ExtImageFilterAllBlocked;
import org.eclnt.util.image.FontImageCreator;
import org.eclnt.util.image.IExtImageFilter;
import org.eclnt.util.image.IImageReader;
import org.eclnt.util.image.ImageExifReader;
import org.eclnt.util.image.SVGImageManagerFactory;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ImageShrinker;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerImageManager {
    static final double PX_TO_PT = 0.74999943307122;
    static ServerImageManager s_instance;
    static CCConfigurationObject<IImageReader> s_imageReader;
    static CCConfigurationObject<IExtImageFilter> s_extImageFilter;
    String m_bufferDirectory;
    Map<String, Dimension> m_bufferedSizes = new Hashtable<String, Dimension>();

    private ServerImageManager(ServletContext context) {
        String dirName = HttpSessionAccess.getServletTempDirectory(context);
        dirName = dirName + "/ccserverimagemanager/";
        this.m_bufferDirectory = dirName = ValueManager.encodeIntoValidFileName(dirName, true);
        CLog.L.log(CLog.LL_INF, "ServerImageManger: created instance with directory " + this.m_bufferDirectory);
    }

    public static void initialize(ServletContext context) {
        String cn;
        s_instance = new ServerImageManager(context);
        s_instance.clear();
        try {
            String tempDir = HttpSessionAccess.getServletTempDirectory(context);
            tempDir = tempDir + "/java/tempimageio/";
            tempDir = ValueManager.encodeIntoValidFileName(tempDir, true);
            FileManager.ensureDirectoryForFileExists(tempDir);
            FileManager.ensureFileIsWriteable(tempDir, true);
            File f = new File(tempDir);
            ImageIO.setCacheDirectory(f);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem setting ImageIO cache directory", t);
        }
        try {
            cn = SystemXml.getImageReaderClassName();
            if (cn != null) {
                s_imageReader = new CCConfigurationObject(cn, null);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem creating instance of IImageReader: " + SystemXml.getImageReaderClassName(), t);
        }
        try {
            cn = SystemXml.getExtImageFilterClassName();
            if (cn != null) {
                s_extImageFilter = new CCConfigurationObject(cn, null);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem creating instance of IImageReader: " + SystemXml.getImageReaderClassName(), t);
        }
    }

    public static ServerImageManager getInstance() {
        if (s_instance == null) {
            throw new Error("ServerImageManaer not available - not initialized yet");
        }
        return s_instance;
    }

    public byte[] readImage(String dynImage) throws Exception {
        if (s_imageReader.instance() != null) {
            try {
                byte[] result = s_imageReader.instance().readImage(dynImage);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "IImageReader threw error: " + dynImage, t);
            }
        }
        if (dynImage.startsWith("/ccdynamicimage/")) {
            dynImage = dynImage.substring("/ccdynamicimage/".length() - 1);
            return this.readDynamicImage(dynImage, true);
        }
        if (dynImage.startsWith("/ccbuffer/")) {
            return this.readBufferedImage(dynImage);
        }
        if (dynImage.startsWith("/cctempfileaccess/")) {
            return this.readTempFileImage(dynImage);
        }
        if (dynImage.endsWith(".ccclresource")) {
            dynImage = dynImage.substring(0, dynImage.length() - ".ccclresource".length());
            return CLResourceAccessServlet.readImage(dynImage);
        }
        if (dynImage.startsWith("http://") || dynImage.startsWith("https://")) {
            return this.readImageFromURL(dynImage);
        }
        return this.readImageAsResource(dynImage);
    }

    public byte[] readDynamicImage(String dynImage) throws Exception {
        return this.readDynamicImage(dynImage, true);
    }

    public Dimension getDimensionOfImage(String image) throws Exception {
        Dimension d = this.m_bufferedSizes.get(image);
        if (d == null) {
            byte[] imgBytes = this.readImage(image);
            if (!this.checkIfSVGImage(image)) {
                d = this.calculateDimensionOfBinaryImage(image, imgBytes);
                this.m_bufferedSizes.put(image, d);
            } else {
                d = this.calculateDimensionOfSVGImage(image, imgBytes);
                this.m_bufferedSizes.put(image, d);
            }
        }
        return d;
    }

    protected boolean checkIfSVGImage(String image) {
        int qmIndex = image.indexOf(63);
        if (qmIndex >= 0) {
            image = image.substring(qmIndex);
        }
        return (image = ValueManager.toLowerCaseId(image)).endsWith(".svg");
    }

    protected Dimension calculateDimensionOfSVGImage(String image, byte[] imgBytes) {
        try {
            String svg = new String(imgBytes, "UTF-8");
            return ServerImageManager.calculateDimensionOfSVGImage(svg);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "ServerImageManager: could not find size of image: " + image, t);
            return new Dimension(16, 16);
        }
    }

    public static Dimension calculateDimensionOfSVGImage(String svg) {
        try {
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(svg));
            parser.parse(is, (DefaultHandler)new SVGParser());
            return new Dimension(16, 16);
        }
        catch (SVGParserStoppedError spse) {
            if (spse.m_height == -1 || spse.m_width == -1) {
                return new Dimension(16, 16);
            }
            return new Dimension(spse.m_width, spse.m_height);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "ServerImageManager: could not find size of image: " + ValueManager.truncateString(svg, 100), t);
            return new Dimension(16, 16);
        }
    }

    protected Dimension calculateDimensionOfBinaryImage(String image, byte[] imgBytes) {
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(imgBytes));
            Dimension d = new Dimension(((Image)img).getWidth(null), ((Image)img).getHeight(null));
            try {
                boolean rotated = ImageExifReader.checkIfImageIsRotated(imgBytes);
                if (rotated) {
                    d = new Dimension(d.height, d.width);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return d;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "ServerImageManager: could not find size of image: " + image, t);
            return new Dimension(16, 16);
        }
    }

    private byte[] readTempFileImage(String path) {
        int index = path.indexOf("/cctempfileaccess/");
        if (index < 0) {
            throw new Error("Could not finde /cctempfileaccess/ in URI.");
        }
        path = path.substring(index + "/cctempfileaccess/".length());
        HttpSession session = HttpSessionAccess.getCurrentHttpSession();
        return TempFileManager.readTempFile(session, path);
    }

    private byte[] readBufferedImage(String bufferedImageURI) {
        String bufferId = BufferedContentServlet.readBufferIdFromURI(bufferedImageURI);
        HttpSession session = HttpSessionAccess.getCurrentHttpSession();
        Object o = BufferedContentMgr.readBufferedContent(session, bufferId);
        if (o instanceof IBufferedContent) {
            return ((IBufferedContent)o).getContent();
        }
        throw new Error("Reading image is not supported: " + o.getClass().getName());
    }

    private byte[] readDynamicImage(String dynImage, boolean useFileBuffer) throws Exception {
        if (useFileBuffer) {
            byte[] buffered = null;
            buffered = this.readFromClassloader(dynImage);
            if (buffered == null) {
                buffered = this.readFromFileBuffer(dynImage);
            }
            if (buffered != null) {
                return buffered;
            }
        }
        byte[] result = null;
        result = dynImage.startsWith("/resize(") || dynImage.startsWith("/stretch(") ? this.readDynamicImageStretchResize(dynImage) : (dynImage.startsWith("/mirrored:") || dynImage.startsWith("/mirrored(") ? this.readDynamicImageMirrored(dynImage) : (dynImage.startsWith("/awesomefont(") ? this.readAwesomeFontImage(dynImage) : (dynImage.startsWith("/sapicon(") ? this.readSAPIconsFontImage(dynImage) : (dynImage.startsWith("/textimage(") ? this.readTextImage(dynImage) : (dynImage.startsWith("/svg(") ? this.readSVGImage(dynImage) : this.readImageAsResource(dynImage))))));
        if (useFileBuffer && result != null) {
            this.writeToFileBuffer(dynImage, result);
        }
        return result;
    }

    private byte[] readAwesomeFontImage(String dynImage) throws Exception {
        BufferedImage image = FontImageCreator.createAwesomeFontImage(dynImage);
        byte[] result = this.createPNGImageBytesFromBufferedImage(image);
        return result;
    }

    private byte[] readSAPIconsFontImage(String dynImage) throws Exception {
        BufferedImage image = FontImageCreator.createSAPIconsFontImage(dynImage);
        byte[] result = this.createPNGImageBytesFromBufferedImage(image);
        return result;
    }

    private byte[] readSVGImage(String dynImage) throws Exception {
        byte[] result = SVGImageManagerFactory.instance().findImage(dynImage);
        return result;
    }

    private byte[] readTextImage(String dynImage) throws Exception {
        String[] params = ValueManager.decodeMethodParams(dynImage);
        String text = params[0];
        String size = params[1];
        String colorStr = params[2];
        int sizeInt = ValueManager.decodeInt(size, 11);
        if (text.length() > 100) {
            throw new Error("Maximum length of text is limited to 100 characters.");
        }
        if (sizeInt > 100) {
            throw new Error("Maximum size is limited to 100.");
        }
        Font font = new Font("Trebuchet MS", 0, sizeInt);
        BufferedImage image = FontImageCreator.createImageFromText(text, font, ValueManager.decodeColor(colorStr));
        byte[] result = this.createPNGImageBytesFromBufferedImage(image);
        return result;
    }

    private byte[] readDynamicImageMirrored(String dynImage) throws Exception {
        float mirrorFactor;
        int percentage = 100;
        int colonIndex = dynImage.indexOf(58);
        if (dynImage.startsWith("/mirrored(")) {
            String arg = dynImage.substring("/mirrored(".length(), colonIndex - 1);
            percentage = ValueManager.decodeInt(arg, 100);
        }
        if ((mirrorFactor = (100.0f + (float)percentage) / 100.0f) > 11.0f) {
            throw new Error("Percentage factor is limited to 1000.");
        }
        String image = dynImage.substring(colonIndex + 1);
        byte[] imageBytes = this.readDynamicImage(image, false);
        BufferedImage imageTop = ImageIO.read(new ByteArrayInputStream(imageBytes));
        Rectangle r = new Rectangle(((Image)imageTop).getWidth(null), ((Image)imageTop).getHeight(null));
        BufferedImage mirroredImg = null;
        mirroredImg = new BufferedImage(r.width, r.height, 2);
        Graphics2D gbi = mirroredImg.createGraphics();
        gbi.translate(0, r.height);
        gbi.scale(1.0, -1.0);
        gbi.drawImage(imageTop, 0, 0, r.width, r.height, null);
        AlphaComposite ac = AlphaComposite.getInstance(6, 1.0f);
        GradientPaint grp = new GradientPaint(0.0f, 0.0f, ValueManager.decodeColor("#FF000000"), 0.0f, r.height, ValueManager.decodeColor("#FF000060"), true);
        gbi.setColor(null);
        gbi.setPaint(grp);
        gbi.setComposite(ac);
        gbi.fill(new Rectangle2D.Double(0.0, 0.0, r.width, r.height));
        BufferedImage buffImg = new BufferedImage(r.width, Math.round(mirrorFactor * (float)r.height) + 2, 2);
        Graphics2D gbi2 = buffImg.createGraphics();
        gbi2.drawImage((Image)imageTop, 0, 0, null);
        gbi2.drawImage(mirroredImg, 0, r.height + 2, r.width, Math.round((mirrorFactor - 1.0f) * (float)r.height), null);
        byte[] result = this.createPNGImageBytesFromBufferedImage(buffImg);
        return result;
    }

    private byte[] readDynamicImageStretchResize(String dynImage) throws Exception {
        int endIndex = dynImage.indexOf(":");
        String command = dynImage.substring(0, endIndex);
        String image = dynImage.substring(endIndex + 1);
        byte[] imageBytes = this.readDynamicImage(image, false);
        String[] params = ValueManager.decodeMethodParams(command);
        int newWidth = ValueManager.decodeInt(params[0], 16);
        int newHeight = ValueManager.decodeInt(params[1], 16);
        if (newWidth > 4000) {
            throw new Error("Width is limited to 4000.");
        }
        if (newHeight > 4000) {
            throw new Error("Height is limited to 4000.");
        }
        if (newHeight <= 0 || newWidth <= 0) {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (newHeight <= 0) {
                newHeight = Math.round((float)((Image)img).getHeight(null) * (float)newWidth / (float)((Image)img).getWidth(null));
            } else if (newWidth <= 0) {
                newWidth = Math.round((float)((Image)img).getWidth(null) * (float)newHeight / (float)((Image)img).getHeight(null));
            }
        }
        String format = "png";
        boolean keepRatio = true;
        if (dynImage.startsWith("/stretch(")) {
            keepRatio = false;
        }
        byte[] result = ImageShrinker.sizeImage(imageBytes, newWidth, newHeight, 0.85f, format, keepRatio, false);
        return result;
    }

    private void writeToFileBuffer(String dynImage, byte[] image) {
        String fileName = ServerImageManager.buildFileNameFromDynImage(this.m_bufferDirectory, dynImage);
        FileManager.ensureDirectoryForFileExists(fileName);
        FileManager.writeFile(fileName, image, false);
    }

    private byte[] createPNGImageBytesFromBufferedImage(BufferedImage img) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", bos);
        return bos.toByteArray();
    }

    private byte[] readFromClassloader(String dynImage) {
        String fileName = ServerImageManager.buildFileNameFromDynImage("org/eclnt/ccserverimagebuffer/", dynImage);
        byte[] result = new ClassloaderReader(HotDeployManager.currentClassLoader()).readFile(fileName, false);
        if (result == null) {
            fileName = ServerImageManager.buildFileNameFromDynImageSecondTry("org/eclnt/ccserverimagebuffer/", dynImage);
            result = new ClassloaderReader(HotDeployManager.currentClassLoader()).readFile(fileName, false);
        }
        return result;
    }

    private byte[] readFromFileBuffer(String dynImage) {
        String fileName = ServerImageManager.buildFileNameFromDynImage(this.m_bufferDirectory, dynImage);
        if (!FileManager.checkIfFileExists(fileName) && !FileManager.checkIfFileExists(fileName = ServerImageManager.buildFileNameFromDynImageSecondTry(this.m_bufferDirectory, dynImage))) {
            return null;
        }
        return FileManager.readFile(fileName, true);
    }

    public static String buildFileNameFromDynImage(String directoryWS, String dynImage) {
        dynImage = dynImage.replace(",", "_");
        dynImage = dynImage.replaceAll("[#:\\\\/*\"?|<>']", "");
        return directoryWS + dynImage + ".png";
    }

    public static String buildFileNameFromDynImageSecondTry(String directoryWS, String dynImage) {
        dynImage = dynImage.replace(",", "_");
        dynImage = dynImage.replaceAll("[#:\\\\/*\"?|<>']", "");
        dynImage = ValueManager.toLowerCaseId(dynImage);
        return directoryWS + dynImage + ".png";
    }

    private byte[] readImageAsResource(String imageName) {
        ResourceSecurity.checkResourcePathForOutsideUsage(imageName);
        return WebResourceClassloaderReader.readFileIntoByteArray(imageName);
    }

    private byte[] readImageFromURL(String url) {
        if (s_extImageFilter.instance() != null && !s_extImageFilter.instance().checkURL(url)) {
            throw new Error("The image with url " + url + " was not processed on server side, because it is blocked by the IExtImageFilter implementation.");
        }
        return HttpReader.readBytesFromURL(url);
    }

    public void clear() {
        try {
            this.m_bufferedSizes.clear();
            FileManager.deleteDirectoryContent(this.m_bufferDirectory);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when clearing file buffer", t);
        }
    }

    static {
        s_imageReader = new CCConfigurationObject<Object>(null);
        s_extImageFilter = new CCConfigurationObject<ExtImageFilterAllBlocked>(new ExtImageFilterAllBlocked());
    }

    static class SVGParser
    extends DefaultHandler {
        SVGParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("svg")) {
                double d;
                String width = attributes.getValue("width");
                String height = attributes.getValue("height");
                int w = -1;
                int h = -1;
                if (width != null) {
                    if (width.endsWith("px")) {
                        width = width.substring(0, width.length() - 2);
                        w = ValueManager.decodeIntWithRounding(width, -1);
                    } else {
                        w = width.endsWith("pt") ? ((d = ValueManager.decodeDouble(width = width.substring(0, width.length() - 2), -1.0)) >= 0.0 ? (int)Math.round(d / 0.74999943307122) : -1) : ValueManager.decodeIntWithRounding(width, -1);
                    }
                }
                if (height != null) {
                    if (height.endsWith("px")) {
                        height = height.substring(0, height.length() - 2);
                        h = ValueManager.decodeIntWithRounding(height, -1);
                    } else {
                        h = height.endsWith("pt") ? ((d = ValueManager.decodeDouble(height = height.substring(0, height.length() - 2), -1.0)) >= 0.0 ? (int)Math.round(d / 0.74999943307122) : -1) : ValueManager.decodeIntWithRounding(height, -1);
                    }
                }
                throw new SVGParserStoppedError(w, h);
            }
            throw new SVGParserStoppedError();
        }
    }

    static class SVGParserStoppedError
    extends Error {
        public int m_width = -1;
        public int m_height = -1;

        public SVGParserStoppedError() {
        }

        public SVGParserStoppedError(int width, int height) {
            this.m_width = width;
            this.m_height = height;
        }
    }
}

