/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long m_count = 0L;
    private Runnable m_runBeforeFirstWrite = null;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public CountingOutputStream(OutputStream out, Runnable runBeforeFirstWrite) {
        super(out);
        this.m_runBeforeFirstWrite = runBeforeFirstWrite;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_runBeforeFirstWrite != null && this.m_count == 0L) {
            this.m_runBeforeFirstWrite.run();
        }
        super.write(b);
        ++this.m_count;
    }

    public long getCount() {
        return this.m_count;
    }
}

