/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

public class MaskedValueManager {
    public static String convertNetValueIntoMaskedValue(String value, String mask, char maskPlaceHolder) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        if (mask == null) {
            return value;
        }
        int realIndex = 0;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < mask.length(); ++i) {
            if (mask.charAt(i) == maskPlaceHolder) {
                if (value.length() > realIndex && value.charAt(realIndex) != ' ') {
                    result.append(value.charAt(realIndex));
                } else {
                    result.append(maskPlaceHolder);
                }
                ++realIndex;
                continue;
            }
            result.append(mask.charAt(i));
        }
        if (value.length() > realIndex) {
            result.append(value.substring(realIndex));
        }
        return result.toString();
    }

    public static String convertMaskedValueIntoNetValue(String value, String mask, char maskPlaceHolder) {
        if (value == null) {
            return null;
        }
        if (mask == null) {
            return value;
        }
        for (int i = mask.length() - 1; i >= 0; --i) {
            try {
                if (mask.charAt(i) == maskPlaceHolder || value.charAt(i) != mask.charAt(i)) continue;
                value = value.substring(0, i) + value.substring(i + 1);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        value = value.replace("" + maskPlaceHolder, " ");
        value = MaskedValueManager.trimRight(value);
        return value;
    }

    public static String createRegularExpressionForMask(String mask, char maskPlaceHolder, String allowedCharactersDefinition) {
        return MaskedValueManager.createRegularExpressionForMask(mask, maskPlaceHolder, allowedCharactersDefinition, true);
    }

    public static String createRegularExpressionForMask(String mask, char maskPlaceHolder, String allowedCharactersDefinition, boolean withUnicodeConversion) {
        StringBuffer result = new StringBuffer();
        StringBuffer currentToken = new StringBuffer();
        boolean currentTokenContainsPlaceholder = true;
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            if (currentTokenContainsPlaceholder) {
                if (c == maskPlaceHolder) {
                    currentToken.append(c);
                    continue;
                }
                result.append(MaskedValueManager.createPlaceHolderRegexForMaskedToken(currentToken, allowedCharactersDefinition));
                currentToken = new StringBuffer();
                currentToken.append(c);
                currentTokenContainsPlaceholder = false;
                continue;
            }
            if (c != maskPlaceHolder) {
                currentToken.append(c);
                continue;
            }
            result.append(MaskedValueManager.createPlaceHolderRegexForNonMaskedToken(currentToken, allowedCharactersDefinition));
            currentToken = new StringBuffer();
            currentToken.append(c);
            currentTokenContainsPlaceholder = true;
        }
        if (currentTokenContainsPlaceholder) {
            result.append(MaskedValueManager.createPlaceHolderRegexForMaskedToken(currentToken, allowedCharactersDefinition));
        } else {
            result.append(MaskedValueManager.createPlaceHolderRegexForNonMaskedToken(currentToken, allowedCharactersDefinition));
        }
        String resultString = result.toString();
        if (withUnicodeConversion) {
            resultString = MaskedValueManager.updateUnicodeCharacters(resultString);
        }
        return resultString;
    }

    private static String updateUnicodeCharacters(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                sb.append("\\u" + String.format("%04X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String createPlaceHolderRegexForMaskedToken(StringBuffer currentToken, String allowedCharactersDefinition) {
        if (currentToken == null) {
            return "";
        }
        if (currentToken.length() == 0) {
            return "";
        }
        return "[" + allowedCharactersDefinition + "]{" + currentToken.length() + "}";
    }

    private static String createPlaceHolderRegexForNonMaskedToken(StringBuffer currentToken, String allowedCharactersDefinition) {
        if (currentToken == null) {
            return "";
        }
        String s = currentToken.toString();
        String reservedCharacters = "\\/.+*?^$()[]{}|";
        for (int i = 0; i < reservedCharacters.length(); ++i) {
            s = s.replace("" + reservedCharacters.charAt(i), "\\" + reservedCharacters.charAt(i));
        }
        return s;
    }

    private static String trimRight(String convValue) {
        for (int i = convValue.length() - 1; i >= 0 && convValue.charAt(i) == ' '; --i) {
            convValue = convValue.substring(0, convValue.length() - 1);
        }
        return convValue;
    }
}

