/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextField;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.configparams.CCConfigParams;
import org.eclnt.util.configparams.ICCConfigParams;
import org.eclnt.util.log.ULog;
import org.eclnt.util.valuemgmt.FileNameValidatesSecurityRuleError;
import org.eclnt.util.valuemgmt.ISimpleDataTypeExtension;
import org.eclnt.util.valuemgmt.LocalDate18Manager;
import org.eclnt.util.valuemgmt.Padding;
import org.eclnt.util.valuemgmt.Scale;
import org.eclnt.util.valuemgmt.TextSelectionInfo;
import org.eclnt.util.valuemgmt.UUID17Manager;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.impl.ValueManagerInfoProviderUtilImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValueManager {
    public static final String CHAR_SEMI = ";";
    public static final String CHAR_COMMA = ",";
    public static final String CHARX_RETURN = "\\x0D";
    public static final String CHARX_COLON = "\\x3A";
    public static final String CHARX_SEMI = "\\x3B";
    public static final String CHARX_COMMA = "\\x2C";
    public static final String CHARX_BRACKETOPEN = "\\x28";
    public static final String CHARX_BRACKETCLOSE = "\\x29";
    static char[] HEXIS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static Locale s_localeLowerUppercase = new Locale("en", "US");
    static Set<Character> CHARSET_NOTALLOWED_IN_FILENAME = new HashSet<Character>();
    static Set<Character> CHARSET_NOTALLOWED_IN_FILEPATH = new HashSet<Character>();
    static IValueManagerInfoProvider s_infoProvider = new ValueManagerInfoProviderUtilImpl();
    static Set<ISimpleDataTypeExtension> s_simpleDataTypeExtensions = new HashSet<ISimpleDataTypeExtension>();
    private static Map<Integer, String> s_emptyStrings = new Hashtable<Integer, String>();
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final Calendar CALENDAR_UTC = Calendar.getInstance(TIMEZONE_UTC);
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    static Font s_defaultFont;
    static Font s_defaultScaledFont;
    private static final char[] escapeXMLStringFroms;
    private static final String[] escapeXMLStringTos;
    private static final char[] encodeIntoValidXMLStringFroms;
    private static final String[] encodeIntoValidXMLStringTos;
    private static final char[] encodeIntoValidXMLValueStringFroms;
    private static final String[] encodeIntoValidXMLValueStringTos;
    private static final String TEMP_REPLACE_ASTERISK;

    public static void initializeInfoProvider(IValueManagerInfoProvider infoProvider) {
        s_infoProvider = infoProvider;
    }

    public static synchronized void initializeAddSimpleDataTypeExtension(ISimpleDataTypeExtension extension) {
        s_simpleDataTypeExtensions.add(extension);
    }

    public static Set<ISimpleDataTypeExtension> getSimpleDataTypeExtensions() {
        return s_simpleDataTypeExtensions;
    }

    public static ISimpleDataTypeExtension getSimpleDataTypExtensionForClass(Class c) {
        for (ISimpleDataTypeExtension extension : s_simpleDataTypeExtensions) {
            if (!extension.checkIfClassIsSimpleDataType(c)) continue;
            return extension;
        }
        return null;
    }

    public static boolean checkIfdAsAutocompleteIdText(String value) {
        return value != null && value.startsWith("@@@@@@@@@@");
    }

    public static String encodeAutocompleteIdText(String id, String text) {
        return "@@@@@@@@@@" + id + "@@@@@@@@@@" + text;
    }

    public static String replaceNonBreakables(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace(' ', '\u00a0');
        return text;
    }

    public static List<String> decodeStringListXML(String s, boolean withError) {
        if (s == null) {
            return new ArrayList<String>();
        }
        try {
            SAXParser saxParser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(s));
            StringListParser slp = new StringListParser();
            saxParser.parse(is, (DefaultHandler)slp);
            return slp.i_result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Error when parsing string list: " + s, t);
            }
            return new ArrayList<String>();
        }
    }

    public static String encodeStringListXML(List<String> l) {
        StringBuffer result = new StringBuffer();
        result.append("<sl>");
        for (String s : l) {
            result.append("<s value=\"" + ValueManager.encodeIntoValidXMLString(s) + "\"/>");
        }
        result.append("</sl>");
        return result.toString();
    }

    public static Rectangle decodeRectangle(String value, Rectangle nullValue) {
        try {
            if (value == null) {
                return nullValue;
            }
            String[] values = ValueManager.decodeStraightCSV(value);
            Rectangle result = new Rectangle();
            result.x = ValueManager.decodeSize(values[0], 0);
            result.y = ValueManager.decodeSize(values[1], 0);
            result.width = !values[2].startsWith("-") ? ValueManager.decodeSize(values[2], 0) : -1 * ValueManager.decodeSize(values[2].substring(1), 0);
            result.height = !values[3].startsWith("-") ? ValueManager.decodeSize(values[3], 0) : -1 * ValueManager.decodeSize(values[3].substring(1), 0);
            return result;
        }
        catch (Throwable t) {
            return nullValue;
        }
    }

    public static String encodeRectangle(Rectangle value) {
        if (value == null) {
            return null;
        }
        return value.x + CHAR_SEMI + value.y + CHAR_SEMI + value.width + CHAR_SEMI + value.height;
    }

    public static String encodeRectangle(Rectangle value, boolean scaleToLoxels) {
        if (value == null) {
            return null;
        }
        if (scaleToLoxels) {
            return Scale.calculateSize(value.x) + CHAR_SEMI + Scale.calculateSize(value.y) + CHAR_SEMI + Scale.calculateSize(value.width) + CHAR_SEMI + Scale.calculateSize(value.height);
        }
        return ValueManager.encodeRectangle(value);
    }

    public static HotKeyInfo decodeHotKey(String value) {
        if (value == null) {
            return null;
        }
        HotKeyInfo result = new HotKeyInfo();
        if (value.indexOf("ctrl-") >= 0) {
            result.m_isControlDown = true;
        }
        if (value.indexOf("shift-") >= 0) {
            result.m_isShiftDown = true;
        }
        if (value.indexOf("alt-") >= 0) {
            result.m_isAltDown = true;
        }
        int index = value.lastIndexOf(45);
        result.m_keyCode = ValueManager.decodeInt(value.substring(index + 1), -1);
        return result;
    }

    public static String createHotKeyString(HotKeyInfo hotKeyInfo) {
        try {
            String s = ValueManager.buildTextForKeyCode(hotKeyInfo.m_keyCode);
            StringBuffer result = new StringBuffer();
            result.append("     (");
            if (hotKeyInfo.m_isControlDown) {
                result.append("ctrl-");
            }
            if (hotKeyInfo.m_isAltDown) {
                result.append("alt-");
            }
            if (hotKeyInfo.m_isShiftDown) {
                result.append("shift-");
            }
            result.append(s);
            result.append(")");
            return result.toString();
        }
        catch (Throwable t) {
            return "";
        }
    }

    private static String buildTextForKeyCode(int keyCode) {
        switch (keyCode) {
            case 10: {
                return "Return";
            }
            case 27: {
                return "ESC";
            }
            case 32: {
                return "Space";
            }
            case 33: {
                return "\u219f";
            }
            case 34: {
                return "\u21a1";
            }
            case 35: {
                return "End";
            }
            case 36: {
                return "Begin";
            }
            case 37: {
                return "\u2190";
            }
            case 38: {
                return "\u2191";
            }
            case 39: {
                return "\u2192";
            }
            case 40: {
                return "\u2193";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 127: {
                return "DEL";
            }
        }
        char c = (char)keyCode;
        return ValueManager.toLowerCaseText("" + c);
    }

    public static ImageData decodeImageName(String imageName, boolean isLeftToRight) {
        ImageData result = new ImageData();
        if (imageName == null) {
            return result;
        }
        int index = imageName.indexOf("&mirrorrtl");
        if (index >= 0) {
            result.mirrorWhenRtl = true;
            imageName = imageName.substring(0, index) + imageName.substring(index + 10);
            if (!isLeftToRight) {
                index = imageName.lastIndexOf(46);
                imageName = imageName.substring(0, index) + "_rtl" + imageName.substring(index);
            }
        }
        if ((index = imageName.indexOf("&noscale")) >= 0) {
            result.followScaling = false;
            imageName = imageName.substring(0, index) + imageName.substring(index + 8);
        }
        result.imageName = imageName;
        return result;
    }

    public static int decodeAlign(String value) {
        if (value == null) {
            return 2;
        }
        if (value.equals("left")) {
            return 2;
        }
        if (value.equals("right")) {
            return 4;
        }
        if (value.equals("center")) {
            return 0;
        }
        if (value.equals("leading")) {
            return 10;
        }
        if (value.equals("trailing")) {
            return 11;
        }
        return 10;
    }

    public static int decodeValign(String value) {
        if (value == null) {
            return 0;
        }
        if (value.equals("top")) {
            return 1;
        }
        if (value.equals("center")) {
            return 0;
        }
        if (value.equals("bottom")) {
            return 3;
        }
        return 0;
    }

    public static String[] decodeCSV(String value) {
        String[] result = ValueManager.tokenize(value, CHAR_SEMI);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].replace(CHARX_SEMI, CHAR_SEMI);
        }
        return result;
    }

    public static List<String> decodeCSVToList(String value) {
        return ValueManager.transferStringArrayToList(ValueManager.decodeCSV(value));
    }

    public static String[] decodeCSVOneLine(String value) {
        String[] result = ValueManager.tokenize(value, CHAR_SEMI);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].replace(CHARX_SEMI, CHAR_SEMI);
            result[i] = result[i].replace(CHARX_RETURN, "\n");
        }
        return result;
    }

    public static List<String> decodeCSVOneLineToList(String value) {
        return ValueManager.transferStringArrayToList(ValueManager.decodeCSVOneLine(value));
    }

    public static String[] decodeCSV(String value, String nullString) {
        String[] result = ValueManager.tokenize(value, CHAR_SEMI);
        for (int i = 0; i < result.length; ++i) {
            result[i] = nullString.equals(result[i]) ? null : result[i].replace(CHARX_SEMI, CHAR_SEMI);
        }
        return result;
    }

    public static List<String> decodeCSVToList(String value, String nullString) {
        return ValueManager.transferStringArrayToList(ValueManager.decodeCSV(value, nullString));
    }

    public static String[] decodeStraightCSV(String value) {
        return ValueManager.decodeCSV(value);
    }

    public static int[] decodeStraightIntCSV(String value) {
        String[] ss = ValueManager.decodeStraightCSV(value);
        int[] result = new int[ss.length];
        for (int i = 0; i < result.length; ++i) {
            int intValue = ValueManager.decodeInt(ss[i], 0);
            if (intValue == 0 && ss[i] != null && ss[i].contains(".")) {
                intValue = Math.round(ValueManager.decodeFloat(ss[i], 0.0f));
            }
            result[i] = intValue;
        }
        return result;
    }

    @Deprecated
    public static int[] decodeStraighIntCSV(String value) {
        return ValueManager.decodeStraightIntCSV(value);
    }

    public static int[] decodeStraightSizeCSV(String value) {
        String[] ss = ValueManager.decodeStraightCSV(value);
        int[] result = new int[ss.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ValueManager.decodeSize(ss[i]);
        }
        return result;
    }

    @Deprecated
    public static int[] decodeStraighSizeCSV(String value) {
        return ValueManager.decodeStraightSizeCSV(value);
    }

    public static String encodeCSV(String[] values) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            if (s == null) {
                s = "";
            }
            s = s.replace(CHAR_SEMI, CHARX_SEMI);
            if (i != 0) {
                result.append(CHAR_SEMI);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String encodeCSVOneLine(String[] values) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            if (s == null) {
                s = "";
            }
            s = s.replace(CHAR_SEMI, CHARX_SEMI);
            s = s.replace("\r", "");
            s = s.replace("\n", CHARX_RETURN);
            if (i != 0) {
                result.append(CHAR_SEMI);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String encodeCSVWithQuotes(List<String> values) {
        return ValueManager.encodeCSVWithQuotes(values, CHAR_SEMI);
    }

    public static String encodeCSVWithQuotes(List<String> values, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            String s = values.get(i);
            if (s == null) {
                s = "";
            }
            s = s.replace("\"", "\"\"");
            if (i != 0) {
                result.append(delimiter);
            }
            result.append("\"");
            result.append(s);
            result.append("\"");
        }
        return result.toString();
    }

    public static String encodeCSV(List<String> values) {
        return ValueManager.encodeCSV(values, "");
    }

    public static String encodeCSV(List<String> values, String nullString) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            String s = values.get(i);
            if (s == null) {
                s = nullString;
            }
            s = s.replace(CHAR_SEMI, CHARX_SEMI);
            if (i != 0) {
                result.append(CHAR_SEMI);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String encodeStraightIntCSV(int[] values) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                result.append(';');
            }
            result.append("" + values[i]);
        }
        return result.toString();
    }

    public static String encodeStraightSizeCSV(int[] values) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                result.append(';');
            }
            result.append(ValueManager.encodeSize(values[i]));
        }
        return result.toString();
    }

    public static boolean decodeBoolean(String value, boolean nullValue) {
        try {
            if (value == null) {
                return nullValue;
            }
            return new Boolean(value);
        }
        catch (Throwable t) {
            return nullValue;
        }
    }

    public static String encodeColor(Color c) {
        if (c == null) {
            return null;
        }
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static Color decodeColor(String colorCode) {
        return ValueManager.decodeColor(colorCode, false);
    }

    public static Color decodeColor(String colorCode, boolean withError) {
        if (colorCode == null) {
            return null;
        }
        try {
            int red = Integer.valueOf(colorCode.substring(1, 3), 16);
            int green = Integer.valueOf(colorCode.substring(3, 5), 16);
            int blue = Integer.valueOf(colorCode.substring(5, 7), 16);
            if (colorCode.length() == 7) {
                return new Color(red, green, blue);
            }
            int opa = Integer.valueOf(colorCode.substring(7, 9), 16);
            return new Color(red, green, blue, opa);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not translate color " + colorCode + ", " + t.toString(), t);
            }
            return null;
        }
    }

    public static String updateColor(String colorCodePM) {
        if (colorCodePM == null) {
            return null;
        }
        if (colorCodePM.endsWith("+")) {
            int index = colorCodePM.indexOf("+");
            return ValueManager.updateColor(colorCodePM.substring(0, index), colorCodePM.length() - index);
        }
        if (colorCodePM.endsWith("-")) {
            int index = colorCodePM.indexOf("-");
            return ValueManager.updateColor(colorCodePM.substring(0, index), -1 * (colorCodePM.length() - index));
        }
        return colorCodePM;
    }

    public static int countOccurrancesInString(String s, char c) {
        if (s == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }

    public static String updateColor(String colorCode, int factor) {
        try {
            Color c = ValueManager.decodeColor(colorCode);
            int maxRGB = Math.max(c.getRed(), c.getGreen());
            maxRGB = Math.max(maxRGB, c.getBlue());
            int maxIncrease = factor * 16;
            int newRed = c.getRed() + (int)((float)maxIncrease * ((float)c.getRed() / (float)maxRGB));
            int newGreen = c.getGreen() + (int)((float)maxIncrease * ((float)c.getGreen() / (float)maxRGB));
            int newBlue = c.getBlue() + (int)((float)maxIncrease * ((float)c.getBlue() / (float)maxRGB));
            if (newRed < 0) {
                newRed = 0;
            }
            if (newGreen < 0) {
                newGreen = 0;
            }
            if (newBlue < 0) {
                newBlue = 0;
            }
            if (newRed > 255) {
                newRed = 255;
            }
            if (newGreen > 255) {
                newGreen = 255;
            }
            if (newBlue > 255) {
                newBlue = 255;
            }
            Color result = new Color(newRed, newGreen, newBlue);
            if (colorCode.length() != 9) {
                return ValueManager.encodeColor(result);
            }
            return ValueManager.encodeColor(result) + colorCode.substring(7);
        }
        catch (Throwable t) {
            return colorCode;
        }
    }

    public static Color decodeColor(String colorCode, String nullValue) {
        if (colorCode == null) {
            colorCode = nullValue;
        }
        return ValueManager.decodeColor(colorCode, false);
    }

    public static int decodeSize(String value) {
        try {
            int index = value.indexOf(59);
            if (index >= 0) {
                value = value.substring(0, index);
            }
            if (value.endsWith("+")) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.endsWith("%")) {
                return -1 * new Integer(value.substring(0, value.length() - 1));
            }
            int result = new Integer(value);
            result = Scale.calculateScaledSize(result);
            return result;
        }
        catch (RuntimeException rex) {
            rex.printStackTrace();
            return 100;
        }
    }

    public static int decodeMinSize(String value) {
        if (value == null) {
            return -1;
        }
        int index1 = value.indexOf(59);
        if (index1 < 0) {
            return -1;
        }
        int index2 = value.indexOf(59, index1 + 1);
        if ((value = index2 < 0 ? value.substring(index1 + 1) : value.substring(index1 + 1, index2)).length() == 0) {
            return -1;
        }
        try {
            int result = new Integer(value);
            result = Scale.calculateScaledSize(result);
            return result;
        }
        catch (Throwable t) {
            ULog.logINF("Problem decoding minimum size from String: " + value + ". Returning -1 default value.");
            return -1;
        }
    }

    public static String encodeSize(int value) {
        if (value < 0 && value != Integer.MIN_VALUE) {
            return (value *= -1) + "%";
        }
        return value + "";
    }

    public static int calculateScaledSize(int pixelSize) {
        return Scale.calculateSize(pixelSize);
    }

    public static int decodeSize(String value, int nullValue) {
        if (value == null) {
            return nullValue;
        }
        return ValueManager.decodeSize(value);
    }

    public static boolean checkIfSizeIsHintOnly(String value) {
        if (value == null) {
            return false;
        }
        return value.endsWith("+");
    }

    public static Map<String, String> decodeComplexValue(String value) {
        return ValueManager.decodeComplexValue(value, false);
    }

    public static Map<String, String> decodeComplexValue(String value, boolean withTrimming) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (value == null) {
            return result;
        }
        String[] nameValues = ValueManager.decodeCSV(value);
        for (int i = 0; i < nameValues.length; ++i) {
            if (nameValues[i].length() == 0) continue;
            try {
                int index = nameValues[i].indexOf(58);
                if (index < 0) continue;
                String n = nameValues[i].substring(0, index);
                String v = nameValues[i].substring(index + 1);
                if (withTrimming) {
                    n = n.trim();
                    v = v.trim();
                }
                result.put(n, v);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static List<NameValue> decodeComplexValueIntoList(String value) {
        ArrayList<NameValue> result = new ArrayList<NameValue>();
        if (value == null) {
            return result;
        }
        String[] nameValues = ValueManager.decodeCSV(value);
        for (int i = 0; i < nameValues.length; ++i) {
            if (nameValues[i].length() == 0) continue;
            try {
                int index = nameValues[i].indexOf(58);
                if (index >= 0) {
                    result.add(new NameValue(nameValues[i].substring(0, index), nameValues[i].substring(index + 1)));
                    continue;
                }
                result.add(new NameValue(nameValues[i], null));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static String encodeComplexValue(List<NameValue> nameValueList) {
        return ValueManager.encodeComplexValue(nameValueList, false);
    }

    public static String encodeComplexValue(List<NameValue> nameValueList, boolean ignoreNullValues) {
        ArrayList<String> csvValues = new ArrayList<String>();
        for (NameValue nameValue : nameValueList) {
            String key = nameValue.name;
            String value = nameValue.value;
            if (value == null) {
                if (ignoreNullValues) continue;
                value = "";
            }
            csvValues.add(key + ":" + value);
        }
        return ValueManager.encodeCSV(csvValues);
    }

    public static String encodeComplexValue(String ... nameValues) {
        if (nameValues == null) {
            return null;
        }
        if (nameValues.length % 2 != 0) {
            throw new Error("Wrong number of parameters: always name - value - pairs have to be passed.");
        }
        ArrayList<NameValue> nvs = new ArrayList<NameValue>();
        for (int i = 0; i < nameValues.length; i += 2) {
            nvs.add(new NameValue(nameValues[i], nameValues[i + 1]));
        }
        return ValueManager.encodeComplexValue(nvs);
    }

    public static String encodeComplexValue(Map<String, ?> values) {
        return ValueManager.encodeComplexValue(values, false);
    }

    public static String encodeComplexValue(Map<String, ?> values, boolean ignoreNullValues) {
        ArrayList<String> nameValues = new ArrayList<String>();
        for (String key : values.keySet()) {
            Object value = values.get(key);
            if (value == null) {
                if (ignoreNullValues) continue;
                value = "";
            }
            nameValues.add(key + ":" + value);
        }
        return ValueManager.encodeCSV(nameValues);
    }

    public static void initialize() {
        try {
            JTextField tf = new JTextField();
            s_defaultFont = tf.getFont();
            s_defaultScaledFont = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Font getDefaultFont() {
        return s_defaultFont;
    }

    public static Font getDefaultScaledFont() {
        if (s_defaultScaledFont == null) {
            s_defaultScaledFont = ValueManager.decodeFont("");
        }
        return s_defaultScaledFont;
    }

    public static Font decodeFont(String value) {
        try {
            int sizeInt;
            Map<String, String> map = ValueManager.decodeComplexValue(value);
            String family = map.get("family");
            String size = map.get("size");
            String weight = map.get("weight");
            String posture = map.get("posture");
            HashMap<TextAttribute, Object> fontMap = new HashMap<TextAttribute, Object>();
            if (family != null) {
                fontMap.put(TextAttribute.FAMILY, family);
            }
            if (size != null && (sizeInt = ValueManager.decodeInt(size, 0)) > 0) {
                fontMap.put(TextAttribute.SIZE, new Integer(sizeInt));
            }
            if ("bold".equals(weight)) {
                fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if ("italic".equals(posture)) {
                fontMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if ("oblique".equals(posture)) {
                fontMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            Font result = s_defaultFont.deriveFont(fontMap);
            result = Scale.calculateScaledFont(result);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Padding decodePadding(String value) {
        Padding result = new Padding();
        if (value.indexOf(58) < 0) {
            int pad = ValueManager.decodeInt(value, 0);
            result.setBottom(pad);
            result.setTop(pad);
            result.setLeft(pad);
            result.setRight(pad);
        } else {
            Map<String, String> map = ValueManager.decodeComplexValue(value);
            result.setBottom(ValueManager.decodeInt(map.get("bottom"), 0));
            result.setTop(ValueManager.decodeInt(map.get("top"), 0));
            result.setLeft(ValueManager.decodeInt(map.get("left"), 0));
            result.setRight(ValueManager.decodeInt(map.get("right"), 0));
        }
        return result;
    }

    public static int decodeInt(String value, int nullValue) {
        if (value == null) {
            return nullValue;
        }
        try {
            int result = new Integer(value);
            return result;
        }
        catch (Throwable t) {
            return nullValue;
        }
    }

    public static int decodeIntWithRounding(String value, int nullValue) {
        if (value == null) {
            return nullValue;
        }
        try {
            int resultInt = new Integer(value);
            return resultInt;
        }
        catch (Throwable t) {
            try {
                double resultDouble = new Double(value);
                return (int)Math.round(resultDouble);
            }
            catch (Throwable throwable) {
                return nullValue;
            }
        }
    }

    public static float decodeFloat(String value, float nullValue) {
        if (value == null) {
            return nullValue;
        }
        try {
            float result = new Float(value).floatValue();
            return result;
        }
        catch (Throwable t) {
            return nullValue;
        }
    }

    public static double decodeDouble(String value, double nullValue) {
        if (value == null) {
            return nullValue;
        }
        try {
            double result = new Double(value);
            return result;
        }
        catch (Throwable t) {
            return nullValue;
        }
    }

    public static long decodeLong(String value, long nullValue) {
        if (value == null) {
            return nullValue;
        }
        try {
            long result = new Long(value);
            return result;
        }
        catch (Throwable t) {
            return nullValue;
        }
    }

    public static long decodeLongWithRounding(String value, long nullValue) {
        if (value == null) {
            return nullValue;
        }
        try {
            long resultLong = new Long(value);
            return resultLong;
        }
        catch (Throwable t) {
            try {
                double resultDouble = new Double(value);
                return Math.round(resultDouble);
            }
            catch (Throwable throwable) {
                return nullValue;
            }
        }
    }

    public static String[] decodeMethodParams(String value) {
        int index1 = value.indexOf(40);
        int index2 = value.lastIndexOf(41);
        if (index1 < 0 || index2 < 0 || index1 > index2) {
            return new String[0];
        }
        String between = value.substring(index1 + 1, index2);
        if (between.length() == 0) {
            return new String[0];
        }
        String[] result = ValueManager.tokenize(between, CHAR_COMMA);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].replace(CHARX_COMMA, CHAR_COMMA);
            result[i] = result[i].replace(CHARX_BRACKETOPEN, "(");
            result[i] = result[i].replace(CHARX_BRACKETCLOSE, ")");
        }
        return result;
    }

    public static String encodeMethod(String methodName, String[] params) {
        StringBuffer result = new StringBuffer();
        result.append(methodName + "(");
        result.append(ValueManager.encodeMethodParamsArray(params));
        result.append(")");
        return result.toString();
    }

    public static String encodeMethodParams(List<String> params) {
        if (params == null) {
            return "";
        }
        if (params.size() == 0) {
            return "";
        }
        String[] paramsArray = new String[params.size()];
        params.toArray(paramsArray);
        return ValueManager.encodeMethodParamsArray(paramsArray);
    }

    public static String encodeMethodParamsArray(String[] params) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            String s;
            if (i != 0) {
                result.append(CHAR_COMMA);
            }
            if ((s = params[i]) == null) {
                s = "";
            }
            s = s.replace(CHAR_COMMA, CHARX_COMMA);
            s = s.replace("(", CHARX_BRACKETOPEN);
            s = s.replace(")", CHARX_BRACKETCLOSE);
            result.append(s);
        }
        return result.toString();
    }

    public static String[] tokenize(String inputs, String separator) {
        if (inputs.length() == 0) {
            return new String[0];
        }
        Vector<String> resultVector = new Vector<String>();
        int separatorLength = separator.length();
        int nextSubStringStartIndex = 0;
        int nextIndex = inputs.indexOf(separator);
        String s = "";
        while (nextIndex >= 0) {
            s = s + inputs.substring(nextSubStringStartIndex, nextIndex);
            resultVector.addElement(s);
            s = "";
            nextSubStringStartIndex = nextIndex + separatorLength;
            nextIndex = inputs.indexOf(separator, nextIndex + separatorLength);
        }
        resultVector.addElement(s + inputs.substring(nextSubStringStartIndex, inputs.length()));
        Object[] result = new String[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    public static String[] tokenizeStringWithQuotes(String inputs, char separator) {
        if (inputs == null) {
            return new String[0];
        }
        if (inputs.length() == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentToken = new StringBuffer();
        boolean waitingForSecondQuote = false;
        boolean currentTokenIsEmptyButValid = false;
        for (int i = 0; i < inputs.length(); ++i) {
            char c = inputs.charAt(i);
            if (c == separator && !waitingForSecondQuote) {
                if (currentToken.length() <= 0 && !currentTokenIsEmptyButValid) continue;
                result.add(currentToken.toString());
                currentToken = new StringBuffer();
                currentTokenIsEmptyButValid = false;
                continue;
            }
            if (c == '\\') {
                boolean charAfterIsQuote = false;
                if (i < inputs.length() - 1 && inputs.charAt(i + 1) == '\'') {
                    charAfterIsQuote = true;
                }
                if (charAfterIsQuote) continue;
                currentToken.append(c);
                continue;
            }
            if (c == '\'') {
                boolean charBeforeIsBackslash = false;
                if (i > 0 && inputs.charAt(i - 1) == '\\') {
                    charBeforeIsBackslash = true;
                }
                if (!charBeforeIsBackslash) {
                    boolean bl = waitingForSecondQuote = !waitingForSecondQuote;
                    if (waitingForSecondQuote) continue;
                    currentTokenIsEmptyButValid = true;
                    continue;
                }
                currentToken.append(c);
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0 || currentTokenIsEmptyButValid) {
            result.add(currentToken.toString());
        }
        String[] resultArray = new String[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static String decodeMethodName(String value) {
        int index = value.indexOf(40);
        if (index < 0) {
            return null;
        }
        return value.substring(0, index);
    }

    public static String escapeXMLString(String s) {
        return ValueManager.translateString(s, escapeXMLStringFroms, escapeXMLStringTos);
    }

    public static String encodeIntoValidXMLString(String s) {
        return ValueManager.translateString(s, encodeIntoValidXMLStringFroms, encodeIntoValidXMLStringTos);
    }

    public static String encodeIntoEscapedString(String s) {
        return ValueManager.encodeIntoValidXMLString(s);
    }

    public static String encodeIntoValidXMLValueString(String s) {
        return ValueManager.translateString(s, encodeIntoValidXMLValueStringFroms, encodeIntoValidXMLValueStringTos);
    }

    public static String encodeIntoEscapedValueString(String s) {
        return ValueManager.encodeIntoValidXMLValueString(s);
    }

    public static String decodeFromXML(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(38) < 0) {
            return s;
        }
        s = s.replace("&amp;", "&");
        s = s.replace("&lt;", "<");
        s = s.replace("&gt;", ">");
        s = s.replace("&quot;", "\"");
        s = s.replace("&apos;", "'");
        s = s.replace("&#34;", "\"");
        s = s.replace("&#39;", "'");
        s = s.replace("&#92;", "\\");
        return s;
    }

    public static String encodeIntoEscapedJavaString(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\b", "\\b").replace("\f", "\\f");
    }

    public static String encodeIntoValidDirectoryName(String s) {
        return ValueManager.encodeIntoValidFileName(s, true);
    }

    public static String encodeIntoValidFileName(String s) {
        return ValueManager.encodeIntoValidFileName(s, false);
    }

    public static String encodeIntoValidFileName(String s, boolean isDirectory) {
        if (s == null) {
            return null;
        }
        if ((s = s.replace('\\', '/')).length() > 1) {
            String first = s.substring(0, 1);
            String second = s.substring(1);
            while (second.indexOf("//") >= 0) {
                second = second.replace("//", "/");
            }
            s = first + second;
        }
        if (isDirectory && !s.endsWith("/")) {
            s = s + '/';
        }
        return s;
    }

    public static String encodeIntoValidStreamStorePath(String s, boolean isDirectory) {
        if (s == null) {
            return null;
        }
        if (!(s = ValueManager.encodeIntoValidFileName(s, isDirectory)).startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    public static String encodeIntoValidURL(String s) {
        if (s == null) {
            return null;
        }
        s = s.replace('\\', '/');
        String protocol = "";
        int startIndex = s.indexOf("://");
        if (startIndex >= 0) {
            protocol = s.substring(0, startIndex + 3);
            s = s.substring(startIndex + 3);
        }
        while (s.indexOf("//") >= 0) {
            s = s.replace("//", "/");
        }
        s = protocol + s;
        return s;
    }

    public static String encodeIntoValidWebResourcePath(String s, boolean isDirectory) {
        if (s == null) {
            return null;
        }
        s = s.replace('\\', '/');
        while (s.indexOf("//") >= 0) {
            s = s.replace("//", "/");
        }
        if (isDirectory && !s.endsWith("/")) {
            s = s + '/';
        }
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    public static String encodeIntoValidClassLoaderPath(String s, boolean isDirectory) {
        if (s == null) {
            return null;
        }
        s = s.replace('\\', '/');
        while (s.indexOf("//") >= 0) {
            s = s.replace("//", "/");
        }
        if (isDirectory && !s.endsWith("/")) {
            s = s + '/';
        }
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public static String getStackstraceString(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter swriter = new StringWriter();
        PrintWriter pw = new PrintWriter(swriter);
        t.printStackTrace(pw);
        String result = swriter.toString();
        return result;
    }

    public static byte decodeHexChars(char c16, char c1) {
        int he = Integer.parseInt("" + c16 + c1, 16);
        return (byte)he;
    }

    public static byte[] decodeHexString(String s) {
        return ValueManager.decodeHexString(s, false);
    }

    public static byte[] decodeHexString(String s, boolean withError) {
        try {
            if (s == null) {
                return null;
            }
            int length = s.length();
            byte[] result = new byte[length / 2];
            int counter = 0;
            for (int i = 0; i < length; i += 2) {
                char ci = s.charAt(i);
                char ci1 = s.charAt(i + 1);
                int he = Integer.parseInt("" + ci + ci1, 16);
                result[counter] = (byte)he;
                ++counter;
            }
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem when parsing hex-string", t);
            }
            ULog.logINF("Problem when parsing hex string");
            return null;
        }
    }

    public static String encodeHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (int i = 0; i < bytes.length; ++i) {
                int v = bytes[i] & 0xFF;
                bos.write(HEXIS[v >> 4]);
                bos.write(HEXIS[v & 0xF]);
            }
            bos.close();
            return bos.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Calendar getCalendar(String timezone) {
        if (timezone == null) {
            return Calendar.getInstance();
        }
        TimeZone tz = TimeZone.getTimeZone(timezone);
        return Calendar.getInstance(tz);
    }

    public static String decodePropertyName(String methodName) {
        String result;
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("is")) {
            result = methodName.substring(2);
        } else if (methodName.startsWith("get")) {
            result = methodName.substring(3);
        } else {
            return null;
        }
        if (result.length() == 0) {
            return null;
        }
        if (result.length() == 1) {
            return ValueManager.toLowerCaseId(result);
        }
        char second = result.charAt(1);
        if (Character.isUpperCase(second)) {
            return result;
        }
        return ValueManager.toLowerCaseId(result.substring(0, 1)) + result.substring(1);
    }

    public static boolean checkIfObjectsAreEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean checkIfStringContainsTokenizedSearchString(String s, String searchString) {
        if (s == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(searchString, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (ValueManager.checkIfStringContainsSearchString(s, token)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfStringContainsSearchString(String s, String searchString) {
        if (s == null) {
            return false;
        }
        if (searchString == null) {
            return false;
        }
        s = ValueManager.toLowerCaseId(s);
        searchString = ValueManager.toLowerCaseId(searchString);
        return s.contains(searchString);
    }

    public static boolean checkIfFileNamesAreEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        File f1 = new File(s1);
        File f2 = new File(s2);
        String fs1 = null;
        String fs2 = null;
        try {
            fs1 = f1.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fs2 = f2.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ValueManager.checkIfStringsAreEqual(fs1, fs2);
    }

    public static boolean checkIfStringsAreEqual(String s1, String s2) {
        return ValueManager.checkIfStringsAreEqual(s1, s2, false);
    }

    public static boolean checkIfStringsAreEqual(String s1, String s2, boolean ignoreSlashR) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        if (s2 == null) {
            return false;
        }
        if (ignoreSlashR) {
            s1 = s1.replace("\r", "");
            s2 = s2.replace("\r", "");
        }
        return s1.equals(s2);
    }

    public static boolean isNotEmpty(String s) {
        return !ValueManager.isEmpty(s);
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static boolean checkIfStringMatchesRegularExpression(String value, String regularExpression) {
        if (value == null) {
            return true;
        }
        if (value.equals("")) {
            return true;
        }
        if (regularExpression == null) {
            return true;
        }
        try {
            Pattern pattern = Pattern.compile(regularExpression);
            Matcher matcher = pattern.matcher(value);
            if (matcher.find()) {
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                if (startIndex == 0 && endIndex == value.length()) {
                    return true;
                }
            }
            return false;
        }
        catch (PatternSyntaxException pse) {
            return true;
        }
    }

    public static boolean checkIfStringMatchesAsteriskExpression(String value, String asterixExpression) {
        return ValueManager.checkIfStringMatchesAsteriskExpression(value, asterixExpression, false);
    }

    public static boolean checkIfStringMatchesAsteriskExpression(String value, String asterixExpression, boolean ignoreCase) {
        if (value == null) {
            return true;
        }
        if (value.equals("")) {
            return true;
        }
        if (asterixExpression == null) {
            return true;
        }
        if (asterixExpression.equals("")) {
            return true;
        }
        if (ignoreCase) {
            value = ValueManager.toLowerCaseId(value);
            asterixExpression = ValueManager.toLowerCaseId(asterixExpression);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < asterixExpression.length(); ++i) {
            char c = asterixExpression.charAt(i);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            sb.append("[" + c + "]{1}");
        }
        String regex = sb.toString();
        return ValueManager.checkIfStringMatchesRegularExpression(value, regex);
    }

    public static boolean checkIfStringMatchesSearchStringAND(String s, String searchString) {
        return ValueManager.checkIfStringMatchesSearchStringAND(s, searchString, false);
    }

    public static boolean checkIfStringMatchesSearchStringAND(String s, String searchString, boolean caseSensitive) {
        if (s == null) {
            return false;
        }
        if (searchString == null) {
            return true;
        }
        if ((searchString = ValueManager.updateStringOnlyOneSpace(searchString)).length() == 0) {
            return true;
        }
        if (!caseSensitive) {
            searchString = ValueManager.toLowerCaseText(searchString);
            s = ValueManager.toLowerCaseText(s);
        }
        StringTokenizer st = new StringTokenizer(searchString);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (ValueManager.checkIfStringMatchesSearchToken(s, token = ValueManager.toLowerCaseId(token))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfStringMatchesSearchStringOR(String s, String searchString) {
        if (s == null) {
            return false;
        }
        if (searchString == null) {
            return true;
        }
        if ((searchString = ValueManager.updateStringOnlyOneSpace(searchString)).length() == 0) {
            return true;
        }
        s = ValueManager.toLowerCaseId(s);
        StringTokenizer st = new StringTokenizer(searchString);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!ValueManager.checkIfStringMatchesSearchToken(s, token = ValueManager.toLowerCaseId(token))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIfStringMatchesSearchToken(String s, String token) {
        if (!token.startsWith("=")) {
            return s.contains(token);
        }
        return s.equals(token.substring(1));
    }

    private static String updateStringOnlyOneSpace(String s) {
        s = s.trim();
        while (s.contains("  ")) {
            s = s.replace("  ", " ");
        }
        return s;
    }

    public static boolean checkIfSimpleDataType(Class c) {
        if (c == String.class || c == Boolean.class || c == Boolean.TYPE || c == Byte.class || c == Byte.TYPE || c == Integer.class || c == Integer.TYPE || c == Short.class || c == Short.TYPE || c == Long.class || c == Long.TYPE || c == Float.class || c == Float.TYPE || c == Double.class || c == Double.TYPE || c == Character.class || c == Character.TYPE || c == java.util.Date.class || c == BigDecimal.class || c == BigInteger.class || c == LocalDate.class || c == LocalDateTime.class || c == LocalTime.class || c == Date.class || c == Timestamp.class || c == Time.class || c.isEnum() || "java.util.UUID".equals(c.getName()) || java.util.Date.class.isAssignableFrom(c)) {
            return true;
        }
        if (c.isArray()) {
            Class<?> contentClass = c.getComponentType();
            return contentClass == Byte.TYPE;
        }
        ISimpleDataTypeExtension extension = ValueManager.getSimpleDataTypExtensionForClass(c);
        return extension != null;
    }

    public static Object convertNullValueIntoPropertyValue(Class attrClass) {
        if (attrClass == Boolean.TYPE) {
            return new Boolean(false);
        }
        if (attrClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (attrClass == Long.TYPE) {
            return new Long(0L);
        }
        if (attrClass == Short.TYPE) {
            return new Short(0);
        }
        if (attrClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (attrClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (attrClass == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object convertStringIntoObject(String attrValue, Class attrClass) {
        block33: {
            if (attrClass == String.class) {
                return attrValue;
            }
            if (attrValue == null || attrValue.equals("")) {
                return ValueManager.convertNullValueIntoPropertyValue(attrClass);
            }
            if (attrClass == Boolean.class || attrClass == Boolean.TYPE) {
                return new Boolean(attrValue);
            }
            if (attrClass == Date.class) {
                return new Date(new Long(attrValue));
            }
            if (attrClass == Timestamp.class) {
                return new Timestamp(new Long(attrValue));
            }
            if (attrClass == Time.class) {
                return new Time(new Long(attrValue));
            }
            if (!java.util.Date.class.isAssignableFrom(attrClass)) ** GOTO lbl33
            dateResult = new java.util.Date(new Long(attrValue));
            if (attrClass != java.util.Date.class) break block33;
            return dateResult;
            {
                catch (Throwable t) {
                    ULog.logINF("Error when converting value string to object " + attrValue + "/" + attrClass.getName(), t);
                    return null;
                }
            }
        }
        try {
            extDateResult = (java.util.Date)attrClass.newInstance();
            extDateResult.setTime(dateResult.getTime());
            return extDateResult;
        }
        catch (Throwable t1) {
            try {
                c = attrClass.getConstructor(new Class[]{Long.TYPE});
                return (java.util.Date)c.newInstance(new Object[]{dateResult.getTime()});
            }
            catch (Throwable t2) {
                throw new Error("Could not create data extension class: " + attrClass.getName(), t1);
            }
lbl33:
            // 1 sources

            if (attrClass == Integer.class || attrClass == Integer.TYPE) {
                return ValueManager.decodeIntegerObject(attrValue);
            }
            if (attrClass == Long.class || attrClass == Long.TYPE) {
                return ValueManager.decodeLongObject(attrValue);
            }
            if (attrClass == Short.class || attrClass == Short.TYPE) {
                return new Short(attrValue);
            }
            if (attrClass == Float.class || attrClass == Float.TYPE) {
                result = new Float(attrValue);
                if (result.floatValue() != Infinityf && result.floatValue() != -Infinityf) {
                    return result;
                }
                throw new Error("Cannot convert to float - reached infinity: " + attrValue);
            }
            if (attrClass == Double.class || attrClass == Double.TYPE) {
                result = new Double(attrValue);
                if (result != Infinity && result != -Infinity) {
                    return new Double(attrValue);
                }
                throw new Error("Cannot convert to double - reached infinity: " + attrValue);
            }
            if (attrClass == BigDecimal.class) {
                return new BigDecimal(attrValue);
            }
            if (attrClass == BigInteger.class) {
                return new BigInteger(attrValue);
            }
            if (attrClass == Character.class || attrClass == Character.TYPE) {
                if (attrValue.length() == 0) {
                    return new Character('\u0000');
                }
                return new Character(attrValue.charAt(0));
            }
            if (attrClass.isEnum()) {
                return ValueManager.convertStringIntoEnum(attrValue, attrClass);
            }
            try {
                o = LocalDate18Manager.convertStringIntoObject(attrValue, attrClass);
                if (o != null) {
                    return o;
                }
            }
            catch (Throwable o) {
                // empty catch block
            }
            try {
                o = UUID17Manager.convertStringIntoObject(attrValue, attrClass);
                if (o != null) {
                    return o;
                }
            }
            catch (Throwable tt) {
                throw new Error("Cannot convert value to UUID: " + attrValue);
            }
            xo = ValueManager.s_infoProvider.convertStringIntoExtendedObject(attrValue, attrClass);
            if (xo != null) {
                return xo;
            }
            extension = ValueManager.getSimpleDataTypExtensionForClass(attrClass);
            if (extension != null) {
                return extension.convertStringIntoSimpleDataTypeObject(attrValue, attrClass);
            }
            throw new Exception("Problem converting String: " + attrValue + ", " + attrClass.getName());
        }
    }

    public static Object convertStringIntoEnum(String attrValue, Class attrClass) {
        return ValueManager.convertStringIntoEnum(attrValue, attrClass, false);
    }

    public static Object convertStringIntoEnum(String attrValue, Class attrClass, boolean withError) {
        try {
            T[] os;
            for (Object o : os = attrClass.getEnumConstants()) {
                if (!o.toString().equals(attrValue)) continue;
                return o;
            }
            throw new Exception("Enum constant does not exsit for value: " + attrValue);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Error when converting value string to Enumeration " + attrValue + "/" + attrClass.getName() + ", " + t.toString(), t);
            }
            return attrValue;
        }
    }

    public static String convertObject2DisplayString(Object value) {
        if (value == null) {
            return "";
        }
        String format = null;
        String formatmask = null;
        String timezone = TimeZone.getDefault().getID();
        if (ValueManager.checkIfObjectIsNumber(value)) {
            format = "bigdecimal";
            formatmask = "decmax10";
        } else if (ValueManager.checkIfObjectIsDate(value)) {
            format = "date";
        } else if (ValueManager.checkIfObjectIsTime(value)) {
            format = "time";
        } else if (ValueManager.checkIfObjectIsDateTime(value)) {
            format = "datetime";
        }
        return ValueManager.convertObject2DisplayString(value, format, formatmask, timezone, false);
    }

    public static String convertObject2DisplayString(Object value, String format, String formatmask, String timezone, boolean convertHTML) {
        return ValueManager.convertObject2DisplayString(value, format, formatmask, timezone, convertHTML, false);
    }

    public static String convertObject2DisplayString(Object value, String format, String formatmask, String timezone, boolean convertHTML, boolean export) {
        return ValueManager.convertObject2DisplayString(value, format, formatmask, timezone, s_infoProvider.getCurrentLocale(), convertHTML, export);
    }

    public static String convertObject2ClientDisplayString(Object value, String format, String formatmask, String timezone, boolean convertHTML, boolean export) {
        return ValueManager.convertObject2DisplayString(value, format, formatmask, timezone, s_infoProvider.getCurrentLocaleClient(), convertHTML, export);
    }

    public static String convertObject2DisplayString(Object value, String format, String formatmask, String timezone, Locale l, boolean convertHTML, boolean export) {
        if (value == null) {
            return "";
        }
        String result = ValueManager.convertObject2ValueString(value);
        try {
            String language = null;
            String country = null;
            try {
                if (l == null) {
                    l = s_infoProvider.getCurrentLocale();
                }
                language = l.getLanguage();
                country = l.getCountry();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                boolean ld = LocalDate18Manager.checkIfObjectIsLocalDateObject(value);
                if (ld) {
                    timezone = "UTC";
                    value = LocalDate18Manager.convertLocalDateObjectToDate(value, timezone);
                }
            }
            catch (Throwable ld) {
                // empty catch block
            }
            Format f = ValueManager.findFormatter(value, format, formatmask, timezone, language, country);
            if (f != null) {
                if (value instanceof String && format != null && ValueManager.checkIfFormatIsNumeric(format)) {
                    try {
                        value = new BigDecimal((String)value);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                result = f.format(value);
            }
            if ("boolean".equals(format)) {
                if (Boolean.TRUE.equals(value) || "true".equals(value)) {
                    if (!export) {
                        return s_infoProvider.getValueManagerTrueString();
                    }
                    return s_infoProvider.getValueManagerTrueStringExport();
                }
                if (Boolean.FALSE.equals(value) || "false".equals(value)) {
                    if (!export) {
                        return s_infoProvider.getValueManagerFalseString();
                    }
                    return s_infoProvider.getValueManagerFalseStringExport();
                }
            }
            if ("string".equals(format) && "html2plain".equals(formatmask)) {
                return ValueManager.removeAllHtmlTags(result);
            }
        }
        catch (Throwable t) {
            ULog.logINF("Problem when converting object into value string, format: " + format + ", formatmask: " + formatmask + ", timezone: " + timezone + ", value class: " + value.getClass() + ", " + t.toString());
        }
        result = ValueManager.removeAllHtmlTagsIfHtmlString(result);
        return result;
    }

    public static String convertObject2ValueString(Object o) {
        String result4;
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        if (o instanceof Float) {
            double d = ((Float)o).doubleValue();
            String result2 = o.toString();
            if (result2.contains("E")) {
                result2 = new BigDecimal(d).toPlainString();
            }
            return result2;
        }
        if (o instanceof Double) {
            String result3 = o.toString();
            if (result3.contains("E")) {
                result3 = new BigDecimal((Double)o).toPlainString();
            }
            return result3;
        }
        if (o instanceof java.util.Date) {
            return ((java.util.Date)o).getTime() + "";
        }
        if (o instanceof Character) {
            if (((Character)o).charValue() == '\u0000') {
                return "";
            }
            return o.toString();
        }
        try {
            result4 = UUID17Manager.convertObject2ValueString(o);
            if (result4 != null) {
                return result4;
            }
        }
        catch (Throwable result4) {
            // empty catch block
        }
        try {
            result4 = LocalDate18Manager.convertObject2ValueString(o);
            if (result4 != null) {
                return result4;
            }
        }
        catch (Throwable result5) {
            // empty catch block
        }
        ISimpleDataTypeExtension extension = ValueManager.getSimpleDataTypExtensionForClass(o.getClass());
        if (extension != null) {
            return extension.convertSimpleDataTypeObjectIntoString(o);
        }
        try {
            String result6 = o.toString();
            if (result6 == null) {
                result6 = "";
            }
            return result6;
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static Class getPreferredClassForFieldFormat(String format, String timezone) {
        return ValueManager.getPreferredClassForFieldFormat(format, timezone, false);
    }

    public static Class getPreferredClassForFieldFormat(String format, String timezone, boolean returnNullIfUnknown) {
        if (format == null) {
            if (returnNullIfUnknown) {
                return null;
            }
            return String.class;
        }
        if (format.equals("short")) {
            return Short.class;
        }
        if (format.equals("int")) {
            return Integer.class;
        }
        if (format.equals("long")) {
            return Long.class;
        }
        if (format.equals("biginteger")) {
            return BigInteger.class;
        }
        if (format.equals("float")) {
            return Float.class;
        }
        if (format.equals("double")) {
            return Double.class;
        }
        if (format.equals("bigdecimal")) {
            return BigDecimal.class;
        }
        if (format.equals("boolean")) {
            return Boolean.class;
        }
        if (format.equals("color")) {
            return String.class;
        }
        if (!"LOCAL".equals(timezone)) {
            if (format.equals("date")) {
                return java.util.Date.class;
            }
            if (format.equals("time")) {
                return java.util.Date.class;
            }
            if (format.equals("datetime")) {
                return java.util.Date.class;
            }
        } else {
            if (format.equals("date")) {
                return LocalDate.class;
            }
            if (format.equals("time")) {
                return LocalTime.class;
            }
            if (format.equals("datetime")) {
                return LocalDateTime.class;
            }
        }
        if (returnNullIfUnknown) {
            return null;
        }
        return String.class;
    }

    public static BigDecimal rightScale(BigDecimal value, int numberOfFractionDigits) {
        if (value == null) {
            return null;
        }
        if (numberOfFractionDigits >= 0) {
            value = value.setScale(numberOfFractionDigits, 4);
        }
        return value;
    }

    public static TextSelectionInfo decodeTextSelectionInfo(String s) {
        if (s == null) {
            return null;
        }
        String[] values = ValueManager.decodeCSV(s);
        if (values.length < 3) {
            return null;
        }
        int v0 = ValueManager.decodeInt(values[0], 0);
        int v1 = ValueManager.decodeInt(values[1], 0);
        int v2 = ValueManager.decodeInt(values[2], 0);
        if (values.length <= 3) {
            return new TextSelectionInfo(v0, v1, v2);
        }
        int v3 = ValueManager.decodeInt(values[3], 0);
        int v4 = ValueManager.decodeInt(values[4], 0);
        int v5 = ValueManager.decodeInt(values[5], 0);
        return new TextSelectionInfo(v0, v1, v2, v3, v4, v5);
    }

    public static String encodeTextSelectionInfo(TextSelectionInfo value) {
        if (value == null) {
            return null;
        }
        return value.getCaretPosition() + CHAR_SEMI + value.getSelectionStart() + CHAR_SEMI + value.getSelectionEnd();
    }

    public static String truncateString(String s, int limit) {
        if (s == null) {
            return null;
        }
        if (s.length() < limit) {
            return s;
        }
        return s.substring(0, limit);
    }

    public static String truncateStringAtBegin(String s, int limit) {
        if (s == null) {
            return null;
        }
        if (s.length() < limit) {
            return s;
        }
        return s.substring(s.length() - limit, s.length());
    }

    public static String concatenateStrings(List<String> items) {
        if (items == null) {
            return null;
        }
        if (items.size() == 0) {
            return "";
        }
        int expectedSize = 0;
        for (String item : items) {
            expectedSize += item.length();
        }
        StringBuffer result = new StringBuffer(expectedSize);
        for (String item : items) {
            result.append(item);
        }
        return result.toString();
    }

    public static String removeAllHtmlTagsIfHtmlString(String html) {
        if (html == null) {
            return null;
        }
        if (html.startsWith("<html>")) {
            html = ValueManager.removeAllHtmlTags(html);
        }
        return html;
    }

    public static String removeAllHtmlTags(String html) {
        if (html == null) {
            return null;
        }
        html = html.replaceAll("\r", "");
        html = html.replaceAll("\n", " ");
        html = html.replaceAll("<br>", "\n");
        html = html.replaceAll("\\<.*?\\>", "");
        html = html.trim();
        return html;
    }

    public static String removeDoubleSpacesAndTrim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().replaceAll(" +", " ");
    }

    public static String toLowerCaseId(String s) {
        if (s == null) {
            return s;
        }
        return s.toLowerCase(s_localeLowerUppercase);
    }

    public static String toUpperCaseId(String s) {
        if (s == null) {
            return s;
        }
        return s.toUpperCase(s_localeLowerUppercase);
    }

    public static String toLowerCaseText(String s) {
        if (s == null) {
            return s;
        }
        return s.toLowerCase();
    }

    public static String toUpperCaseText(String s) {
        if (s == null) {
            return s;
        }
        return s.toUpperCase();
    }

    public static Format findFormatter(Object value, String format, String formatmask, String timezone, String language, String country) {
        Locale l = Locale.getDefault();
        try {
            if (language != null) {
                l = new Locale(language);
                if (country != null) {
                    l = new Locale(language, country);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Format result = null;
        if ("float".equals(format) || "double".equals(format) || "bigdecimal".equals(format)) {
            int numberOfDecimals;
            result = DecimalFormat.getNumberInstance(l);
            formatmask = ValueManager.recalculateFormatmask(formatmask, value);
            if (result instanceof DecimalFormat) {
                ((DecimalFormat)result).setParseBigDecimal(true);
            }
            if ((numberOfDecimals = ValueManager.getNumberOfDecimals(formatmask)) >= 0) {
                if (formatmask != null && formatmask.startsWith("decmax")) {
                    result.setMinimumFractionDigits(0);
                    result.setMaximumFractionDigits(numberOfDecimals);
                } else {
                    result.setMinimumFractionDigits(numberOfDecimals);
                    result.setMaximumFractionDigits(numberOfDecimals);
                }
            } else if (formatmask != null && formatmask.length() > 0) {
                try {
                    if (formatmask.endsWith("0.")) {
                        formatmask = formatmask.substring(0, formatmask.length() - 1);
                    }
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(l);
                    result = new DecimalFormat(formatmask, decimalFormatSymbols);
                }
                catch (Throwable decimalFormatSymbols) {
                    // empty catch block
                }
            }
        }
        if ("int".equals(format) || "long".equals(format) || "short".equals(format) || "biginteger".equals(format)) {
            result = NumberFormat.getIntegerInstance(l);
            if (formatmask != null) {
                try {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(l);
                    result = new DecimalFormat(formatmask, decimalFormatSymbols);
                }
                catch (Throwable decimalFormatSymbols) {
                    // empty catch block
                }
            }
        }
        if ("date".equals(format) || "datetime".equals(format) || "time".equals(format)) {
            block33: {
                int style = ValueManager.convertDateFormatMaskIntoStyle(formatmask);
                if (style != -1) {
                    if (!s_infoProvider.getUseJavaClientFormatter()) {
                        result = ValueManager.createDateFormat(country, format, formatmask);
                    } else {
                        result = DateFormat.getDateInstance(style, l);
                        if ("datetime".equals(format)) {
                            result = DateFormat.getDateTimeInstance(style, style, l);
                        } else if ("time".equals(format)) {
                            result = DateFormat.getTimeInstance(style, l);
                        }
                    }
                } else {
                    try {
                        result = new SimpleDateFormat(formatmask);
                    }
                    catch (Throwable t) {
                        ULog.logINF("", t);
                        if (!s_infoProvider.getUseJavaClientFormatter()) {
                            result = ValueManager.createDateFormat(country, "medium", formatmask);
                        }
                        result = DateFormat.getDateInstance(2);
                        if ("datetime".equals(format)) {
                            result = DateFormat.getDateTimeInstance(2, 2);
                        }
                        if (!"time".equals(format)) break block33;
                        result = DateFormat.getTimeInstance(2);
                    }
                }
            }
            TimeZone tz = TimeZone.getDefault();
            if (timezone != null) {
                try {
                    tz = TimeZone.getTimeZone(timezone);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ((DateFormat)result).setTimeZone(tz);
        }
        return result;
    }

    private static String recalculateFormatmask(String formatmask, Object value) {
        int numberOfDecimalsAfter;
        if (formatmask == null) {
            return formatmask;
        }
        if (value == null) {
            return formatmask;
        }
        if (!formatmask.startsWith("dig")) {
            return formatmask;
        }
        int numberOfDigits = -1;
        boolean maxActive = false;
        if (formatmask.startsWith("digmax")) {
            numberOfDigits = ValueManager.decodeInt(formatmask.substring(6), -1);
            maxActive = true;
        } else {
            numberOfDigits = ValueManager.decodeInt(formatmask.substring(3), -1);
        }
        if (numberOfDigits < 0) {
            return formatmask;
        }
        String s = ValueManager.convertObject2ValueString(value);
        int dotIndex = s.indexOf(46);
        if (dotIndex < 0) {
            dotIndex = s.length();
        }
        if ((numberOfDecimalsAfter = numberOfDigits - dotIndex) < 0) {
            numberOfDecimalsAfter = 0;
        }
        if (!maxActive) {
            return "dec" + numberOfDecimalsAfter;
        }
        return "decmax" + numberOfDecimalsAfter;
    }

    private static DateFormat createDateFormat(String country, String format, String formatmask) {
        try {
            int secondIndex;
            int minuteIndex;
            int hourIndex;
            int dayIndex;
            int monthIndex;
            String ymd = s_infoProvider.getCountryYmdSequence(country);
            String dateSep = s_infoProvider.getCountryDateSep(country);
            String timeSep = s_infoProvider.getCountryTimeSep(country);
            String pattern = ymd;
            pattern = pattern.substring(0, 1) + dateSep + pattern.substring(1, 2) + dateSep + pattern.substring(2, 3);
            if ("datetime".equals(format)) {
                pattern = "short".equals(formatmask) ? pattern + " H" + timeSep + "MIN" : pattern + " H" + timeSep + "MIN" + timeSep + "S";
            } else if ("time".equals(format)) {
                pattern = "short".equals(formatmask) ? "H" + timeSep + "MIN" : "H" + timeSep + "MIN" + timeSep + "S";
            }
            int yearIndex = pattern.indexOf("y");
            if (yearIndex >= 0) {
                String yearPattern = "yyyy";
                if ("short".equals(formatmask)) {
                    yearPattern = "yy";
                }
                pattern = pattern.substring(0, yearIndex) + yearPattern + pattern.substring(yearIndex + 1);
            }
            if ((monthIndex = pattern.indexOf("m")) >= 0) {
                pattern = pattern.substring(0, monthIndex) + "MM" + pattern.substring(monthIndex + 1);
            }
            if ((dayIndex = pattern.indexOf("d")) >= 0) {
                pattern = pattern.substring(0, dayIndex) + "dd" + pattern.substring(dayIndex + 1);
            }
            if ((hourIndex = pattern.indexOf("H")) >= 0) {
                pattern = pattern.substring(0, hourIndex) + "HH" + pattern.substring(hourIndex + 1);
            }
            if ((minuteIndex = pattern.indexOf("MIN")) >= 0) {
                pattern = pattern.substring(0, minuteIndex) + "mm" + pattern.substring(minuteIndex + 3);
            }
            if ((secondIndex = pattern.indexOf("S")) >= 0) {
                pattern = pattern.substring(0, secondIndex) + "ss" + pattern.substring(secondIndex + 1);
            }
            SimpleDateFormat result = new SimpleDateFormat(pattern);
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private static int convertDateFormatMaskIntoStyle(String formatmask) {
        int style = -1;
        if (formatmask == null) {
            style = 2;
        } else if (formatmask.equals("medium")) {
            style = 2;
        } else if (formatmask.equals("short")) {
            style = 3;
        } else if (formatmask.equals("long")) {
            style = 1;
        } else if (formatmask.equals("all")) {
            style = 2;
        }
        return style;
    }

    public static int getNumberOfDecimals(String formatmask) {
        int fromIndex = -1;
        if (formatmask != null && formatmask.startsWith("dec")) {
            fromIndex = 3;
        }
        if (formatmask != null && formatmask.startsWith("decmax")) {
            fromIndex = 6;
        }
        if (fromIndex > 0) {
            try {
                String is = formatmask.substring(fromIndex);
                int result = new Integer(is);
                return result;
            }
            catch (Throwable t) {
                ULog.logWAR("Error when processing format mask " + formatmask + ", " + t.toString());
            }
        }
        return -1;
    }

    public static boolean checkIfFormatIsNumeric(String format) {
        if (format == null) {
            return false;
        }
        if ("int".equals(format)) {
            return true;
        }
        if ("short".equals(format)) {
            return true;
        }
        if ("long".equals(format)) {
            return true;
        }
        if ("biginteger".equals(format)) {
            return true;
        }
        if ("float".equals(format)) {
            return true;
        }
        if ("double".equals(format)) {
            return true;
        }
        return "bigdecimal".equals(format);
    }

    public static boolean checkIfFormatIsNumericWithDecimals(String format) {
        if (format == null) {
            return false;
        }
        if ("float".equals(format)) {
            return true;
        }
        if ("double".equals(format)) {
            return true;
        }
        return "bigdecimal".equals(format);
    }

    public static boolean checkIfFormatIsNumericNoDecimals(String format) {
        if (format == null) {
            return false;
        }
        if ("int".equals(format)) {
            return true;
        }
        if ("short".equals(format)) {
            return true;
        }
        if ("long".equals(format)) {
            return true;
        }
        return "biginteger".equals(format);
    }

    public static boolean checkIfFormatIsDate(String format) {
        if (format == null) {
            return false;
        }
        if ("date".equals(format)) {
            return true;
        }
        if ("time".equals(format)) {
            return true;
        }
        return "datetime".equals(format);
    }

    public static boolean checkIfFormatIsBoolean(String format) {
        if (format == null) {
            return false;
        }
        return "boolean".equals(format);
    }

    public static char convertHexCodeToChar(String hexcode) {
        String hex = "0000" + hexcode;
        hex = hex.substring(hex.length() - 4);
        byte[] bs = ValueManager.decodeHexString(hex, false);
        int[] is = new int[bs.length];
        for (int i = 0; i < is.length; ++i) {
            is[i] = bs[i] >= 0 ? bs[i] : 256 + bs[i];
        }
        int isi = is[0] * 256 + is[1];
        char c = (char)isi;
        return c;
    }

    public static boolean checkIfXMLIsValid(String m_content) {
        try {
            if (m_content.trim().length() == 0) {
                throw new Exception("XML is empty.");
            }
            SAXParser saxParser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader("<dummy>" + m_content + "</dummy>"));
            saxParser.parse(is, (DefaultHandler)new MyCheckParser());
            return true;
        }
        catch (Throwable t) {
            throw new Error("Exception when validating XML: " + m_content, t);
        }
    }

    private static String translateString(String s, char[] froms, String[] tos) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        boolean modifiedString = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean modifiedCharacter = false;
            for (int j = 0; j < froms.length; ++j) {
                if (c != froms[j]) continue;
                sb.append(tos[j]);
                modifiedString = true;
                modifiedCharacter = true;
                break;
            }
            if (modifiedCharacter) continue;
            sb.append(c);
        }
        if (modifiedString) {
            return sb.toString();
        }
        return s;
    }

    public static String encodeURLPart(String urlPart) {
        if (urlPart == null) {
            return null;
        }
        try {
            urlPart = URLEncoder.encode(urlPart, CHARSET_UTF8.name());
            urlPart = urlPart.replace("+", "%20");
            return urlPart;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static String rightSizeLineBreaks(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace("\r", "");
        text = text.replace("\n", "\r\n");
        return text;
    }

    public static String approveFileName(String name) {
        if (name != null && name.contains("..")) {
            throw new FileNameValidatesSecurityRuleError("File name not allowed - it contains \"..\"-sequence.");
        }
        return name;
    }

    public static String convertFileNameToCanonical(String fileName, boolean isDirectory) {
        if (fileName == null) {
            return fileName;
        }
        try {
            boolean withAsterisk = false;
            if (fileName.contains("*")) {
                withAsterisk = true;
                fileName = fileName.replace("*", TEMP_REPLACE_ASTERISK);
            }
            fileName = new File(fileName).getCanonicalPath();
            fileName = ValueManager.encodeIntoValidFileName(fileName, isDirectory);
            if (withAsterisk) {
                fileName = fileName.replace(TEMP_REPLACE_ASTERISK, "*");
            }
            return fileName;
        }
        catch (Throwable t) {
            return fileName;
        }
    }

    public static String replaceSystemProperties(String s, String context, boolean encodeToXml) {
        try {
            String value;
            String name4;
            int bracketIndex;
            if (s == null) {
                return null;
            }
            HashSet<String> envNames = new HashSet<String>();
            HashSet<String> sysNames = new HashSet<String>();
            HashSet<String> ccparamNames = new HashSet<String>();
            int currentIndex = 0;
            while ((currentIndex = s.indexOf("${env.", currentIndex)) >= 0 && (bracketIndex = s.indexOf("}", currentIndex)) >= 0) {
                name4 = s.substring(currentIndex + 6, bracketIndex);
                envNames.add(name4);
                currentIndex = bracketIndex;
            }
            currentIndex = 0;
            while ((currentIndex = s.indexOf("${sys.", currentIndex)) >= 0 && (bracketIndex = s.indexOf("}", currentIndex)) >= 0) {
                name4 = s.substring(currentIndex + 6, bracketIndex);
                sysNames.add(name4);
                currentIndex = bracketIndex;
            }
            currentIndex = 0;
            while ((currentIndex = s.indexOf("${ccparam.", currentIndex)) >= 0 && (bracketIndex = s.indexOf("}", currentIndex)) >= 0) {
                name4 = s.substring(currentIndex + 10, bracketIndex);
                ccparamNames.add(name4);
                currentIndex = bracketIndex;
            }
            for (String name2 : envNames) {
                value = System.getenv(ValueManager.embedContext(context, name2));
                if (value == null) {
                    value = System.getenv(name2);
                }
                if (value == null) {
                    ULog.logERR("Environment property not defined: " + name2);
                    continue;
                }
                if (encodeToXml) {
                    value = ValueManager.encodeIntoValidXMLString(value);
                }
                ULog.logINF("Environment property used: " + name2 + "/" + value);
                s = s.replace("${env." + name2 + "}", value);
            }
            for (String name3 : sysNames) {
                value = System.getProperty(ValueManager.embedContext(context, name3));
                if (value == null) {
                    value = System.getProperty(name3);
                }
                if (value == null) {
                    ULog.logERR("System property not defined: " + name3);
                    continue;
                }
                if (encodeToXml) {
                    value = ValueManager.encodeIntoValidXMLString(value);
                }
                ULog.logINF("System property used: " + name3 + "/" + value);
                s = s.replace("${sys." + name3 + "}", value);
            }
            ICCConfigParams cccp = CCConfigParams.instance();
            for (String name4 : ccparamNames) {
                String value2 = cccp.getConfigParam(name4);
                if (value2 == null) {
                    ULog.logERR("Configuration param not defined: " + name4);
                    continue;
                }
                if (encodeToXml) {
                    value2 = ValueManager.encodeIntoValidXMLString(value2);
                }
                ULog.logINF("System property used: " + name4 + "/" + value2);
                s = s.replace("${ccparam." + name4 + "}", value2);
            }
            Map<String, String> additionalReplacements = s_infoProvider.findAdditionalReplacementsForReplaceSystemProperties();
            if (additionalReplacements != null) {
                for (String key : additionalReplacements.keySet()) {
                    String value3 = additionalReplacements.get(key);
                    if (encodeToXml) {
                        value3 = ValueManager.encodeIntoValidXMLString(value3);
                    }
                    if (value3 == null) continue;
                    s = s.replace(key, value3);
                }
            }
            return s;
        }
        catch (Throwable t) {
            return s;
        }
    }

    private static String embedContext(String context, String name) {
        if (context == null) {
            return name;
        }
        if (name == null) {
            return name;
        }
        name = context + "." + name;
        return name;
    }

    public static String removeLeadingXMLDeclaration(String xml) {
        if (xml == null) {
            return null;
        }
        int index1 = xml.indexOf("<?");
        if (index1 < 0) {
            return xml;
        }
        int index2 = xml.indexOf("?>", index1 + 2);
        if (index2 < 0) {
            return xml;
        }
        return xml.substring(0, index1) + xml.substring(index2 + 2);
    }

    public static Source convertStringIntoXMLSource(String xml) {
        try {
            SAXParser sp = SAXParserCreator.createSAXParser();
            SAXSource result = new SAXSource(sp.getXMLReader(), new InputSource(new StringReader(xml)));
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not convert XML to XMLStreamReader: " + xml, t);
        }
    }

    public static List<String> getLinesOfText(String text) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            line = line.replace("\r", "");
            result.add(line);
        }
        return result;
    }

    public static String buildTimeStamp() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYYMMdd_HHmmss");
        sdf.setCalendar(cal);
        return sdf.format(new java.util.Date());
    }

    public static String buildDateStamp() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYYMMdd");
        sdf.setCalendar(cal);
        return sdf.format(new java.util.Date());
    }

    public static String convertStringIntoFilePath(String name) {
        return ValueManager.convertStringIntoFilePath(name, true);
    }

    public static String convertStringIntoFilePath(String name, boolean lowerCase) {
        return ValueManager.convertStringWithNotAllowedCharacters(CHARSET_NOTALLOWED_IN_FILEPATH, name, lowerCase);
    }

    public static String convertStringIntoFileName(String name) {
        return ValueManager.convertStringIntoFileName(name, true);
    }

    public static String convertStringIntoFileName(String name, boolean lowerCase) {
        return ValueManager.convertStringWithNotAllowedCharacters(CHARSET_NOTALLOWED_IN_FILENAME, name, lowerCase);
    }

    public static String removeDirectoryPathAndExtensionFromFileName(String name) {
        name = ValueManager.removeDirectoryPathFromFileName(name);
        name = ValueManager.removeExtensionFromFileName(name);
        return name;
    }

    public static String removeExtensionFromFileName(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        int indexSlash = name.lastIndexOf(47);
        if (indexSlash > index) {
            return name;
        }
        indexSlash = name.lastIndexOf(92);
        if (indexSlash > index) {
            return name;
        }
        return name.substring(0, index);
    }

    public static String removeDirectoryPathFromFileName(String name) {
        if (name == null) {
            return null;
        }
        while (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        while (name.endsWith("\\")) {
            name = name.substring(0, name.length() - 1);
        }
        int indexSlash = name.lastIndexOf(47);
        if (indexSlash >= 0) {
            name = name.substring(indexSlash + 1);
        }
        if ((indexSlash = name.lastIndexOf(92)) >= 0) {
            name = name.substring(indexSlash + 1);
        }
        return name;
    }

    public static String removeFileNameFromDirectoryPath(String name) {
        int indexSlash2;
        if (name == null) {
            return null;
        }
        if (name.endsWith("/")) {
            return name;
        }
        if (name.endsWith("\\")) {
            return name;
        }
        int indexSlash1 = name.lastIndexOf(47);
        int indexSlashMax = Math.max(indexSlash1, indexSlash2 = name.lastIndexOf(92));
        if (indexSlashMax > 0) {
            return name.substring(0, indexSlashMax + 1);
        }
        return "";
    }

    public static String createEmptyString(int numberOfCharacters) {
        String result = s_emptyStrings.get(numberOfCharacters);
        if (result == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < numberOfCharacters; ++i) {
                sb.append(" ");
            }
            result = sb.toString();
            s_emptyStrings.put(numberOfCharacters, result);
        }
        return result;
    }

    public static boolean checkIfClassIsNumber(Class c) {
        if (c == null) {
            return false;
        }
        if (Byte.class.isAssignableFrom(c)) {
            return true;
        }
        if (Short.class.isAssignableFrom(c)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(c)) {
            return true;
        }
        if (Long.class.isAssignableFrom(c)) {
            return true;
        }
        if (BigInteger.class.isAssignableFrom(c)) {
            return true;
        }
        if (Float.class.isAssignableFrom(c)) {
            return true;
        }
        if (Double.class.isAssignableFrom(c)) {
            return true;
        }
        return BigDecimal.class.isAssignableFrom(c);
    }

    public static boolean checkIfObjectIsNumber(Object o) {
        if (o == null) {
            return false;
        }
        return ValueManager.checkIfClassIsNumber(o.getClass());
    }

    public static boolean checkIfObjectIsDate(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof LocalDate) {
            return true;
        }
        return o instanceof java.util.Date;
    }

    public static boolean checkIfObjectIsTime(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof LocalTime;
    }

    public static boolean checkIfObjectIsDateTime(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof LocalDateTime;
    }

    public static java.util.Date createToday(String timeZone) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static java.util.Date createTodayAtHour(String timeZone, int hour) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(11, hour);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static java.util.Date createTodayPlus(String timeZone, int plusDays) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, plusDays);
        return c.getTime();
    }

    private static String convertStringWithNotAllowedCharacters(Set<Character> notAllowedCharacters, String name, boolean lowerCase) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!notAllowedCharacters.contains(Character.valueOf(c))) continue;
            name = name.substring(0, i) + "_" + name.substring(i + 1);
        }
        if (lowerCase) {
            name = ValueManager.toLowerCaseId(name);
        }
        return name;
    }

    private static Long decodeLongObject(String s) {
        try {
            return new Long(s);
        }
        catch (Throwable t) {
            try {
                BigDecimal bd = new BigDecimal(s);
                bd = bd.setScale(0, 4);
                long result = bd.longValue();
                return new Long(result);
            }
            catch (Throwable tt) {
                return new Long(s);
            }
        }
    }

    private static Integer decodeIntegerObject(String s) {
        try {
            return new Integer(s);
        }
        catch (Throwable t) {
            try {
                BigDecimal bd = new BigDecimal(s);
                bd = bd.setScale(0, 4);
                int result = bd.toBigInteger().intValue();
                return new Integer(result);
            }
            catch (Throwable tt) {
                return new Integer(s);
            }
        }
    }

    private static List<String> transferStringArrayToList(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            result.add(values[i]);
        }
        return result;
    }

    static {
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('<'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('>'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf(':'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('\"'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('|'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('?'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('*'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('\r'));
        CHARSET_NOTALLOWED_IN_FILEPATH.add(Character.valueOf('\n'));
        CHARSET_NOTALLOWED_IN_FILENAME.addAll(CHARSET_NOTALLOWED_IN_FILEPATH);
        CHARSET_NOTALLOWED_IN_FILENAME.add(Character.valueOf('/'));
        CHARSET_NOTALLOWED_IN_FILENAME.add(Character.valueOf('\\'));
        ValueManager.initialize();
        escapeXMLStringFroms = new char[]{'&', '<', '>', '\"', '\''};
        escapeXMLStringTos = new String[]{"&amp;", "&lt;", "&gt;", "&#34;", "&#39;"};
        encodeIntoValidXMLStringFroms = new char[]{'&', '<', '>', '\"', '\'', '\n', '\\'};
        encodeIntoValidXMLStringTos = new String[]{"&amp;", "&lt;", "&gt;", "&#34;", "&#39;", "&#10;", "&#92;"};
        encodeIntoValidXMLValueStringFroms = new char[]{'\"', '\'', '\n'};
        encodeIntoValidXMLValueStringTos = new String[]{"&#34;", "&#39;", "&#10;"};
        TEMP_REPLACE_ASTERISK = UniqueIdCreator.createUUID();
    }

    public static interface IValueManagerInfoProvider {
        public Locale getCurrentLocale();

        public Locale getCurrentLocaleClient();

        public String getValueManagerTrueString();

        public String getValueManagerTrueStringExport();

        public String getValueManagerFalseString();

        public String getValueManagerFalseStringExport();

        public boolean getUseJavaClientFormatter();

        public String getCountryYmdSequence(String var1);

        public String getCountryDateSep(String var1);

        public String getCountryTimeSep(String var1);

        public Map<String, String> findAdditionalReplacementsForReplaceSystemProperties();

        public Object convertStringIntoExtendedObject(String var1, Class var2);
    }

    static class StringListParser
    extends DefaultHandler {
        List<String> i_result = new ArrayList<String>();

        StringListParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("s")) {
                this.i_result.add(attributes.getValue("value"));
            }
        }
    }

    public static class HotKeyInfo {
        public boolean m_isAltDown;
        public boolean m_isShiftDown;
        public boolean m_isControlDown;
        public int m_keyCode;
    }

    public static class ImageData
    implements Serializable {
        public String imageName;
        public boolean followScaling = true;
        public boolean mirrorWhenRtl = false;
    }

    public static class NameValue
    implements Serializable {
        public String name;
        public String value;

        public NameValue() {
        }

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class MyCheckParser
    extends DefaultHandler {
    }
}

