/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.io.File;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.FileManagerSecurityError;
import org.eclnt.util.valuemgmt.FileNameValidatesSecurityRuleError;
import org.eclnt.util.valuemgmt.ValueManager;
import org.junit.Assert;
import org.junit.Test;

public class FileManagerTest {
    @Test
    public void test() {
        FileManager.ensureDirectoryExists("c:\\temp");
        String dir = "c:\\temp\\cctempjunittest";
        FileManager.createDirectory(dir);
        File f = new File(dir);
        Assert.assertTrue((boolean)f.exists());
        dir = "c:\\temp\\cctempjunittest2\\sub\\sub";
        FileManager.mkdir(dir);
        f = new File(dir);
        Assert.assertTrue((boolean)f.exists());
        String dir1 = "c:\\temp\\cctempjunittest2";
        String dir2 = "c:\\temp\\cctempjunittest2\\sub\\sub";
        FileManager.deleteDirectoryContent(dir1, true);
        File f2 = new File(dir2);
        Assert.assertTrue((!f2.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testSecurity() {
        boolean secErrorWasTriggered;
        block11: {
            String s;
            block10: {
                block9: {
                    block8: {
                        String root = "c:\\bmu_jtc";
                        FileManager.addAllowedRootDirectoryRead(root);
                        secErrorWasTriggered = false;
                        try {
                            FileManager.readFile("c:\\temp\\harry.txt", true);
                        }
                        catch (Error e) {
                            s = ValueManager.getStackstraceString(e);
                            if (!s.contains(FileManagerSecurityError.class.getSimpleName())) break block8;
                            secErrorWasTriggered = true;
                        }
                    }
                    Assert.assertTrue((boolean)secErrorWasTriggered);
                    secErrorWasTriggered = false;
                    try {
                        FileManager.writeUTF8File("c:\\bmu_jtc\\temp\\harry.txt", "Hello", true);
                    }
                    catch (Error e) {
                        s = ValueManager.getStackstraceString(e);
                        if (!s.contains(FileManagerSecurityError.class.getSimpleName())) break block9;
                        secErrorWasTriggered = true;
                    }
                }
                Assert.assertTrue((boolean)secErrorWasTriggered);
                secErrorWasTriggered = false;
                try {
                    FileManager.readFile("c:\\bmu_jtc\\harry.txt", true);
                }
                catch (Error e) {
                    s = ValueManager.getStackstraceString(e);
                    if (!s.contains(FileManagerSecurityError.class.getSimpleName())) break block10;
                    secErrorWasTriggered = true;
                }
            }
            Assert.assertTrue((!secErrorWasTriggered ? 1 : 0) != 0);
            secErrorWasTriggered = false;
            try {
                FileManager.readFile("c:\\bmu_jtc\\..\\harry.txt", true);
            }
            catch (Error e) {
                s = ValueManager.getStackstraceString(e);
                if (!s.contains(FileNameValidatesSecurityRuleError.class.getSimpleName())) break block11;
                secErrorWasTriggered = true;
            }
        }
        Assert.assertTrue((secErrorWasTriggered ? 1 : 0) != 0);
    }
}

