/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import org.eclnt.util.map.LazyLoadingMap;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyLoadingMap {
    @Test
    public void test() {
        try {
            LazyLoadingMap<String> m = new LazyLoadingMap<String>(new LazyLoadingMap.ILazyLoader<String>(){

                @Override
                public String lazyLoad(String key) {
                    return "Value of " + key;
                }
            });
            String s = m.get("aaa");
            System.out.println(s);
            Assert.assertEquals((Object)"Value of aaa", (Object)s);
            System.out.println("finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testNullValue() {
        try {
            LazyLoadingMap<String> m = new LazyLoadingMap<String>(new LazyLoadingMap.ILazyLoader<String>(){

                @Override
                public String lazyLoad(String key) {
                    if (key.startsWith("a")) {
                        return null;
                    }
                    return "Value of " + key;
                }
            });
            String s = m.get("aaa");
            System.out.println(s);
            Assert.assertEquals(null, (Object)s);
            s = m.get("bbb");
            System.out.println(s);
            Assert.assertEquals((Object)"Value of bbb", (Object)s);
            System.out.println("finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }
}

