/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.ZipUtil;
import org.junit.Test;

public class TestZipUtil {
    @Test
    public void test() {
        FileOutputStream fos = null;
        try {
            List<String> fileNames = FileManager.getFilesOfDirectoryByPattern("c:/temp", ".xml");
            ArrayList<File> files = new ArrayList<File>();
            for (String fileName : fileNames) {
                System.out.println(fileName);
                files.add(new File(fileName));
            }
            fos = new FileOutputStream("c:/temp/testZip.zip");
            new ZipUtil().zipFiles(files, fos);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("t");
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable fileNames) {}
        }
    }

    @Test
    public void testReadZipStructure() {
        try {
            List<URL> jarPaths = new ClassloaderReader().readResourcePaths("/META-INF/MANIFEST.MF", true);
            for (URL jarPath : jarPaths) {
                String p = jarPath.toString();
                System.out.println("=====> " + p);
                if (!p.startsWith("jar:file:")) continue;
                System.out.println("==============================================================");
                p = p.substring("jar_file:".length());
                int index = p.indexOf("!");
                if (index > 0) {
                    p = p.substring(0, index);
                }
                System.out.println("=====> " + p);
                System.out.println("==============================================================");
                FileInputStream is = new FileInputStream(p);
                List<String> names = new ZipUtil().readFileList(is);
                for (String name : names) {
                    System.out.println(name);
                }
                ((InputStream)is).close();
            }
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("t");
        }
    }
}

