/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.calendar;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.calendar.IExtCalendarMgr;
import org.eclnt.util.valuemgmt.ValueManager;

public class ExtCalendarInfos {
    List<IExtCalendarMgr.ExtCalendarInfo> m_infos = new ArrayList<IExtCalendarMgr.ExtCalendarInfo>();

    public void addExtCalendarInfo(IExtCalendarMgr.ExtCalendarInfo ext) {
        this.m_infos.add(ext);
    }

    public void clear() {
        this.m_infos.clear();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<result>\n");
        for (IExtCalendarMgr.ExtCalendarInfo eci : this.m_infos) {
            String commentXML = ValueManager.encodeIntoValidXMLString(eci.getComment());
            sb.append("<day date='" + eci.getDate().getTime() + "' comment='" + commentXML + "' selectable='" + eci.isSelectable() + "' warningonselection='" + eci.getWarningOnSelection() + "'");
            if (eci.getBackground() != null) {
                String background = ValueManager.encodeIntoValidXMLString(eci.getBackground());
                sb.append(" background='" + background + "'");
            }
            sb.append("/>\n");
        }
        sb.append("</result>");
        return sb.toString();
    }

    public String toString() {
        return this.toXML();
    }
}

