/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.elements.polling.UNIFIEDPOLLINGBinding;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public class CentralPolling {
    UNIFIEDPOLLINGBinding m_polling;
    Set<IListener> m_listeners = new HashSet<IListener>();

    public static CentralPolling instance() {
        return DefaultScreens.getSessionAccess().getCentralPolling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IListener listener) {
        Set<IListener> set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IListener listener) {
        Set<IListener> set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.remove(listener);
        }
    }

    public boolean getRenderPolling() {
        return SystemXml.getDialogMessageBusAsynchronous();
    }

    public UNIFIEDPOLLINGBinding getPolling() {
        if (this.m_polling == null && this.getRenderPolling()) {
            this.m_polling = new UNIFIEDPOLLINGBinding();
        }
        return this.m_polling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPollingAction(ActionEvent event) {
        HashSet<IListener> listeners = new HashSet<IListener>();
        Set<IListener> set = this.m_listeners;
        synchronized (set) {
            listeners.addAll(this.m_listeners);
        }
        for (IListener listener : listeners) {
            try {
                listener.reactOnPollingAction();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when executing central polling listener: " + t, t);
            }
        }
    }

    public void wakeup() {
        this.m_polling.wakeup(true);
    }

    public static interface IListener {
        public void reactOnPollingAction();
    }
}

