/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.onlinehelp.defaultimpl.OnlineHelpProcessorJBrowser;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ProfileLogInfo;
import org.eclnt.jsfserver.util.ProfileLogWriter;
import org.eclnt.util.file.FileManager;

public class ProfilingViewer {
    String m_profilingLogDirectoryWS;
    FIXGRIDListBinding<ProfilingFilesItem> m_profilingFiles = new FIXGRIDListBinding();
    FIXGRIDListBinding<ProfilingGridItem> m_profilingGrid = new FIXGRIDListBinding();

    public ProfilingViewer() {
        this.m_profilingLogDirectoryWS = HttpSessionAccess.getServletTempDirectory() + "profilelogs/";
        FileManager.ensureDirectoryForFileExists(this.m_profilingLogDirectoryWS + "dummy");
        this.refreshFileList();
    }

    public FIXGRIDListBinding<ProfilingFilesItem> getProfilingFiles() {
        return this.m_profilingFiles;
    }

    public FIXGRIDListBinding<ProfilingGridItem> getProfilingGrid() {
        return this.m_profilingGrid;
    }

    public void onRefresh(ActionEvent event) {
        this.refreshFileList();
    }

    public void onRemoveAllFiles(ActionEvent event) {
        try {
            FileManager.deleteDirectoryContent(this.m_profilingLogDirectoryWS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.refreshFileList();
    }

    public void onHelp(ActionEvent event) {
        OnlineHelpProcessorJBrowser.getInstance().openOnlineHelp("/eclntjsfserver/help/profilingviewer.html", true);
    }

    private void refreshFileList() {
        this.m_profilingGrid.getItems().clear();
        this.m_profilingFiles.getItems().clear();
        List<File> files = FileManager.getFilesOfDirectory(this.m_profilingLogDirectoryWS);
        for (File file : files) {
            if (!file.getName().endsWith(".csv")) continue;
            ProfilingFilesItem pfi = new ProfilingFilesItem(file);
            this.m_profilingFiles.getItems().add(pfi);
        }
        Collections.sort(this.m_profilingFiles.getItems());
    }

    private void displayFile(File file) {
        this.m_profilingGrid.getItems().clear();
        List<ProfileLogInfo> plis = ProfileLogWriter.readProfileLogMessages(file.getAbsolutePath());
        int counter = 1;
        for (ProfileLogInfo pli : plis) {
            ProfilingGridItem plgi = new ProfilingGridItem(pli, counter);
            this.m_profilingGrid.getItems().add(plgi);
            ++counter;
        }
    }

    public class ProfilingFilesItem
    extends FIXGRIDItem
    implements Comparable<ProfilingFilesItem> {
        File i_file;

        public ProfilingFilesItem(File file) {
            this.i_file = file;
        }

        public String getName() {
            return this.i_file.getName();
        }

        public long getDate() {
            return this.i_file.lastModified();
        }

        @Override
        public void onRowExecute() {
            ProfilingViewer.this.displayFile(this.i_file);
        }

        @Override
        public int compareTo(ProfilingFilesItem o) {
            Long l = this.getDate();
            Long lo = o.getDate();
            return l.compareTo(lo) * -1;
        }
    }

    public class ProfilingGridItem
    extends FIXGRIDItem {
        int i_counter;
        ProfileLogInfo i_pli;

        public ProfilingGridItem(ProfileLogInfo pli, int counter) {
            this.i_pli = pli;
            this.i_counter = counter;
        }

        public ProfileLogInfo getPli() {
            return this.i_pli;
        }

        public int getCounter() {
            return this.i_counter;
        }
    }
}

