/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.phases;

import java.io.Serializable;
import org.eclnt.jsfserver.elements.phases.PhaseRunnables;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.util.log.CLog;

public class PhaseManager
implements Serializable {
    public static void runAfterUpdatePhase(Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            ISessionAbstraction hs = HttpSessionAccess.getCurrentDialogSession();
            PhaseManager.runAfterUpdatePhase(hs, run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runAfterUpdatePhase(ISessionAbstraction hs, Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            PhaseManager.getOrCreatePhaseRunnables(hs).addAfterUpdateRunnable(run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runBeforeUpdatePhase(Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            ISessionAbstraction hs = HttpSessionAccess.getCurrentDialogSession();
            PhaseManager.runBeforeUpdatePhase(hs, run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runBeforeUpdatePhase(ISessionAbstraction hs, Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            PhaseManager.getOrCreatePhaseRunnables(hs).addBeforeUpdateRunnable(run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runAfterInvokePhase(Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            ISessionAbstraction hs = HttpSessionAccess.getCurrentDialogSession();
            PhaseManager.runAfterInvokePhase(hs, run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runAfterInvokePhase(ISessionAbstraction hs, Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            PhaseManager.getOrCreatePhaseRunnables(hs).addAfterInvokeRunnable(run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runBeforeInvokePhase(Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            ISessionAbstraction hs = HttpSessionAccess.getCurrentDialogSession();
            PhaseManager.runBeforeInvokePhase(hs, run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runBeforeInvokePhase(ISessionAbstraction hs, Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            PhaseManager.getOrCreatePhaseRunnables(hs).addBeforeInvokeRunnable(run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runAfterRenderResponsePhase(Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            ISessionAbstraction hs = HttpSessionAccess.getCurrentDialogSession();
            PhaseManager.runAfterRenderResponsePhase(hs, run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runAfterRenderResponsePhase(ISessionAbstraction hs, Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            PhaseManager.getOrCreatePhaseRunnables(hs).addAfterRenderResponseRunnable(run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runBeforeRenderResponsePhase(Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            ISessionAbstraction hs = HttpSessionAccess.getCurrentDialogSession();
            PhaseManager.runBeforeRenderResponsePhase(hs, run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static void runBeforeRenderResponsePhase(ISessionAbstraction hs, Runnable run) {
        try {
            if (!PhaseManager.ensureRunningInUIThread()) {
                return;
            }
            PhaseManager.getOrCreatePhaseRunnables(hs).addBeforeRenderResponseRunnable(run);
        }
        catch (Throwable t) {
            UsageWithoutSessionContext.processThrowable(t);
        }
    }

    public static PhaseRunnables getPhaseRunnables() {
        if (!PhaseManager.ensureRunningInUIThread()) {
            return null;
        }
        ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
        return PhaseManager.getPhaseRunnables(dialogSession);
    }

    private static PhaseRunnables getPhaseRunnables(ISessionAbstraction dialogSession) {
        PhaseRunnables prs = (PhaseRunnables)dialogSession.getAttribute(PhaseRunnables.class.getName());
        return prs;
    }

    private static PhaseRunnables getOrCreatePhaseRunnables() {
        ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
        return PhaseManager.getOrCreatePhaseRunnables(dialogSession);
    }

    private static PhaseRunnables getOrCreatePhaseRunnables(ISessionAbstraction dialogSession) {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables(dialogSession);
        if (prs == null) {
            prs = new PhaseRunnables();
            dialogSession.setAttribute(PhaseRunnables.class.getName(), prs);
        }
        return prs;
    }

    private static boolean ensureRunningInUIThread() {
        if (!HttpSessionAccess.checkIfRunningInUIThread()) {
            CLog.L.log(CLog.LL_INF, "PhaseManager: Not executed because not running in UI thread.");
            return false;
        }
        return true;
    }
}

