/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.onlinehelp.defaultimpl;

import org.eclnt.jsfserver.onlinehelp.IOnlineHelpProcessor2;
import org.eclnt.jsfserver.onlinehelp.OnlineHelpConfiguration;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;

public abstract class OnlineHelpProcessorBase
implements IOnlineHelpProcessor2 {
    @Override
    public void processOnlineHelp(String helpId, String language, boolean refersToComponent) {
        String url = this.calculateURL(helpId, language);
        this.openOnlineHelp(url, refersToComponent);
    }

    protected abstract void openOnlineHelp(String var1, boolean var2);

    protected String calculateURL(String helpId, String language) {
        if (!helpId.startsWith("/")) {
            String url = OnlineHelpConfiguration.getContentDirectory();
            if (url == null) {
                throw new Error("Online help is not configured yet: /eclntjsfserver/onlinehelp.xml, content directory not defined");
            }
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + language + "/" + helpId + ".html";
            return url;
        }
        String url = helpId + "_" + language + ".html";
        if (WebResourceClassloaderReader.checkIfFileExists(url)) {
            return url;
        }
        url = helpId + ".html";
        return url;
    }
}

