/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.pagebean.componentascontrol.valuemgmt;

import org.eclnt.jsfserver.util.valuemgmt.IValueDelegation;
import org.eclnt.util.valuemgmt.simpledatatypemgmt.SimpleDataTypeMapper;

public abstract class AttributeReference<VALUECLASS>
implements IValueDelegation<VALUECLASS> {
    protected Class m_attributeClass;
    protected IValueDelegation m_expressionDelegation;
    protected VALUECLASS m_directValue;
    protected boolean m_valueInitialized = false;

    public AttributeReference(Class attributeClass) {
        this.m_attributeClass = attributeClass;
    }

    public void initializeValue(Object attributeValue) {
        if (attributeValue == null) {
            return;
        }
        if (attributeValue instanceof IValueDelegation) {
            this.m_expressionDelegation = (IValueDelegation)attributeValue;
        } else if (attributeValue instanceof String) {
            if (!this.checkIfStringMappingIsSupported()) {
                throw new Error("The attribute reference does not support mappgin from String value: " + this.getClass().getName());
            }
            this.m_directValue = this.mapStringValueToReferenceDataType((String)attributeValue);
        } else {
            throw new Error("Unexpected attribute class: " + attributeValue.getClass().getName());
        }
        this.m_valueInitialized = true;
    }

    @Override
    public void setValue(VALUECLASS value) {
        if (this.isUsingDirectValue()) {
            this.m_directValue = value;
        } else {
            Object expressionValue = this.mapToExpressionValue(value);
            this.m_expressionDelegation.setValue(expressionValue);
        }
    }

    @Override
    public VALUECLASS getValue() {
        if (this.isUsingDirectValue()) {
            return this.m_directValue;
        }
        return this.mapFromExpressionValue();
    }

    @Override
    public Class getValueClass() {
        return this.m_attributeClass;
    }

    public boolean isValueInitialized() {
        return this.m_valueInitialized;
    }

    protected boolean checkIfStringMappingIsSupported() {
        return true;
    }

    protected Object mapToExpressionValue(Object value) {
        Class expressionClass = this.m_expressionDelegation.getValueClass();
        if (expressionClass == null) {
            return value;
        }
        Object mappedValue = SimpleDataTypeMapper.map(value, expressionClass, true);
        return mappedValue;
    }

    protected VALUECLASS mapFromExpressionValue() {
        Object value = this.m_expressionDelegation.getValue();
        Object mappedValue = SimpleDataTypeMapper.map(value, this.m_attributeClass, true);
        return (VALUECLASS)mappedValue;
    }

    protected boolean isUsingExpression() {
        return this.m_expressionDelegation != null;
    }

    protected boolean isUsingDirectValue() {
        return this.m_expressionDelegation == null;
    }

    protected VALUECLASS mapStringValueToReferenceDataType(String attributeValue) {
        return (VALUECLASS)SimpleDataTypeMapper.map((Object)attributeValue, this.m_attributeClass, true);
    }
}

