/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling;

import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;

public class DefaultLongPolling
implements ILongPolling,
Serializable {
    static int s_idCounter = 0;
    String m_id = "cclongpolling_" + new Date().getTime() + "_" + ++s_idCounter;
    String m_bufferedUrl = null;
    boolean m_continuePolling = false;
    boolean m_justWaiting = false;
    HttpServletResponse m_justWaitingResponse = null;
    boolean m_wasWokenUpInNotWaitingPhase = false;
    boolean m_throwError = false;
    String m_longPollingResponse = null;
    boolean m_runningInMiniServerMode = HttpSessionAccess.checkIfRunningInMiniServerMode();
    long m_lastResponseTime;

    public DefaultLongPolling() {
        this.updateLastResponseTime();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public boolean getContinuePolling() {
        return this.m_continuePolling;
    }

    @Override
    public String getURL() {
        if (this.m_bufferedUrl == null) {
            String result = "cclongpolling/" + this.m_id + ".cclongpolling";
            result = ServletUtil.encodeURL(result, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse());
            this.m_bufferedUrl = result = "/" + result;
        }
        return this.m_bufferedUrl;
    }

    public boolean waitForEvent(HttpServletResponse response) {
        if (!this.m_wasWokenUpInNotWaitingPhase) {
            DefaultLongPolling defaultLongPolling = this;
            synchronized (defaultLongPolling) {
                try {
                    CLog.L.log(CLog.LL_INF, "Now waiting for event to wakeup this long polling thread");
                    this.m_justWaiting = true;
                    this.m_justWaitingResponse = response;
                    this.wait();
                    CLog.L.log(CLog.LL_INF, "Event woke up this thread");
                    this.m_justWaiting = false;
                    this.m_justWaitingResponse = null;
                    if (this.m_throwError) {
                        this.m_throwError = false;
                        throw new Error("Thread was aborted via abort-method");
                    }
                    return this.m_continuePolling;
                }
                catch (Throwable t) {
                    this.m_justWaiting = false;
                    this.m_justWaitingResponse = null;
                    CLog.L.log(CLog.LL_INF, "Error occurred when waiting.", t);
                    throw new Error(t);
                }
            }
        }
        CLog.L.log(CLog.LL_INF, "Directly passing back response - wake up was executed in a non-waiting phase");
        this.m_wasWokenUpInNotWaitingPhase = false;
        return this.m_continuePolling;
    }

    @Override
    public void wakeup(boolean continuePolling) {
        this.updateLastResponseTime();
        this.m_throwError = false;
        if (this.checkIfRunningInMiniServerMode()) {
            this.invokeMiniServerClientTrigger();
        } else {
            this.m_longPollingResponse = null;
            this.wakeupExecute(continuePolling, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupExecute(boolean continuePolling, String longPollingResponse) {
        this.m_longPollingResponse = longPollingResponse;
        if (this.m_justWaiting) {
            this.m_wasWokenUpInNotWaitingPhase = false;
            DefaultLongPolling defaultLongPolling = this;
            synchronized (defaultLongPolling) {
                try {
                    CLog.L.log(CLog.LL_INF, "Wakeup was called for the long polling thread, continuePolling = " + continuePolling);
                    this.m_continuePolling = continuePolling;
                    this.notify();
                }
                catch (Throwable t) {
                    this.m_continuePolling = false;
                    CLog.L.log(CLog.LL_ERR, "Error occurred when waking up.");
                    throw new Error(t);
                }
            }
        }
        this.m_wasWokenUpInNotWaitingPhase = true;
        this.m_continuePolling = continuePolling;
    }

    @Override
    public void wakeupForReconnect() {
        this.updateLastResponseTime();
        this.m_throwError = false;
        if (this.checkIfRunningInMiniServerMode()) {
            return;
        }
        this.wakeupExecute(true, "reconnect");
    }

    @Override
    @Deprecated
    public void abortThreadWithouContinuingPolling() {
        this.abortThreadWithoutContinuingPolling();
    }

    public void abortThreadWithoutContinuingPolling() {
        this.updateLastResponseTime();
        this.wakeup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortThread() {
        if (this.checkIfRunningInMiniServerMode()) {
            return;
        }
        try {
            if (this.m_justWaiting) {
                DefaultLongPolling defaultLongPolling = this;
                synchronized (defaultLongPolling) {
                    try {
                        CLog.L.log(CLog.LL_INF, "Finish thread");
                        this.m_throwError = true;
                        this.notify();
                    }
                    catch (Throwable t) {
                        this.m_continuePolling = false;
                        CLog.L.log(CLog.LL_ERR, "Error occurred when aborting thread", t);
                        throw new Error(t);
                    }
                }
            }
            this.m_wasWokenUpInNotWaitingPhase = true;
            this.m_continuePolling = true;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when closing thread for long polling", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortThreadWithErrorIfWaiting() {
        if (this.checkIfRunningInMiniServerMode()) {
            return;
        }
        if (this.m_justWaiting) {
            DefaultLongPolling defaultLongPolling = this;
            synchronized (defaultLongPolling) {
                try {
                    CLog.L.log(CLog.LL_INF, "Finish thread with error");
                    this.m_throwError = true;
                    this.notify();
                }
                catch (Throwable t) {
                    this.m_continuePolling = false;
                    CLog.L.log(CLog.LL_ERR, "Error occurred when aborting thread", t);
                    throw new Error(t);
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getLongPollingResponse() {
        return this.m_longPollingResponse;
    }

    @Override
    public void keepAlive() {
        this.updateLastResponseTime();
        this.m_throwError = false;
        try {
            if (!this.m_justWaiting) {
                return;
            }
            if (this.m_justWaitingResponse == null) {
                return;
            }
            this.m_justWaitingResponse.getWriter().write("          ");
            this.m_justWaitingResponse.getWriter().flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public long getLastResponseTime() {
        return this.m_lastResponseTime;
    }

    private void invokeMiniServerClientTrigger() {
        try {
            Class c = CCClassResolver.resolveClass("org.eclnt.miniserver.ClientTrigger", ENUMCallerType.APIWITHDIFFERENTVERSIONS);
            Method m = c.getMethod("executeClientRunnable", String.class);
            m.invoke(null, this.getURL());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when calling client", t);
        }
    }

    private boolean checkIfRunningInMiniServerMode() {
        return this.m_runningInMiniServerMode;
    }

    private void updateLastResponseTime() {
        this.m_lastResponseTime = System.currentTimeMillis();
    }
}

