/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.polling.websocket.DefaultLongPollingWebSocket;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IHttpSessionClosedReactor;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.SessionAbstractionHttpSession;
import org.eclnt.jsfserver.util.SessionAbstractionSubpageContext;
import org.eclnt.jsfserver.util.SubpageContext;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.log.CLog;

public class LongPollingMgr {
    static long LONGPOLLING_KEEPALIVE_LOOPDURATION = 15000L;
    static long s_keepAliveDuration = -1L;
    static KeepAliveThread s_keepAliveThread = new KeepAliveThread();
    static Set<ILongPolling> s_longPollings = new HashSet<ILongPolling>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(ILongPolling longPolling) {
        if (longPolling == null) {
            return;
        }
        try {
            Object spc;
            HttpSession session = HttpSessionAccess.getCurrentHttpSession();
            Boolean registered = (Boolean)session.getAttribute(LongPollingMgr.class.getName() + "/registered");
            if (registered == null) {
                session.setAttribute(LongPollingMgr.class.getName() + "/registered", (Object)true);
                HttpSessionAccess.getCurrentHttpSessionListenerDelegator().addReactor(LongPollingMgr.class.getName(), new MyHttpSessionClosedReactor());
            }
            if (!TypeOfSessionMgmt.getSessionMgmtViaCookie() && (registered = (Boolean)((SubpageContext)(spc = HttpSessionAccess.getCurrentSubpageContext())).getAttribute(LongPollingMgr.class.getName() + "/registered")) == null) {
                ((SubpageContext)spc).setAttribute(LongPollingMgr.class.getName() + "/registered", true);
                ((SubpageContext)spc).addListener(new MySubpageContextClosedReactor((SubpageContext)spc));
            }
            spc = s_longPollings;
            synchronized (spc) {
                s_longPollings.add(longPolling);
            }
            LongPollingMgr.activateKeepAliveThread();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem orccurred when adding long-polling-closed-reactor to http-session-listener", t);
            CLog.L.log(CLog.LL_INF, "The long polling will work despite this message - this is only an information message!");
        }
        HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
        hs.setAttribute("cclongpolling_" + longPolling.getId(), (Object)longPolling);
        if (TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            SubpageContext spc = HttpSessionAccess.getCurrentSubpageContext();
            spc.setAttribute("cclongpolling_" + longPolling.getId(), longPolling);
            spc.addListener(new MySubpageContextClosedReactor(spc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activateKeepAliveThread() {
        if (!LongPollingMgr.s_keepAliveThread.i_activated) {
            KeepAliveThread keepAliveThread = s_keepAliveThread;
            synchronized (keepAliveThread) {
                if (!LongPollingMgr.s_keepAliveThread.i_activated) {
                    LongPollingMgr.s_keepAliveThread.i_activated = true;
                    s_keepAliveDuration = SystemXml.getKeepAliveDuration();
                    if (s_keepAliveDuration > 0L) {
                        s_keepAliveThread.start();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ILongPolling longPolling) {
        if (longPolling == null) {
            return;
        }
        try {
            Set<ILongPolling> set = s_longPollings;
            synchronized (set) {
                s_longPollings.remove(longPolling);
            }
            HttpSession hs = null;
            try {
                hs = HttpSessionAccess.getCurrentHttpSession();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (hs != null) {
                hs.removeAttribute("cclongpolling_" + longPolling.getId());
                if (TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
                    SubpageContext spc = HttpSessionAccess.getCurrentSubpageContext();
                    spc.removeAttribute("cclongpolling_" + longPolling.getId());
                }
            }
            longPolling.wakeup(false);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when removing longPolling: " + t.toString());
        }
    }

    public static void abortAllLongPollingThreadsForSession(HttpSession session) {
        LongPollingMgr.abortAllLongPollingThreads(new SessionAbstractionHttpSession(session));
    }

    public static void abortAllLongPollingThreadsForSubpageContext(SubpageContext spc) {
        LongPollingMgr.abortAllLongPollingThreads(new SessionAbstractionSubpageContext(spc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void abortAllLongPollingThreads(ISessionAbstraction session) {
        try {
            CLog.L.log(CLog.LL_INF, "Aborting all long polling activities for " + session.getClass().getSimpleName());
            Enumeration<String> names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                if (!name.startsWith("cclongpolling_")) continue;
                try {
                    ILongPolling lp = (ILongPolling)session.getAttribute(name);
                    if (lp == null) continue;
                    Set<ILongPolling> set = s_longPollings;
                    synchronized (set) {
                        s_longPollings.remove(lp);
                    }
                    lp.abortThread();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem when aborting long polling thread", t);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when aborting longPolling: " + t.toString());
        }
    }

    public static void abortAllLongPollingThreadsForSession() {
        try {
            HttpSession session = HttpSessionAccess.getCurrentHttpSession();
            if (session != null) {
                LongPollingMgr.abortAllLongPollingThreadsForSession(session);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reprocessUnprocessedWakeupsInCurrentDialogSession() {
        LongPollingMgr.reprocessUnprocessedWakeups(HttpSessionAccess.getCurrentDialogSession());
    }

    public static void reprocessUnprocessedWakeups(ISessionAbstraction session) {
        try {
            ArrayList l = new ArrayList();
            Enumeration<String> names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                Object lpo;
                String name = names.nextElement();
                if (!name.startsWith("cclongpolling_") || !((lpo = session.getAttribute(name)) instanceof DefaultLongPollingWebSocket)) continue;
                ((DefaultLongPollingWebSocket)lpo).reprocessWakeupsWhichAreNotYetMirroredByAction();
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem during reprocessUnprocessedWakeups, " + session.getId(), t);
        }
    }

    public static void notifyLongPollingProcessed(String longPollingId, long longPollingWakeupStamp) {
        try {
            ILongPolling lp = (ILongPolling)HttpSessionAccess.getCurrentDialogSession().getAttribute("cclongpolling_" + longPollingId);
            if (lp instanceof DefaultLongPollingWebSocket) {
                ((DefaultLongPollingWebSocket)lp).notifyActionForWakeup(longPollingWakeupStamp);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem during notifyLongPollingProcessed: " + longPollingId + ", " + longPollingWakeupStamp, t);
        }
    }

    public static class MyHttpSessionClosedReactor
    implements IHttpSessionClosedReactor {
        @Override
        public void reactOnClosed() {
            LongPollingMgr.abortAllLongPollingThreadsForSession();
        }
    }

    public static class MySubpageContextClosedReactor
    implements SubpageContext.IListener {
        SubpageContext i_spc;

        public MySubpageContextClosedReactor(SubpageContext spc) {
            this.i_spc = spc;
        }

        @Override
        public void reactOnClosed() {
            LongPollingMgr.abortAllLongPollingThreadsForSubpageContext(this.i_spc);
        }
    }

    public static class KeepAliveThread
    extends Thread {
        boolean i_activated = false;

        @Override
        public void run() {
            while (this.i_activated) {
                try {
                    Thread.sleep(LONGPOLLING_KEEPALIVE_LOOPDURATION);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.keepAliveLongPollings();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAliveLongPollings() {
            CLog.L.log(CLog.LL_INF, "LONGPOLLING-KEEPALIVE: started");
            HashSet<ILongPolling> lps = new HashSet<ILongPolling>();
            Set<ILongPolling> set = s_longPollings;
            synchronized (set) {
                lps.addAll(s_longPollings);
            }
            CLog.L.log(CLog.LL_INF, "LONGPOLLING-KEEPALIVE: number of registered IPolling: " + lps.size());
            for (ILongPolling lp : lps) {
                try {
                    long lastResponse;
                    long now = System.currentTimeMillis();
                    long diffInSeconds = (now + LONGPOLLING_KEEPALIVE_LOOPDURATION - (lastResponse = lp.getLastResponseTime())) / 1000L;
                    if (diffInSeconds <= s_keepAliveDuration) continue;
                    CLog.L.log(CLog.LL_INF, "LONGPOLLING-KEEPALIVE: keeping alive long polling: " + lp.getClass().getSimpleName() + ", " + lp.getId());
                    lp.keepAlive();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

