/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.util.file.FileManager;

public class SearchFilesForString {
    public static void main(String[] args) {
        String message = "";
        try {
            boolean withDrillDown = true;
            String directory = args[0];
            directory = new File(directory).getCanonicalPath();
            ArrayList<String> searchStrings = new ArrayList<String>();
            ArrayList<String> excludedFileNames = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("@exclude@:")) {
                    excludedFileNames.add(arg.substring("@exclude@:".length()));
                    continue;
                }
                if (arg.startsWith("@message@:")) {
                    message = arg.substring("@message@:".length());
                    continue;
                }
                if ("@nodrilldown@".equals(arg)) {
                    withDrillDown = false;
                    continue;
                }
                searchStrings.add(arg);
            }
            System.out.println("Checking directory/file: " + directory);
            ArrayList<File> allFiles = new ArrayList<File>();
            File directoryFile = new File(directory);
            if (directoryFile.isDirectory()) {
                SearchFilesForString.addFileNames(directory, allFiles, withDrillDown);
            } else {
                allFiles.add(directoryFile);
            }
            System.out.println("Number of files checked: " + allFiles.size());
            for (File file : allFiles) {
                if (excludedFileNames.contains(file.getName())) continue;
                SearchFilesForString.checkFile(file, searchStrings);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Problem processing: " + args + "\n\n" + message, t);
        }
    }

    private static void checkFile(File file, List<String> searchStrings) {
        String content = null;
        try {
            content = FileManager.readUTF8File(file.getAbsolutePath(), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (content == null) {
            return;
        }
        if (content.contains("//NOCHECK")) {
            return;
        }
        for (String searchString : searchStrings) {
            boolean containsSearchString = SearchFilesForString.checkIfStringContainsSearchString(content, searchString);
            if (!containsSearchString) continue;
            throw new Error("String " + searchString + " detected in file: " + file.getAbsolutePath());
        }
    }

    public static boolean checkIfStringContainsSearchString(String content, String searchString) {
        int currentIndex = 0;
        while (true) {
            int indexNoChange;
            int index;
            if ((index = content.indexOf(searchString, currentIndex)) < 0) {
                return false;
            }
            int endIndex = content.indexOf("\n", index);
            if (endIndex < 0) {
                endIndex = content.length();
            }
            if ((indexNoChange = content.indexOf("//NOLINECHECK", index)) < 0 || indexNoChange >= endIndex) break;
            currentIndex = index + 1;
        }
        return true;
    }

    private static void addFileNames(String directory, List<File> allFiles, boolean withDrillDown) {
        List<File> dirFiles = FileManager.getFilesOfDirectory(directory);
        for (File dirFile : dirFiles) {
            allFiles.add(dirFile);
        }
        if (withDrillDown) {
            List<File> dirs = FileManager.getDirectoriesOfDirectory(directory);
            for (File dir : dirs) {
                if (dir.getAbsolutePath().endsWith("\\.svn")) continue;
                SearchFilesForString.addFileNames(dir.getAbsolutePath(), allFiles, withDrillDown);
            }
        }
    }
}

