/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclnt.jsfserver.util.CCFilterBase;
import org.eclnt.jsfserver.util.ENUMFileMode;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.util.log.CLogConstants;

public class ResourceAccessFilter
extends CCFilterBase
implements Filter,
CLogConstants,
ICCServerConstants {
    static final Map<String, ENUMFileMode> s_accessModes = new HashMap<String, ENUMFileMode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilterExecute(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            String resource = null;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            InputStream is = null;
            try {
                resource = ServletUtil.isolateResourcePath(req);
                resource = ServletUtil.updateResource(req, resource);
                WebResourceClassloaderReader.ResultInputStream ris = WebResourceClassloaderReader.readFileIntoResultInputStream(resource);
                is = ris.getResult();
                if (is == null) {
                    throw new Exception("No resource available: " + resource);
                }
                if (is.available() == 0) {
                    throw new Exception("No content in resource: " + resource);
                }
                if (ris.getFileMode() == ENUMFileMode.SOURCES) {
                    try {
                        ResourceSecurity.checkResourcePathForOutsideUsage(resource);
                    }
                    catch (Throwable tt) {
                        throw new AccessNotAllowedException("Resource not allowed to be used by http-access: " + resource);
                    }
                }
                int lastDotIndex = resource.lastIndexOf(".");
                String extension = resource.substring(lastDotIndex + 1);
                String contentType = ServletUtil.proposeContentType(extension);
                ServletUtil.setResponseContentType(resp, contentType);
                resp.setCharacterEncoding("UTF-8");
                ServletOutputStream out = resp.getOutputStream();
                byte[] buf = new byte[1024];
                int count = 0;
                while ((count = is.read(buf)) >= 0) {
                    out.write(buf, 0, count);
                }
                return;
            }
            catch (AccessNotAllowedException anae) {
                throw new ServletException((Throwable)anae);
            }
            catch (Throwable throwable) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static class AccessNotAllowedException
    extends Exception {
        public AccessNotAllowedException(String message) {
            super(message);
        }
    }
}

