/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.eclnt.jsfserver.util.CCFilterBase;
import org.eclnt.jsfserver.util.ICCServerConstants;

public class SecurityFilterURLCheck
extends CCFilterBase
implements Filter,
ICCServerConstants {
    @Override
    public void init(FilterConfig config) throws ServletException {
    }

    @Override
    public void doFilterExecute(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.checkURL(request);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected void checkURL(ServletRequest request) {
        HttpServletRequest hr = (HttpServletRequest)request;
        String url = hr.getRequestURL().toString();
        String qs = hr.getQueryString();
        String comment = url;
        if (qs != null) {
            comment = comment + "?" + qs;
        }
        this.checkString(url, comment);
        this.checkString(qs, comment);
    }

    protected void checkString(String s, String urlForComment) {
        if (s == null) {
            return;
        }
        if (s.contains("/..") || s.contains("\\..") || s.contains("../") || s.contains("..\\")) {
            throw new Error("String must not contain file navigation \"..\": " + urlForComment);
        }
    }
}

