/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import org.eclnt.jsfserver.base.faces.application.Application;
import org.eclnt.jsfserver.util.StackedValueExpression;
import org.eclnt.util.valuemgmt.ValueManager;

public class StackedComplexValueExpressionComparison
extends ValueExpression {
    Application m_app;
    String m_vbStringOriginal;
    StackedValueExpression m_valueExpression;
    String m_operator;
    String m_value = "inittiniinittini";

    public StackedComplexValueExpressionComparison(Application app, String vbString) {
        if (vbString == null) {
            throw new Error("Value binding string must not be null");
        }
        if (vbString.length() == 0) {
            throw new Error("Value binding string must not be empty");
        }
        this.m_app = app;
        this.m_vbStringOriginal = vbString;
        this.parseString();
    }

    public Object getValue(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        try {
            Object expressionValue = this.m_valueExpression.getValue(arg0);
            String sValue = ValueManager.convertObject2ValueString(expressionValue);
            if (this.m_operator.equals("==")) {
                return ValueManager.checkIfStringsAreEqual(sValue, this.m_value);
            }
            return !ValueManager.checkIfStringsAreEqual(sValue, this.m_value);
        }
        catch (Throwable t) {
            throw new Error("Error when resolving the expression: " + this.m_vbStringOriginal, t);
        }
    }

    public Class<?> getExpectedType() {
        return Boolean.TYPE;
    }

    public Class<?> getType(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return Boolean.TYPE;
    }

    public boolean isReadOnly(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return true;
    }

    public void setValue(ELContext arg0, Object arg1) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        throw new Error("Not supported with complex expression");
    }

    public boolean equals(Object arg0) {
        throw new Error("Not supported with complex expression");
    }

    public String getExpressionString() {
        return this.m_vbStringOriginal;
    }

    public int hashCode() {
        return this.m_vbStringOriginal.hashCode();
    }

    public boolean isLiteralText() {
        return false;
    }

    private void parseString() {
        try {
            int beginOperatorIndex = -1;
            int beginValueIndex = -1;
            for (int i = 0; i < this.m_vbStringOriginal.length(); ++i) {
                char c = this.m_vbStringOriginal.charAt(i);
                if (beginOperatorIndex < 0) {
                    if (c == ' ') {
                        beginOperatorIndex = i++;
                        continue;
                    }
                    if (c != '!' && c != '=') continue;
                    beginOperatorIndex = i;
                    continue;
                }
                if (beginOperatorIndex <= 0 || c == '=') continue;
                beginValueIndex = i;
                break;
            }
            String expression = this.m_vbStringOriginal.substring(0, beginOperatorIndex).trim() + "}";
            this.m_valueExpression = new StackedValueExpression(this.m_app, expression);
            this.m_operator = this.m_vbStringOriginal.substring(beginOperatorIndex, beginValueIndex).trim();
            if (!this.m_operator.equals("==") && !this.m_operator.equals("!=")) {
                throw new Exception("No comparison.");
            }
            this.m_value = this.m_vbStringOriginal.substring(beginValueIndex, this.m_vbStringOriginal.length() - 1).trim();
            if ("null".equals(this.m_value)) {
                this.m_value = null;
            }
            if (this.m_value != null && this.m_value.length() >= 2 && (this.m_value.startsWith("'") && this.m_value.endsWith("'") || this.m_value.startsWith("\"") && this.m_value.endsWith("\""))) {
                this.m_value = this.m_value.substring(1, this.m_value.length() - 1);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem parsing expression: " + this.m_vbStringOriginal, t);
        }
    }
}

