/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.util.log.CLog;

public class ThreadingSynchronization {
    static ThreadingSynchronization s_instance = new ThreadingSynchronization();
    Map<String, ReentrantLock> m_synchObjects = new Hashtable<String, ReentrantLock>();

    public static ThreadingSynchronization instance() {
        return s_instance;
    }

    public synchronized ReentrantLock getSynchObject(ISessionAbstraction dialogSession) {
        if (dialogSession != null) {
            return this.getSynchObject(dialogSession.getId());
        }
        return new ReentrantLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReentrantLock getSynchObject(String dialogSessionId) {
        if (dialogSessionId != null) {
            ReentrantLock result = this.m_synchObjects.get(dialogSessionId);
            if (result == null) {
                Map<String, ReentrantLock> map = this.m_synchObjects;
                synchronized (map) {
                    result = this.m_synchObjects.get(dialogSessionId);
                    if (result == null) {
                        result = new ReentrantLock(true);
                        this.m_synchObjects.put(dialogSessionId, result);
                    }
                }
            }
            CLog.L.log(CLog.LL_INF, "Synch object for dialog session id was requested. " + dialogSessionId);
            return result;
        }
        CLog.L.log(CLog.LL_INF, "Synch object for dialog session was requested - wihtout passing a dialogSession. Returned new Object() as result. " + dialogSessionId);
        return new ReentrantLock(true);
    }

    public void unregisterDialogSession(String subPageId) {
        if (subPageId != null) {
            this.m_synchObjects.remove(subPageId);
        }
    }

    public boolean checkIfDialogSessionIsLocked(String dialogSessionId) {
        ReentrantLock lock = this.getSynchObject(dialogSessionId);
        return lock.isLocked();
    }

    public boolean checkIfDialogSessionIsLockedByOtherThread(String dialogSessionId) {
        ReentrantLock lock = this.getSynchObject(dialogSessionId);
        boolean result = lock.isLocked();
        if (result && lock.isHeldByCurrentThread()) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSynchronized(String dialogSessionId, Runnable r) {
        ReentrantLock lock = this.getSynchObject(dialogSessionId);
        try {
            lock.lock();
            r.run();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSynchronizedIfSessionIsAvailable(String dialogSessionId, Runnable r) {
        if (this.checkIfDialogSessionIsLockedByOtherThread(dialogSessionId)) {
            return false;
        }
        ReentrantLock lock = this.getSynchObject(dialogSessionId);
        try {
            lock.lock();
            r.run();
        }
        finally {
            lock.unlock();
        }
        return true;
    }
}

