/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.security.IResourceSecurityChecker;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class ResourceSecurity {
    public static final Set<String> s_extensionsWhiteList = new HashSet<String>();
    public static final Set<IResourceSecurityChecker> s_securityCheckers = new HashSet<IResourceSecurityChecker>();

    public static void initialize() {
        List<String> exts = SystemXml.getResourceClassloaderAccessAdditionalExtensions();
        for (String ext : exts) {
            ResourceSecurity.addWhiteListExtension(ext);
        }
        List<String> checkers = SystemXml.getResourceSecurityCheckers();
        for (String checker : checkers) {
            ResourceSecurity.addResourceSecurityChecker(checker);
        }
    }

    public static void addWhiteListExtension(String extension) {
        s_extensionsWhiteList.add(ValueManager.toLowerCaseId(extension));
    }

    public static void removeWhiteListExtension(String extension) {
        s_extensionsWhiteList.remove(ValueManager.toLowerCaseId(extension));
    }

    public static synchronized void addResourceSecurityChecker(IResourceSecurityChecker checker) {
        s_securityCheckers.add(checker);
    }

    public static void checkResourcePathForOutsideUsage(String path) {
        ResourceSecurity.checkPathForOutsideUsage(path);
    }

    public static void checkClassloaderPathForOutsideUsage(String path) {
        ResourceSecurity.checkPathForOutsideUsage(path);
    }

    public static Iterator<String> getWhiteListExtensions() {
        return s_extensionsWhiteList.iterator();
    }

    private static void checkPathForOutsideUsage(String path) {
        if (path == null) {
            return;
        }
        path = ValueManager.encodeIntoValidWebResourcePath(path, false);
        for (IResourceSecurityChecker checker : s_securityCheckers) {
            Boolean result = checker.checkClassLoaderPathForOutsideUsage(path);
            if (result == null) continue;
            if (result.booleanValue()) {
                return;
            }
            if (result.booleanValue()) continue;
            throw new Error("Path not valid for outside usage: " + path + ", checked by: " + checker.getClass().getName());
        }
        int index = path.lastIndexOf(46);
        if (index < 0) {
            throw new Error("Path not valid for outside usage: " + path);
        }
        String extension = ValueManager.toLowerCaseId(path.substring(index + 1));
        if (!s_extensionsWhiteList.contains(extension)) {
            throw new Error("Path not valid for outside usage: " + path);
        }
    }

    private static void addResourceSecurityChecker(String checker) {
        try {
            IResourceSecurityChecker rsc = (IResourceSecurityChecker)CCConfigurationObjectLoader.instance().loadInstance(checker, true);
            ResourceSecurity.addResourceSecurityChecker(rsc);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem loading security checker: " + checker, t);
            throw new Error("Problem loading security checker: " + checker, t);
        }
    }

    static {
        s_extensionsWhiteList.add("bmp");
        s_extensionsWhiteList.add("css");
        s_extensionsWhiteList.add("eot");
        s_extensionsWhiteList.add("gif");
        s_extensionsWhiteList.add("giff");
        s_extensionsWhiteList.add("htm");
        s_extensionsWhiteList.add("html");
        s_extensionsWhiteList.add("jar");
        s_extensionsWhiteList.add("jpg");
        s_extensionsWhiteList.add("jpeg");
        s_extensionsWhiteList.add("js");
        s_extensionsWhiteList.add("json");
        s_extensionsWhiteList.add("map");
        s_extensionsWhiteList.add("pdf");
        s_extensionsWhiteList.add("png");
        s_extensionsWhiteList.add("svg");
        s_extensionsWhiteList.add("tif");
        s_extensionsWhiteList.add("tiff");
        s_extensionsWhiteList.add("ttf");
        s_extensionsWhiteList.add("txt");
        s_extensionsWhiteList.add("woff");
        s_extensionsWhiteList.add("woff2");
        s_extensionsWhiteList.add("ico");
    }
}

