/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.style;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.jsfserver.util.style.StyleFileAccess;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class StyleRuntimeStyleCreator {
    private static StyleRuntimeStyleCreator s_instance = new StyleRuntimeStyleCreator();

    public static StyleRuntimeStyleCreator instance() {
        return s_instance;
    }

    public static void initialize(StyleRuntimeStyleCreator instance) {
        s_instance = instance;
    }

    public void saveStyle(String styleName, SimpleStyleInfo ssi) {
        this.saveStyleXML(styleName, ssi.getBaseStyleName());
        this.saveStyleCssCML(styleName, ssi.getStyleVarValues());
    }

    public SimpleStyleInfo readStyle(String styleName) {
        String xml = StyleFileAccess.readRuntimeStyleFileUTF8(styleName, "style.xml");
        if (ValueManager.isEmpty(xml)) {
            return null;
        }
        SimpleStyleInfo result = new SimpleStyleInfo();
        this.parseStyleXml(xml, result);
        String cssXml = StyleFileAccess.readRuntimeStyleFileUTF8(styleName, "riscstyle_" + styleName + ".xml");
        if (!ValueManager.isEmpty(cssXml)) {
            this.parseStyleCssXml(cssXml, result);
        }
        return result;
    }

    public boolean checkIfStyleExists(String styleName) {
        String xml = StyleFileAccess.readRuntimeStyleFileUTF8(styleName, "style.xml");
        return !ValueManager.isEmpty(xml);
    }

    protected void saveStyleXML(String styleName, String baseStyleName) {
        CLog.L.log(CLog.LL_INF, "Writing style.xml, " + styleName + ", " + baseStyleName);
        SimpleXMLElement root = new SimpleXMLElement("style");
        root.setValue("extends", baseStyleName);
        String xml = SimpleXML.createXML(root);
        StyleFileAccess.writeRuntimeStyleFile(styleName, "style.xml", xml);
    }

    protected void saveStyleCssCML(String styleName, Map<String, String> styleValues) {
        String fileName = "riscstyle_" + styleName + ".xml";
        CLog.L.log(CLog.LL_INF, "Writing " + fileName + ", " + styleName);
        SimpleXMLElement root = new SimpleXMLElement("stylesheet");
        for (String key : styleValues.keySet()) {
            String value = styleValues.get(key);
            if (value == null) continue;
            SimpleXMLElement var = new SimpleXMLElement("var");
            var.setValue("n", key);
            var.setValue("v", value);
            root.addSubElement(var);
        }
        String xml = SimpleXML.createXML(root, true);
        StyleFileAccess.writeRuntimeStyleFile(styleName, fileName, xml);
    }

    protected void parseStyleCssXml(String xml, SimpleStyleInfo result) {
        SimpleXMLElement root = SimpleXML.parseXML(xml);
        for (SimpleXMLElement child : root.getSubElements("var")) {
            result.addStyleVarValue(child.getValue("n"), child.getValue("v"));
        }
    }

    protected void parseStyleXml(String xml, SimpleStyleInfo result) {
        SimpleXMLElement root = SimpleXML.parseXML(xml);
        result.setBaseStyleName(root.getValue("extends"));
    }

    public static class SimpleStyleInfo {
        String i_baseStyleName;
        Map<String, String> i_styleVarValues = new HashMap<String, String>();

        public String getBaseStyleName() {
            return this.i_baseStyleName;
        }

        public void setBaseStyleName(String baseStyleName) {
            this.i_baseStyleName = baseStyleName;
        }

        public Map<String, String> getStyleVarValues() {
            return this.i_styleVarValues;
        }

        public void setStyleVarValues(Map<String, String> styleVarValues) {
            this.i_styleVarValues = styleVarValues;
        }

        public void addStyleVarValue(String name, String value) {
            this.i_styleVarValues.put(name, value);
        }

        public void removeStyleVarValue(String name) {
            this.i_styleVarValues.remove(name);
        }
    }
}

