/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class BuildCSS {
    static Map<String, String> s_variables = new HashMap<String, String>();

    public static void main(String[] args) {
        try {
            throw new Error("The style management was enhanced and now ueses an XML based style definition. This function is no longer usable.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    private static void process(String fromFile, String toDirectory, String toName) {
        fromFile = ValueManager.encodeIntoValidFileName(fromFile, false);
        toDirectory = ValueManager.encodeIntoValidFileName(toDirectory, true);
        if (!FileManager.checkIfFileExists(fromFile)) {
            throw new Error("File does not exist: " + fromFile);
        }
        String riscStyleText = FileManager.readUTF8File(fromFile, true);
        riscStyleText = BuildCSS.executeMacros(riscStyleText);
        riscStyleText = BuildCSS.updateMode(riscStyleText);
        riscStyleText = BuildCSS.replaceVariables(riscStyleText);
        List<StyleInfo> sis = BuildCSS.parseRiscCss(riscStyleText);
        String jsText = BuildCSS.createJSStyles(sis);
        System.out.println("----------------------");
        String fileNameRiscJS = toDirectory + toName + ".js";
        System.out.println("Writing file: " + fileNameRiscJS);
        FileManager.writeUTF8File(fileNameRiscJS, jsText, true);
        String fileNameRiscCSS = toDirectory + toName + ".css";
        System.out.println("Writing file: " + fileNameRiscCSS);
        FileManager.writeUTF8File(fileNameRiscCSS, riscStyleText, true);
    }

    private static String executeMacros(String text) {
        int indexMacro2;
        int indexMacro;
        while ((indexMacro = text.indexOf("@macro")) >= 0 && (indexMacro2 = text.indexOf(")@", indexMacro + 6) + 1) >= 0) {
            String macro = text.substring(indexMacro + 1, indexMacro2);
            String[] macroParams = ValueManager.decodeMethodParams(macro);
            String macroContent = BuildCSS.readMacroFromClassPath(macroParams[0]);
            macroContent = macroContent.replace("@name@", macroParams[1]);
            macroContent = BuildCSS.replaceMacroReplacements(macroParams, macroContent);
            text = text.substring(0, indexMacro) + macroContent + text.substring(indexMacro2 + 1);
        }
        return text;
    }

    private static String replaceMacroReplacements(String[] macroParams, String text) {
        for (int i = 2; i < macroParams.length; ++i) {
            String param = macroParams[i];
            int index = param.indexOf("=");
            if (index < 0) continue;
            String replaceFrom = "@" + param.substring(0, index) + "@";
            String replaceTo = param.substring(index + 1);
            text = text.replace(replaceFrom, replaceTo);
        }
        return text;
    }

    private static String readMacroFromClassPath(String macroName) {
        String fileName = "org/eclnt/tool/buildcssmacros/" + macroName + ".macro.css";
        String text = new ClassloaderReader().readUTF8File(fileName, true);
        return text;
    }

    private static String updateMode(String text) {
        int index2;
        int index1;
        String activeMode = "edged";
        String removeMode = "rounded";
        if ("rounded".equals(s_variables.get("@mode@"))) {
            activeMode = "rounded";
            removeMode = "edged";
        }
        text = text.replace("@" + activeMode + "_begin@", "");
        text = text.replace("@" + activeMode + "_end@", "");
        boolean currentIndex = false;
        while ((index1 = text.indexOf("@" + removeMode + "_begin@")) >= 0 && (index2 = text.indexOf("@" + removeMode + "_end@", index1)) >= 0) {
            text = text.substring(0, index1) + text.substring(index2 + removeMode.length() + 6);
        }
        return text;
    }

    private static String replaceVariables(String text) {
        for (String key : s_variables.keySet()) {
            String value = s_variables.get(key);
            System.out.println("Replacing: " + key + " / " + value);
            text = text.replace(key, value);
        }
        return text;
    }

    public static List<StyleInfo> parseRiscCss(String text) {
        String temp;
        int indexDot;
        int index2Style;
        int index1Style;
        ArrayList<StyleInfo> result = new ArrayList<StyleInfo>();
        int currentStyleIndex = 0;
        while ((index1Style = text.indexOf("/*{RISC", currentStyleIndex)) >= 0 && (index2Style = text.indexOf("RISC}*/", index1Style)) >= index1Style && (indexDot = (temp = text.substring(0, index1Style)).lastIndexOf(".")) >= 0) {
            String styleName = temp.substring(indexDot + 1);
            styleName = BuildCSS.trimStyleName(styleName);
            System.out.println("Found style: " + styleName);
            StyleInfo si = new StyleInfo();
            si.name = styleName;
            result.add(si);
            String styleText = text.substring(index1Style + 7, index2Style);
            BuildCSS.parseRiscCssStyle(si, styleText);
            currentStyleIndex = index2Style + 7;
        }
        return result;
    }

    private static void parseRiscCssStyle(StyleInfo si, String text) {
        text = BuildCSS.trimStyleContent(text);
        Map<String, String> m = ValueManager.decodeComplexValue(text);
        for (String key : m.keySet()) {
            String value = m.get(key);
            key = BuildCSS.trimStyleContent(key);
            value = BuildCSS.trimStyleContent(value);
            si.attributes.put(key, value);
        }
    }

    private static String createJSStyles(List<StyleInfo> sis) {
        StringBuffer sb = new StringBuffer();
        StyleInfo riscSi = BuildCSS.findRiscStyle(sis);
        if (riscSi != null) {
            BuildCSS.createJSRiscStyle(riscSi, sb);
        }
        for (StyleInfo si : sis) {
            if ("risc".equals(si.name)) continue;
            BuildCSS.createJSStyle(si, sb);
        }
        return sb.toString();
    }

    private static StyleInfo findRiscStyle(List<StyleInfo> sis) {
        for (StyleInfo si : sis) {
            if (!"risc".equals(si.name)) continue;
            return si;
        }
        return null;
    }

    private static void createJSRiscStyle(StyleInfo si, StringBuffer sb) {
        for (String key : si.attributes.keySet()) {
            String value = si.attributes.get(key);
            sb.append("\nRISCSTYLE." + key + " = " + value + ";");
        }
    }

    private static void createJSStyle(StyleInfo si, StringBuffer sb) {
        String inset;
        String border;
        String background;
        List<String> parts;
        sb.append("\nRISCSTYLE." + si.name + " = ");
        sb.append("\n{");
        String font = si.attributes.get("font");
        if (font != null) {
            parts = BuildCSS.parseValue(font);
            sb.append("\n    font: new RISCFont(");
            for (int i = 0; i < parts.size(); ++i) {
                String part = parts.get(i);
                if (i != 0) {
                    sb.append(",");
                }
                if (!(i != 0 && i != 2 || part.startsWith("\""))) {
                    sb.append("\"");
                }
                sb.append(part);
                if (i != 0 && i != 2 || part.endsWith("\"")) continue;
                sb.append("\"");
            }
            sb.append("),");
        }
        if ((background = si.attributes.get("background")) != null) {
            sb.append("\n    background: \"" + background + "\",");
        }
        if ((border = si.attributes.get("border")) != null) {
            parts = BuildCSS.parseValue(border);
            String[] borders = new String[]{"0", "0", "0", "0"};
            for (int i = 0; i < parts.size(); ++i) {
                borders[i] = parts.get(i);
            }
            sb.append("\n    borderTop:" + borders[0] + ", borderRight: " + borders[1] + ", borderBottom: " + borders[2] + ", borderLeft: " + borders[3] + ",");
        }
        if ((border = si.attributes.get("margin")) != null) {
            parts = BuildCSS.parseValue(border);
            String[] borders = new String[]{"0", "0", "0", "0"};
            for (int i = 0; i < parts.size(); ++i) {
                borders[i] = parts.get(i);
            }
            sb.append("\n    marginTop:" + borders[0] + ", marginRight: " + borders[1] + ", marginBottom: " + borders[2] + ", marginLeft: " + borders[3] + ",");
        }
        if ((inset = si.attributes.get("inset")) != null) {
            parts = BuildCSS.parseValue(inset);
            String[] insets = new String[]{"0", "0", "0", "0"};
            for (int i = 0; i < parts.size(); ++i) {
                insets[i] = parts.get(i);
            }
            sb.append("\n    insetTop:" + insets[0] + ", insetRight: " + insets[1] + ", insetBottom: " + insets[2] + ", insetLeft: " + insets[3] + ",");
        }
        sb.append("\n    generated: true");
        sb.append("\n};");
    }

    private static String trimStyleName(String s) {
        if (s == null) {
            return null;
        }
        s = s.replace("\r", "");
        s = s.replace("\n", "");
        s = s.replace("\t", "");
        s = s.replace(" ", "");
        return s;
    }

    private static String trimStyleContent(String s) {
        if (s == null) {
            return null;
        }
        s = s.replace("\r", "");
        s = s.replace("\n", "");
        s = s.replace("\t", "");
        s = s.trim();
        return s;
    }

    private static List<String> parseValue(String value) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(value);
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static class StyleInfo {
        String name;
        Map<String, String> attributes = new HashMap<String, String>();
    }
}

