/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.java;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.java.JavaVersion;
import org.eclnt.util.log.ULog;

public class JavaRecordsUtil {
    static Method s_Class_isRecord = null;
    static final Set<String> s_record_methodNames = new HashSet<String>();

    public static boolean checkIfClassIsRecord(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (!JavaVersion.isSupportingRecords()) {
            return false;
        }
        if (s_Class_isRecord == null) {
            return false;
        }
        try {
            Boolean result = (Boolean)s_Class_isRecord.invoke((Object)clazz, new Object[0]);
            if (result != null) {
                return result;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean checkIfObjectIsRecord(Object base) {
        if (base == null) {
            return false;
        }
        return JavaRecordsUtil.checkIfClassIsRecord(base.getClass());
    }

    public static boolean checkIfMethodIsRecordClassMethod(String methodName) {
        return s_record_methodNames.contains(methodName);
    }

    static {
        try {
            if (JavaVersion.isSupportingRecords()) {
                Method[] ms;
                Class c = Class.class;
                Method m = c.getMethod("isRecord", new Class[0]);
                if (m != null) {
                    s_Class_isRecord = m;
                }
                c = CCClassResolver.resolveClass("java.lang.Record", ENUMCallerType.UTIL);
                for (Method m2 : ms = c.getMethods()) {
                    s_record_methodNames.add(m2.getName());
                }
            }
        }
        catch (Throwable t) {
            ULog.logERR("Problem initializing Java-record util", t);
        }
    }
}

