/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import com.veracode.annotation.CRLFCleanser;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ULog {
    public static final Level LL_ERR = Level.SEVERE;
    public static final Level LL_WAR = Level.WARNING;
    public static final Level LL_INF = Level.INFO;
    public static final Level LL_DBG = Level.FINE;
    private static Logger L = Logger.getLogger("org.eclnt.util.log");

    public static void initializeLogger(Logger l) {
        L = l;
    }

    public static void logDBG(String s) {
        ULog.doLog(LL_DBG, s, null);
    }

    public static void logINF(String s) {
        ULog.doLog(LL_INF, s, null);
    }

    public static void logWAR(String s) {
        ULog.doLog(LL_WAR, s, null);
    }

    public static void logERR(String s) {
        ULog.doLog(LL_ERR, s, null);
    }

    public static void logDBG(String s, Throwable t) {
        ULog.doLog(LL_DBG, s, t);
    }

    public static void logINF(String s, Throwable t) {
        ULog.doLog(LL_INF, s, t);
    }

    public static void logWAR(String s, Throwable t) {
        ULog.doLog(LL_WAR, s, t);
    }

    public static void logERR(String s, Throwable t) {
        ULog.doLog(LL_ERR, s, t);
    }

    @CRLFCleanser(userComment="The logger that is used is passed by the application using the initializeLogger()-method. This logger needs to be one which is CRLF-approved. When running in CaptainCasa server environment then thelogger that is initialized is one that uses ESAPI-encoding for proper log output.")
    private static void doLog(Level l, String s, Throwable t) {
        L.log(l, s, t);
    }

    static {
        L.setLevel(Level.INFO);
    }
}

