/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long m_count = 0L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result >= 0) {
            ++this.m_count;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        this.m_count += (long)result;
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        this.m_count += n;
        return super.skip(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.m_count = 0L;
        super.reset();
    }

    public long getCount() {
        return this.m_count;
    }
}

