/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclnt.util.valuemgmt.ValueManager;

public class LocalDate18Manager {
    static TimeZone s_gmt = TimeZone.getTimeZone("GMT");

    public static String convertObject2ValueString(Object o) {
        if (o instanceof LocalDate) {
            LocalDate ld = (LocalDate)o;
            Calendar cal = Calendar.getInstance(s_gmt);
            cal.clear();
            cal.set(1, ld.getYear());
            cal.set(2, ld.getMonthValue() - 1);
            cal.set(5, ld.getDayOfMonth());
            return "" + cal.getTime().getTime();
        }
        if (o instanceof LocalTime) {
            LocalTime ld = (LocalTime)o;
            Calendar cal = Calendar.getInstance(s_gmt);
            cal.clear();
            cal.set(11, ld.getHour());
            cal.set(12, ld.getMinute());
            cal.set(13, ld.getSecond());
            cal.set(14, ld.getNano() / 1000000);
            return "" + cal.getTime().getTime();
        }
        if (o instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)o;
            Calendar cal = Calendar.getInstance(s_gmt);
            cal.clear();
            cal.set(1, ldt.getYear());
            cal.set(2, ldt.getMonthValue() - 1);
            cal.set(5, ldt.getDayOfMonth());
            cal.set(11, ldt.getHour());
            cal.set(12, ldt.getMinute());
            cal.set(13, ldt.getSecond());
            cal.set(14, ldt.getNano() / 1000000);
            return "" + cal.getTime().getTime();
        }
        return null;
    }

    public static Object convertStringIntoObject(String attrValue, Class attrClass) {
        if (attrClass == LocalDate.class) {
            long l = ValueManager.decodeLong(attrValue, -1L);
            Calendar cal = Calendar.getInstance(s_gmt);
            cal.setTime(new Date(l));
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            LocalDate ld = LocalDate.of(year, month, day);
            return ld;
        }
        if (attrClass == LocalTime.class) {
            long l = ValueManager.decodeLong(attrValue, -1L);
            Calendar cal = Calendar.getInstance(s_gmt);
            cal.setTime(new Date(l));
            int hour = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int milli = cal.get(14) * 1000000;
            LocalTime ld = LocalTime.of(hour, minute, second, milli);
            return ld;
        }
        if (attrClass == LocalDateTime.class) {
            long l = ValueManager.decodeLong(attrValue, -1L);
            Calendar cal = Calendar.getInstance(s_gmt);
            cal.setTime(new Date(l));
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int hour = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int milli = cal.get(14) * 1000000;
            LocalDateTime ldt = LocalDateTime.of(year, month, day, hour, minute, second, milli);
            return ldt;
        }
        return null;
    }

    public static Date convertLocalDateToDate(LocalDate ld, String timezone) {
        if (ld == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.clear();
        cal.set(1, ld.getYear());
        cal.set(2, ld.getMonthValue() - 1);
        cal.set(5, ld.getDayOfMonth());
        return cal.getTime();
    }

    public static Date convertLocalTimeToDate(LocalTime ld, String timezone) {
        if (ld == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.clear();
        cal.set(11, ld.getHour());
        cal.set(12, ld.getMinute());
        cal.set(13, ld.getSecond());
        cal.set(14, ld.getNano() / 1000000);
        return cal.getTime();
    }

    public static Date convertLocalDateTimeToDate(LocalDateTime ldt, String timezone) {
        if (ldt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.clear();
        cal.set(1, ldt.getYear());
        cal.set(2, ldt.getMonthValue() - 1);
        cal.set(5, ldt.getDayOfMonth());
        cal.set(11, ldt.getHour());
        cal.set(12, ldt.getMinute());
        cal.set(13, ldt.getSecond());
        cal.set(14, ldt.getNano() / 1000000);
        return cal.getTime();
    }

    public static LocalDate convertDateToLocalDate(Date d, String timezone) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.setTime(d);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        LocalDate result = LocalDate.of(year, month, day);
        return result;
    }

    public static LocalTime convertDateToLocalTime(Date d, String timezone) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.setTime(d);
        int hour = cal.get(10);
        int minute = cal.get(12);
        int second = cal.get(13);
        int milli = cal.get(14) * 1000000;
        LocalTime result = LocalTime.of(hour, minute, second, milli);
        return result;
    }

    public static LocalDateTime convertDateTimeToLocalTime(Date d, String timezone) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.setTime(d);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(10);
        int minute = cal.get(12);
        int second = cal.get(13);
        int milli = cal.get(14) * 1000000;
        LocalDateTime result = LocalDateTime.of(year, month, day, hour, minute, second, milli);
        return result;
    }

    public static Date convertLocalDateObjectToDate(Object o, String timezone) {
        if (o instanceof LocalDate) {
            return LocalDate18Manager.convertLocalDateToDate((LocalDate)o, timezone);
        }
        if (o instanceof LocalDateTime) {
            return LocalDate18Manager.convertLocalDateTimeToDate((LocalDateTime)o, timezone);
        }
        if (o instanceof LocalTime) {
            return LocalDate18Manager.convertLocalTimeToDate((LocalTime)o, timezone);
        }
        return null;
    }

    public static boolean checkIfObjectIsLocalDateObject(Object o) {
        if (o instanceof LocalDate) {
            return true;
        }
        if (o instanceof LocalDateTime) {
            return true;
        }
        return o instanceof LocalTime;
    }
}

