/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.ImageSelection;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedBean;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.workplace.IFavoritesListener;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.WorkplaceUtil;

public class WorkplaceFavoritesSquare
extends DefaultDispatchedBean
implements Serializable {
    WorkpageStartInfo m_empty;
    String m_defaultImage = StyleManager.getStyleValue("ccWpFavoriteImage");
    String m_emptyImage = "/eclntjsfserver/images/control_empty.png";
    String m_emptyText = "";
    List<BigFavoriteInfo> m_bigFavorites = new ArrayList<BigFavoriteInfo>();
    String m_iconDirectoryPath = "/eclntjsfserver/images/";
    List<IFavoritesListener> m_favoritesListeners = new ArrayList<IFavoritesListener>();

    public WorkplaceFavoritesSquare(IDispatcher dispatcher) {
        this(dispatcher, null, null);
    }

    public WorkplaceFavoritesSquare(IDispatcher dispatcher, String emptyImage, String emptyText) {
        super(dispatcher);
        this.m_empty = new WorkpageStartInfo();
        if (emptyImage != null) {
            this.m_emptyImage = emptyImage;
        }
        if (emptyText != null) {
            this.m_emptyText = emptyText;
        }
        this.m_empty.setImage(this.m_emptyImage);
        this.m_empty.setText(this.m_emptyText);
        for (int i = 0; i < 9; ++i) {
            BigFavoriteInfo bfi = new BigFavoriteInfo(this.m_empty);
            this.m_bigFavorites.add(bfi);
        }
    }

    public void addFavoritesListener(IFavoritesListener listener) {
        this.m_favoritesListeners.add(listener);
    }

    public void removeFavoritesListener(IFavoritesListener listener) {
        this.m_favoritesListeners.remove(listener);
    }

    public void setDefaultImage(String value) {
        this.m_defaultImage = value;
    }

    public String getDefaultImage() {
        return this.m_defaultImage;
    }

    public void updateBigFavoriteInfo(int index, WorkpageStartInfo fi) {
        this.m_bigFavorites.get((int)index).i_favoriteInfo = fi;
    }

    public List<BigFavoriteInfo> getBigFavorites() {
        return this.m_bigFavorites;
    }

    public List<WorkpageStartInfo> getFavoriteInfos() {
        ArrayList<WorkpageStartInfo> result = new ArrayList<WorkpageStartInfo>();
        for (BigFavoriteInfo bf : this.m_bigFavorites) {
            result.add(bf.getFi());
        }
        return result;
    }

    public void setIconDirectoryPath(String path) {
        this.m_iconDirectoryPath = path;
    }

    private void configureIcon(WorkpageStartInfo fi) {
        ModalPopup popup = ModalPopup.createInstance();
        ImageSelectionListener isl = new ImageSelectionListener(popup, fi);
        popup.open("/eclntjsfserver/popups/imageselection.jsp", "Favorite Icon", 300, 300, isl);
        ImageSelection is = DefaultScreens.getSessionAccess().getImageSelection();
        is.prepare(isl, this.m_iconDirectoryPath);
    }

    private void notifyFavoritesListeners() {
        for (IFavoritesListener listener : this.m_favoritesListeners) {
            listener.notifyFavoritesUpdate();
        }
    }

    public class BigFavoriteInfo
    implements Serializable {
        WorkpageStartInfo i_favoriteInfo;

        public BigFavoriteInfo(WorkpageStartInfo favoriteInfo) {
            this.i_favoriteInfo = favoriteInfo;
        }

        public WorkpageStartInfo getFi() {
            return this.i_favoriteInfo;
        }

        public String getDragSend() {
            if (this.i_favoriteInfo.getJspPage() == null) {
                return null;
            }
            return WorkplaceUtil.encodePageInfo(this.i_favoriteInfo);
        }

        public void onFavoriteAction(ActionEvent event) {
            BaseActionEvent bae = (BaseActionEvent)event;
            if (event instanceof BaseActionEventInvoke) {
                if (this.i_favoriteInfo.getJspPage() == null) {
                    return;
                }
                IWorkpageDispatcher wpd = (IWorkpageDispatcher)WorkplaceFavoritesSquare.this.getOwningDispatcher();
                WorkpageStarterFactory.getWorkpageStarter().startWorkpage(wpd, wpd.getWorkpageContainer(), this.i_favoriteInfo);
            } else if (event instanceof BaseActionEventDrop) {
                BaseActionEventDrop baed = (BaseActionEventDrop)event;
                WorkpageStartInfo dpi = WorkplaceUtil.decodeDroppedWorkpage(baed.getDragInfo());
                if (dpi != null) {
                    if (dpi.getImage() == null) {
                        dpi.setImage(WorkplaceFavoritesSquare.this.m_defaultImage);
                    }
                    this.i_favoriteInfo = dpi;
                }
                WorkplaceFavoritesSquare.this.notifyFavoritesListeners();
            } else if (bae.getCommand().equals("cmdRemoveFavorite")) {
                this.i_favoriteInfo = WorkplaceFavoritesSquare.this.m_empty;
                WorkplaceFavoritesSquare.this.notifyFavoritesListeners();
            } else if (bae.getCommand().equals("cmdConfigureIcon")) {
                WorkplaceFavoritesSquare.this.configureIcon(this.i_favoriteInfo);
            }
        }
    }

    public class ImageSelectionListener
    implements ModalPopup.IModalPopupListener,
    ImageSelection.IImageSelectionListener,
    Serializable {
        ModalPopup i_popup;
        WorkpageStartInfo i_favoriteInfo;

        public ImageSelectionListener(ModalPopup popup, WorkpageStartInfo favoriteInfo) {
            this.i_favoriteInfo = favoriteInfo;
            this.i_popup = popup;
        }

        @Override
        public void reactOnPopupClosedByUser() {
            this.i_popup.close();
        }

        @Override
        public void imageSelected(String image) {
            this.i_popup.close();
            this.i_favoriteInfo.setImage(image);
            WorkplaceFavoritesSquare.this.notifyFavoritesListeners();
        }
    }
}

